/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.common.business.configfile.boolexpr;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.onx.common.business.configfile.ConfFilePosition;
import de.justsoftware.onx.common.business.configfile.LoadConfigFileException;
import de.justsoftware.onx.common.business.configfile.boolexpr.BoolExpr;
import de.justsoftware.onx.common.business.configfile.boolexpr.BoolExprVisitor;
import de.justsoftware.onx.common.business.configfile.boolexpr.EvalContext;
import de.justsoftware.onx.common.business.configfile.boolexpr.EvalException;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class OrExpr
extends BoolExpr {
    final ImmutableSet<BoolExpr> _exprs;

    OrExpr(@Nullable ConfFilePosition pos, @Nonnull ImmutableSet<BoolExpr> exprs) {
        super(pos);
        this._exprs = exprs;
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this._exprs});
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj || obj != null && obj instanceof OrExpr && Objects.equal(this._exprs, ((OrExpr)obj)._exprs);
    }

    @Override
    public String toString() {
        if (this._exprs.isEmpty()) {
            return BoolExpr.FALSE.toString();
        }
        StringBuilder b = new StringBuilder();
        b.append("(");
        boolean first = true;
        for (BoolExpr e : this._exprs) {
            if (!first) {
                b.append(" or ");
            }
            b.append(e);
            first = false;
        }
        b.append(")");
        return b.toString();
    }

    @Override
    public BoolExpr eval(EvalContext context) throws EvalException {
        for (BoolExpr e : this._exprs) {
            if (!TRUE.equals(e)) continue;
            return e;
        }
        ImmutableSet.Builder resultBuilder = ImmutableSet.builder();
        for (BoolExpr e : this._exprs) {
            BoolExpr r = e.eval(context);
            if (TRUE.equals(r)) {
                return r;
            }
            if (r instanceof OrExpr) {
                resultBuilder.addAll(((OrExpr)r)._exprs);
                continue;
            }
            if (FALSE.equals(r)) continue;
            resultBuilder.add((Object)r);
        }
        ImmutableSet result = resultBuilder.build();
        if (this._exprs.equals((Object)result)) {
            return this;
        }
        return OrExpr.or(this.getPos(), (Iterable<? extends BoolExpr>)result);
    }

    @Override
    public void checkVariables(Set<String> allowedVariables) throws LoadConfigFileException {
        for (BoolExpr e : this._exprs) {
            e.checkVariables(allowedVariables);
        }
    }

    @Nonnull
    public ImmutableSet<BoolExpr> getExprs() {
        return this._exprs;
    }

    @Override
    public <T> T accept(BoolExprVisitor<T> visitor) {
        return visitor.visit(this);
    }
}

