/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.common.business.configfile.boolexpr;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.onx.common.business.configfile.boolexpr.EvalException;
import de.justsoftware.onx.common.business.configfile.boolexpr.ImmutableBoolContext;
import de.justsoftware.onx.common.shared.model.NameAndParam;
import javax.annotation.Nonnull;

public enum BoolContexts implements ImmutableBoolContext
{
    EMPTY_CONTEXT{

        @Override
        public boolean getValueOf(NameAndParam variableName) throws EvalException {
            throw new EvalException("EMPTY_CONTEXT has no variables");
        }
    }
    ,
    ALWAYS_TRUE{

        @Override
        public boolean getValueOf(NameAndParam variableName) throws EvalException {
            return true;
        }
    };


    @Nonnull
    public static final ImmutableBoolContext multiMatch(@Nonnull ImmutableSet<NameAndParam> matches) {
        return new SetBoolContext(matches);
    }

    @Nonnull
    public static final ImmutableBoolContext singleMatch(@Nonnull String match) {
        return BoolContexts.singleMatch((NameAndParam)NameAndParam.FROM_STRING_NO_PARAM.apply((Object)match));
    }

    @Nonnull
    private static ImmutableBoolContext singleMatch(@Nonnull NameAndParam nameAndParam) {
        return BoolContexts.multiMatch((ImmutableSet<NameAndParam>)ImmutableSet.of((Object)nameAndParam));
    }

    private static final class SetBoolContext
    implements ImmutableBoolContext {
        private final ImmutableSet<NameAndParam> _set;

        public SetBoolContext(@Nonnull ImmutableSet<NameAndParam> set) {
            this._set = set;
        }

        @Override
        public boolean getValueOf(NameAndParam variableName) throws EvalException {
            return this._set.contains((Object)variableName);
        }

        @Override
        public final boolean equals(Object obj) {
            return this == obj || obj != null && this.getClass().equals(obj.getClass()) && this._set.equals(((SetBoolContext)obj)._set);
        }

        @Override
        public final int hashCode() {
            return this._set.hashCode();
        }

        public String toString() {
            return "[" + Joiner.on((String)", ").join(this._set) + "]";
        }
    }
}

