/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.comments.shared.model;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.onx.comments.shared.model.CommentId;
import de.justsoftware.onx.comments.shared.model.db.DBComment;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.common.shared.model.action.Action;
import de.justsoftware.onx.common.shared.util.Dates;
import de.justsoftware.onx.container.shared.model.Identifiable;
import de.justsoftware.onx.container.shared.model.ItemId;
import de.justsoftware.onx.person.shared.model.PersonTeaserModel;
import java.io.Serializable;
import java.util.Date;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class GenericComment
implements Identifiable<CommentId>,
Serializable {
    private static final long serialVersionUID = 1L;
    private ImmutableSet<Action> _permissions;
    private CommentId _id;
    private String _text;
    private String _editorModel;
    private Date _postedAt;
    private ItemId _parentId;
    private String _customInfo;
    private PersonTeaserModel _author;
    private PersonId _authorId;
    private Date _editedAt;
    private PersonId _editorId;
    private PersonTeaserModel _editor;

    @Deprecated
    public GenericComment() {
    }

    public GenericComment(@Nonnull DBComment from, @Nullable PersonTeaserModel author, @Nullable PersonTeaserModel editor, @Nonnull ImmutableSet<Action> permissions) {
        this._author = author;
        this._editor = editor;
        this._authorId = from.getAuthorId();
        this._permissions = permissions;
        this._id = from.getId();
        this._text = from.getText();
        this._postedAt = Dates.clone(from.getPostedAt());
        this._parentId = from.getParentId();
        this._customInfo = from.getCustomInfo();
        this._editedAt = from.getEditedAt();
        this._editorId = from.getEditorId();
        this._editorModel = from.getEditorModel();
    }

    @CheckForNull
    public PersonTeaserModel getAuthor() {
        return this._author;
    }

    @CheckForNull
    public PersonId getAuthorId() {
        return this._authorId;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this._id).add("text", (Object)this._text).add("postetAt", (Object)this._postedAt).add("parentId", (Object)this._parentId).add("customInfo", (Object)this._customInfo).add("author", (Object)this._author).add("authorId", (Object)this._authorId).add("permissions", this._permissions).toString();
    }

    public String getText() {
        return this._text;
    }

    public Date getPostedAt() {
        return Dates.clone(this._postedAt);
    }

    public ItemId getParentId() {
        return this._parentId;
    }

    @Override
    public CommentId getId() {
        return this._id;
    }

    @CheckForNull
    public String getCustomInfo() {
        return this._customInfo;
    }

    @Nonnull
    public ImmutableSet<Action> getPermissions() {
        return this._permissions;
    }

    @CheckForNull
    public Date getEditedAt() {
        return Dates.clone(this._editedAt);
    }

    @CheckForNull
    public PersonId getEditorId() {
        return this._editorId;
    }

    @CheckForNull
    public PersonTeaserModel getEditor() {
        return this._editor;
    }

    @CheckForNull
    public String getEditorModel() {
        return this._editorModel;
    }
}

