/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.comments.integration.persistence.ibatis;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSetMultimap;
import de.justsoftware.onx.comments.integration.persistence.CommentsDAO;
import de.justsoftware.onx.comments.shared.model.CommentId;
import de.justsoftware.onx.comments.shared.model.db.DBComment;
import de.justsoftware.onx.common.integration.persistence.StatementBuilderFactory;
import de.justsoftware.onx.common.integration.persistence.ibatis.IbatisPartitionResultBuilder;
import de.justsoftware.onx.common.integration.persistence.ibatis.IbatisStatementBuilder;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.container.shared.model.ItemId;
import java.util.Date;
import java.util.Set;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
@ParametersAreNonnullByDefault
public class IbatisCommentsDAO
implements CommentsDAO {
    private final IbatisStatementBuilder _statementBuilder;

    @Autowired
    public IbatisCommentsDAO(StatementBuilderFactory statementBuilderFactory) {
        this._statementBuilder = statementBuilderFactory.ibatistStatementBuilder("MdlComments");
    }

    @Override
    public ImmutableSetMultimap<ItemId, CommentId> getCommentIdsByParentIds(Set<? extends ItemId> parentIds) {
        return ((IbatisPartitionResultBuilder)this._statementBuilder.select("getCommentIdsByParentIds").partition(parentIds)).asSetMultimap("parent_id", "comment_id");
    }

    @Override
    public CommentId addComment(DBComment comment) {
        return (CommentId)this._statementBuilder.insertDbSpecific("addComment").param(comment).get();
    }

    @Override
    public ImmutableMap<CommentId, DBComment> getDBCommentsByIds(Set<CommentId> ids) {
        return ((IbatisPartitionResultBuilder)this._statementBuilder.select("getCommentsByIds").partition(ids)).asMap("id", null);
    }

    @Override
    public ImmutableMap<ItemId, Integer> getCommentCounts(Set<? extends ItemId> parentIds) {
        return ((IbatisPartitionResultBuilder)this._statementBuilder.select("getCommentCounts").partition(parentIds)).asMap("id", "count");
    }

    @Override
    public void deleteComments(Set<CommentId> ids) {
        this._statementBuilder.delete("deleteComments").partition(ids);
    }

    @Override
    public void setCommentText(CommentId id, String text, String editorModel, PersonId editorId, Date editDate) {
        if (editorModel == null) {
            this._statementBuilder.update("setCommentText").param("id", id, "text", text, "editorId", editorId, "editorDate", editDate);
        } else {
            this._statementBuilder.update("setCommentText").param("id", id, "text", text, "editorModel", editorModel, "editorId", editorId, "editorDate", editDate);
        }
    }
}

