/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.comments.business.impl;

import com.freiheit.toro.admin.shared.server.superoperty.Settings;
import com.freiheit.toro.cache.CacheKey;
import com.freiheit.toro.cache.CacheName;
import com.freiheit.toro.common.shared.model.InvalidIdServiceException;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Sets;
import de.justsoftware.onx.authorization.business.AuthorizationCheckContextWithLocale;
import de.justsoftware.onx.authorization.business.AuthorizationCheckContextWithUserId;
import de.justsoftware.onx.comments.business.CommentsService;
import de.justsoftware.onx.comments.business.events.CommentCreatedEvent;
import de.justsoftware.onx.comments.business.events.CommentUpdatedEvent;
import de.justsoftware.onx.comments.integration.persistence.CommentsDAO;
import de.justsoftware.onx.comments.shared.model.CommentId;
import de.justsoftware.onx.comments.shared.model.GenericComment;
import de.justsoftware.onx.comments.shared.model.db.DBComment;
import de.justsoftware.onx.common.business.CacheHelper;
import de.justsoftware.onx.common.business.events.JCEventBus;
import de.justsoftware.onx.common.deletion.DeleteTransactionCallback;
import de.justsoftware.onx.common.deletion.DeletionContext;
import de.justsoftware.onx.common.deletion.DeletionService;
import de.justsoftware.onx.common.deletion.TransactionCallbackWithDeleteAction;
import de.justsoftware.onx.common.deletion.model.DeleteAction;
import de.justsoftware.onx.common.shared.model.ListAndCount;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.common.shared.model.ProfileId;
import de.justsoftware.onx.common.shared.model.action.Action;
import de.justsoftware.onx.common.shared.model.action.StaticAction;
import de.justsoftware.onx.common.shared.util.Multimaps2;
import de.justsoftware.onx.container.business.events.CommentDeletedEvent;
import de.justsoftware.onx.container.shared.model.GlobalId;
import de.justsoftware.onx.container.shared.model.ItemId;
import de.justsoftware.onx.container.shared.model.ValueEmptyException;
import de.justsoftware.onx.container.shared.model.ValueTooLargeException;
import de.justsoftware.onx.person.shared.model.PersonTeaserModel;
import de.justsoftware.onx.profile.business.ProfileTeaserService;
import de.justsoftware.onx.util.server.QuillParseUtils;
import de.justsoftware.onx.util.shared.NullPermeableFunction;
import de.justsoftware.toolbox.clock.Clock;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.TransactionStatus;

@Service
@ParametersAreNonnullByDefault
public class CommentsServiceImpl
implements CommentsService {
    private static final ImmutableSet<? extends Action> BULK_CHECK_COMMENT_ACTIONS = ImmutableSet.of((Object)StaticAction.COMMENT_DELETE, (Object)StaticAction.COMMENT_EDIT);
    @Autowired
    private ProfileTeaserService _profileTeaserService;
    @Autowired
    private CacheHelper _cacheHelper;
    @Autowired
    private CommentsDAO _commentsDAO;
    @Autowired
    private DeletionService _deletionService;
    @Autowired
    private JCEventBus _eventBus;
    @Autowired
    private Settings _settings;
    @Autowired
    private Clock _clock;

    @Nonnull
    private static CacheKey cacheKeyCommentIdsByParentId(ItemId id) {
        return new CacheKey((CacheName)CommentServiceCacheName.COMMENT_IDS_BY_PARENT_ID, id);
    }

    @Nonnull
    private static CacheKey cacheKeyDBComment(CommentId id) {
        return new CacheKey((CacheName)CommentServiceCacheName.COMMENT_BY_ID, id);
    }

    @Nonnull
    private static CacheKey cacheKeyCommentCount(ItemId id) {
        return new CacheKey((CacheName)CommentServiceCacheName.COMMENT_COUNT_BY_PARENT_ID, id);
    }

    private void checkLength(@Nullable String text) throws ValueTooLargeException, ValueEmptyException {
        int length = StringUtils.length((String)text);
        if (length <= 0) {
            throw new ValueEmptyException();
        }
    }

    @Override
    public DBComment getDBCommentById(CommentId id) {
        return this.getDBCommentByIds((Set<CommentId>)ImmutableSet.of((Object)id)).get(id);
    }

    @Override
    public Map<CommentId, DBComment> getDBCommentByIds(Set<CommentId> commentIds) {
        return this._cacheHelper.getByIdsMap(commentIds, new CacheHelper.GetByIdsInterface<CommentId, DBComment>(){

            @Override
            public CacheKey cacheKey(CommentId id) {
                return CommentsServiceImpl.cacheKeyDBComment(id);
            }

            @Override
            public Map<CommentId, DBComment> ibatisGetByIds(Set<CommentId> ids) {
                return CommentsServiceImpl.this._commentsDAO.getDBCommentsByIds(ids);
            }
        });
    }

    @Override
    public CommentId addComment(String text, String customInfo, ItemId parentId, String editorModel, AuthorizationCheckContextWithUserId authorizationContext) {
        authorizationContext.check(parentId, (Action)StaticAction.COMMENT_CREATE);
        this.checkLength(text);
        DBComment comment = new DBComment(new Date());
        PersonId authorId = authorizationContext.getUserId();
        comment.setAuthorId(authorId);
        comment.setParentId(parentId);
        comment.setText(text);
        comment.setEditorModel(editorModel);
        comment.setCustomInfo(customInfo);
        CommentId newId = this._commentsDAO.addComment(comment);
        this.invalidateCaches(newId, parentId);
        this._eventBus.post(new CommentCreatedEvent((DBComment)this._commentsDAO.getDBCommentsByIds((Set<CommentId>)ImmutableSet.of((Object)newId)).get((Object)newId), this.getAddedMentionedPersons(null, editorModel)));
        return newId;
    }

    private ImmutableSet<PersonId> getAddedMentionedPersons(@Nullable String previousQuillDelta, String newQuillDelta) {
        ImmutableSet<ProfileId> previousMentionedPersons = QuillParseUtils.parseMentions(previousQuillDelta);
        ImmutableSet<ProfileId> currentMentionedPersons = QuillParseUtils.parseMentions(newQuillDelta);
        return (ImmutableSet)Sets.difference(currentMentionedPersons, previousMentionedPersons).stream().map(ProfileId::asPersonId).collect(ImmutableSet.toImmutableSet());
    }

    @Override
    public void deleteComment(final CommentId id, AuthorizationCheckContextWithUserId authorizationContext) {
        DBComment comment = this.getDBCommentById(id);
        if (comment == null) {
            return;
        }
        authorizationContext.check((ItemId)id, (Action)StaticAction.COMMENT_DELETE);
        this._deletionService.deleteInTransactionWithDeleteAction(id, authorizationContext.getUserId(), new TransactionCallbackWithDeleteAction<Object>(){

            @Override
            public Object doInTransactionWithDeleteAction(TransactionStatus status, DeleteAction deleteAction) {
                CommentsServiceImpl.this._commentsDAO.deleteComments((Set<CommentId>)ImmutableSet.of((Object)id));
                return this;
            }
        });
        this.invalidateCaches(id, comment.getParentId());
        this._eventBus.post(new CommentDeletedEvent(comment));
    }

    @Override
    public Integer getCommentCount(ItemId id) {
        Integer cnt = (Integer)this.getCommentsCounts((Set<? extends ItemId>)ImmutableSet.of((Object)id)).get((Object)id);
        return cnt != null ? cnt : Integer.valueOf(0);
    }

    @Override
    public ImmutableMap<ItemId, Integer> getCommentsCounts(Set<? extends ItemId> ids) {
        if (ids.isEmpty()) {
            return ImmutableMap.of();
        }
        Map<ItemId, Integer> mapping = this._cacheHelper.getByIdsMap(ids, new CacheHelper.GetByIdsInterface<ItemId, Integer>(){

            @Override
            public CacheKey cacheKey(ItemId id) {
                return CommentsServiceImpl.cacheKeyCommentCount(id);
            }

            @Override
            public Map<ItemId, Integer> ibatisGetByIds(Set<ItemId> itemIds) {
                return CommentsServiceImpl.this._commentsDAO.getCommentCounts(itemIds);
            }
        });
        return ImmutableMap.copyOf(mapping);
    }

    @Nonnull
    private ImmutableSet<CommentId> getCommentIdsByParent(GlobalId parentId) {
        return this.getCommentIdsByParentIds((Set<? extends ItemId>)ImmutableSet.of((Object)parentId)).get((Object)parentId);
    }

    @Override
    public ImmutableListMultimap<ItemId, DBComment> getDBCommentsByParents(Set<? extends ItemId> parents) {
        ImmutableSetMultimap<ItemId, CommentId> byId = this.getCommentIdsByParentIds(parents);
        Map<CommentId, DBComment> comments = this.getDBCommentByIds((Set<CommentId>)ImmutableSet.copyOf((Collection)byId.values()));
        ImmutableListMultimap.Builder result = ImmutableListMultimap.builder();
        for (Map.Entry entry : byId.entries()) {
            DBComment comment = comments.get(entry.getValue());
            if (comment == null) continue;
            result.put((Object)((ItemId)entry.getKey()), (Object)comment);
        }
        return result.build();
    }

    @Override
    public ImmutableMap<ItemId, ListAndCount<GenericComment>> getCommentsByParentIds(Set<? extends ItemId> parentIds, int max, boolean newestFirst, AuthorizationCheckContextWithLocale authorizationContext) {
        ImmutableSetMultimap<ItemId, CommentId> commentIds = this.getCommentIdsByParentIds(parentIds);
        ImmutableSetMultimap.Builder interestingBuilder = ImmutableSetMultimap.builder();
        for (ItemId itemId : parentIds) {
            ImmutableSet ids = commentIds.get((Object)itemId);
            int remain = ids.size() - max;
            int offset = remain > 1 ? remain : 0;
            interestingBuilder.putAll((Object)itemId, (Iterable)ids.asList().subList(offset, ids.size()));
        }
        ImmutableSetMultimap interesting = interestingBuilder.build();
        ImmutableSet immutableSet = ImmutableSet.copyOf((Collection)interesting.values());
        Map<CommentId, DBComment> interestingComments = this.getDBCommentByIds((Set<CommentId>)immutableSet);
        Function mapFunction = Functions.compose((Function)new MapDBCommentFunction(authorizationContext, interestingComments), (Function)Functions.forMap(interestingComments, null));
        ImmutableMap.Builder resultBuilder = ImmutableMap.builder();
        for (ItemId itemId : parentIds) {
            ImmutableList interestingIds = interesting.get((Object)itemId).asList();
            FluentIterable comments = FluentIterable.from((Iterable)(newestFirst ? interestingIds.reverse() : interestingIds)).transform(mapFunction).filter(Predicates.notNull());
            resultBuilder.put((Object)itemId, new ListAndCount(commentIds.get((Object)itemId).size(), comments));
        }
        return resultBuilder.build();
    }

    @Override
    public ListAndCount<GenericComment> getCommentsByParentId(ItemId parentId, int max, boolean newestFirst, AuthorizationCheckContextWithLocale authorizationContext) {
        authorizationContext.check(parentId, (Action)StaticAction.COMMENTS_READ);
        return (ListAndCount)Preconditions.checkNotNull((Object)((ListAndCount)this.getCommentsByParentIds((Set<? extends ItemId>)ImmutableSet.of((Object)parentId), max, newestFirst, authorizationContext).get((Object)parentId)));
    }

    @Override
    public ImmutableSetMultimap<ItemId, CommentId> getCommentIdsByParentIds(Set<? extends ItemId> parentIds) {
        if (parentIds.isEmpty()) {
            return ImmutableSetMultimap.of();
        }
        Map<ItemId, Collection<CommentId>> mapping = this._cacheHelper.getByIdsMap(parentIds, new CacheHelper.GetByIdsInterface<ItemId, Collection<CommentId>>(){

            @Override
            public CacheKey cacheKey(ItemId id) {
                return CommentsServiceImpl.cacheKeyCommentIdsByParentId(id);
            }

            @Override
            public Map<ItemId, Collection<CommentId>> ibatisGetByIds(Set<ItemId> ids) {
                return CommentsServiceImpl.this._commentsDAO.getCommentIdsByParentIds(ids).asMap();
            }
        });
        return Multimaps2.newImmutableSetMultimap(mapping);
    }

    @Override
    public void deleteDependentComments(final Set<CommentId> ids, final Set<? extends ItemId> parentIds, DeletionContext deletionContext) {
        if (ids.isEmpty()) {
            return;
        }
        this._commentsDAO.deleteComments(ids);
        deletionContext.attach(new DeleteTransactionCallback(){

            @Override
            public void afterCommit() {
                CommentsServiceImpl.this.invalidateCaches(ids, parentIds);
            }
        });
    }

    private void invalidateCaches(Set<CommentId> ids, Set<? extends ItemId> parentIds) {
        ImmutableSet.Builder cacheKeyBuilder = ImmutableSet.builder();
        for (ItemId itemId : parentIds) {
            cacheKeyBuilder.add((Object)CommentsServiceImpl.cacheKeyCommentIdsByParentId(itemId));
            cacheKeyBuilder.add((Object)CommentsServiceImpl.cacheKeyCommentCount(itemId));
        }
        for (CommentId commentId : ids) {
            cacheKeyBuilder.add((Object)CommentsServiceImpl.cacheKeyDBComment(commentId));
        }
        this._cacheHelper.delete((ImmutableSet<CacheKey>)cacheKeyBuilder.build());
    }

    private void invalidateCaches(CommentId commentId, ItemId parentId) {
        this.invalidateCaches((Set<CommentId>)ImmutableSet.of((Object)commentId), (Set<? extends ItemId>)ImmutableSet.of((Object)parentId));
    }

    @Override
    public void editComment(CommentId id, String text, String editorModel, AuthorizationCheckContextWithUserId authCtx) {
        DBComment comment = InvalidIdServiceException.check(this.getDBCommentById(id));
        authCtx.check((ItemId)id, (Action)StaticAction.COMMENT_EDIT);
        this.checkLength(text);
        this._commentsDAO.setCommentText(id, text, editorModel, authCtx.getUserId(), this._clock.nowDate());
        this.invalidateCaches(comment.getId(), comment.getParentId());
        this._eventBus.post(new CommentUpdatedEvent((DBComment)this._commentsDAO.getDBCommentsByIds((Set<CommentId>)ImmutableSet.of((Object)id)).get((Object)id), this.getAddedMentionedPersons(comment.getEditorModel(), editorModel)));
    }

    @Override
    public GenericComment getComment(CommentId id, AuthorizationCheckContextWithLocale authCtx) {
        DBComment comment = InvalidIdServiceException.check(this.getDBCommentById(id));
        authCtx.check(comment.getParentId(), (Action)StaticAction.COMMENTS_READ);
        MapDBCommentFunction mapFunction = new MapDBCommentFunction(authCtx, (Map<CommentId, DBComment>)ImmutableMap.of((Object)comment.getId(), (Object)comment));
        return InvalidIdServiceException.check((GenericComment)mapFunction.apply(comment));
    }

    @ParametersAreNonnullByDefault
    private final class MapDBCommentFunction
    extends NullPermeableFunction<DBComment, GenericComment> {
        final ImmutableSetMultimap<Optional<CommentId>, Action> _permissions;
        final ImmutableMap<PersonId, PersonTeaserModel> _authors;

        private MapDBCommentFunction(AuthorizationCheckContextWithLocale authorizationContext, Map<CommentId, DBComment> dbComments) {
            HashSet authorIds = Sets.newHashSet();
            for (DBComment comment : dbComments.values()) {
                if (comment == null) continue;
                authorIds.addAll(Optional.fromNullable((Object)comment.getAuthorId()).asSet());
                authorIds.addAll(Optional.fromNullable((Object)comment.getEditorId()).asSet());
            }
            this._authors = CommentsServiceImpl.this._profileTeaserService.getPersonTeasersByIds(authorIds, authorizationContext);
            this._permissions = authorizationContext.mayByIds(dbComments.keySet(), BULK_CHECK_COMMENT_ACTIONS);
        }

        @Override
        protected GenericComment applySafe(DBComment dbComment) {
            return new GenericComment(dbComment, (PersonTeaserModel)this._authors.get((Object)dbComment.getAuthorId()), (PersonTeaserModel)this._authors.get((Object)dbComment.getEditorId()), (ImmutableSet<Action>)this._permissions.get((Object)Optional.of((Object)dbComment.getId())));
        }
    }

    private static enum CommentServiceCacheName implements CacheName
    {
        COMMENT_IDS_BY_PARENT_ID("MDL_COMMENT_IDS_BY_PARENT_ID_"),
        COMMENT_BY_ID("MDL_DB_COMMENT_BY_ID_"),
        COMMENT_COUNT_BY_PARENT_ID("MDL_COMMENT_COUNT_BY_PARENT_ID_");

        private final String _cacheName;

        private CommentServiceCacheName(String cacheName) {
            this._cacheName = cacheName;
        }

        @Override
        public String getCacheName() {
            return this._cacheName;
        }
    }
}

