/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.comments.business;

import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSetMultimap;
import de.justsoftware.onx.authorization.business.AuthorizationCheckContextWithLocale;
import de.justsoftware.onx.authorization.business.AuthorizationCheckContextWithUserId;
import de.justsoftware.onx.comments.shared.model.CommentId;
import de.justsoftware.onx.comments.shared.model.GenericComment;
import de.justsoftware.onx.comments.shared.model.db.DBComment;
import de.justsoftware.onx.common.deletion.DeletionContext;
import de.justsoftware.onx.common.shared.model.ListAndCount;
import de.justsoftware.onx.container.shared.model.ItemId;
import de.justsoftware.onx.container.shared.model.ValueTooLargeException;
import java.util.Map;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public interface CommentsService {
    @Nonnull
    public CommentId addComment(String var1, @Nullable String var2, ItemId var3, @Nullable String var4, AuthorizationCheckContextWithUserId var5) throws ValueTooLargeException;

    public void deleteComment(CommentId var1, AuthorizationCheckContextWithUserId var2);

    @Nonnull
    public Integer getCommentCount(ItemId var1);

    @Nonnull
    public ImmutableMap<ItemId, Integer> getCommentsCounts(Set<? extends ItemId> var1);

    @CheckReturnValue
    @Nonnull
    public ListAndCount<GenericComment> getCommentsByParentId(ItemId var1, int var2, boolean var3, AuthorizationCheckContextWithLocale var4);

    @Nonnull
    public ImmutableMap<ItemId, ListAndCount<GenericComment>> getCommentsByParentIds(Set<? extends ItemId> var1, int var2, boolean var3, AuthorizationCheckContextWithLocale var4);

    @CheckForNull
    public DBComment getDBCommentById(CommentId var1);

    @Nonnull
    public Map<CommentId, DBComment> getDBCommentByIds(Set<CommentId> var1);

    @Nonnull
    public ImmutableListMultimap<ItemId, DBComment> getDBCommentsByParents(Set<? extends ItemId> var1);

    @Nonnull
    public ImmutableSetMultimap<ItemId, CommentId> getCommentIdsByParentIds(Set<? extends ItemId> var1);

    public void deleteDependentComments(Set<CommentId> var1, Set<? extends ItemId> var2, DeletionContext var3);

    public void editComment(CommentId var1, String var2, @Nullable String var3, AuthorizationCheckContextWithUserId var4);

    @CheckForNull
    public GenericComment getComment(CommentId var1, AuthorizationCheckContextWithLocale var2);
}

