/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.chat.util;

import com.freiheit.toro.common.shared.model.InvalidIdServiceException;
import de.justsoftware.onx.chat.integration.admin.JID;
import de.justsoftware.onx.chat.model.ChatLogin;
import de.justsoftware.onx.chat.shared.model.ChatUserType;
import de.justsoftware.onx.common.shared.model.PersonId;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public final class JCXmppUtil {
    @Nonnull
    public static JID getJid(PersonId id, String domain) {
        return JCXmppUtil.getJid(id, domain, null);
    }

    @Nonnull
    public static JID getJid(PersonId id, String domain, @Nullable String resource) {
        return JCXmppUtil.getJid(ChatUserType.USER.toLogin(Long.toString(id.getId())), domain, resource);
    }

    @Nonnull
    public static JID getJid(String id, String domain, @Nullable String resource) {
        return new JID(id, domain, resource);
    }

    @Nonnull
    public static JID getJid(String value) {
        return new JID(value);
    }

    @CheckForNull
    public static PersonId parsePersonIdFromJid(String jid) {
        JID fromJId = new JID(jid);
        ChatLogin chatLogin = ChatLogin.parse(fromJId.getNode());
        return chatLogin == null ? null : chatLogin.getPersonId();
    }

    @Nonnull
    public static PersonId parseNonnullPersonIdFromJid(String jid) throws InvalidIdServiceException {
        PersonId personId = JCXmppUtil.parsePersonIdFromJid(jid);
        if (personId == null) {
            throw new InvalidIdServiceException("invalid jid: " + jid);
        }
        return personId;
    }
}

