/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.chat.util;

import de.justsoftware.onx.chat.model.AffectedParticipantsChatMessage;
import de.justsoftware.onx.chat.model.ChatMessage;
import de.justsoftware.onx.chat.model.ChatMessageType;
import de.justsoftware.onx.chat.model.TextChatMessage;
import de.justsoftware.onx.common.shared.model.ProfileId;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public final class ChatMessages {
    private ChatMessages() {
    }

    @Nonnull
    public static Optional<String> getText(ChatMessage message) {
        if (message instanceof TextChatMessage) {
            return Optional.of(((TextChatMessage)TextChatMessage.class.cast(message)).getMessage());
        }
        return Optional.empty();
    }

    public static boolean isAboutDeletedParticipant(ChatMessage message, ProfileId deletedParticipant) {
        boolean allDeleted;
        ChatMessageType type = message.getType();
        boolean bl = allDeleted = type.isDeletionOfSender() && type.isDeletionOfOthers();
        if (allDeleted) {
            return true;
        }
        if (type.isDeletionOfSender()) {
            return ChatMessages.isSender(message, deletedParticipant);
        }
        if (type.isDeletionOfOthers()) {
            return ChatMessages.isAffectedParticipant(message, deletedParticipant);
        }
        return false;
    }

    private static boolean isSender(ChatMessage message, ProfileId user) {
        return Objects.equals(message.getSentFrom(), user);
    }

    private static boolean isAffectedParticipant(ChatMessage message, ProfileId user) {
        Set affectedParticipants = message instanceof AffectedParticipantsChatMessage ? ((AffectedParticipantsChatMessage)message).getAllAffectedPersonIds() : Collections.emptySet();
        return affectedParticipants.contains(user);
    }
}

