/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.chat.shared.model;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public enum JabberPresence {
    CHAT(true, "chat", 100),
    DND(true, "dnd", 90),
    ONLINE(true, "", 80),
    AWAY(true, "away", 70),
    XA(true, "xa", 60),
    CONNECTING(false, "", 50),
    OFFLINE(false, "", 40),
    UNKNOWN(false, "", 30);

    private final boolean _connected;
    private final String _show;
    private final int _priority;

    private JabberPresence(boolean connected, String show, int priority) {
        this._connected = connected;
        this._show = show;
        this._priority = priority;
    }

    public boolean isConnected() {
        return this._connected;
    }

    @Nonnull
    public String getShow() {
        return this._show;
    }

    public int getPriority() {
        return this._priority;
    }

    public boolean isAvailable() {
        return this == ONLINE || this == CHAT;
    }
}

