/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.chat.shared.model;

import javax.annotation.Nonnull;

public enum ChatUserType {
    USER(""),
    NOTIFICATION("notification.");

    private final String _prefix;

    private ChatUserType(String prefix) {
        this._prefix = prefix;
    }

    @Nonnull
    public String getPrefix() {
        return this._prefix;
    }

    @Nonnull
    public static ChatUserType getType(@Nonnull String login) {
        for (ChatUserType type : ChatUserType.values()) {
            String prefix = type._prefix;
            if (prefix.isEmpty() || !login.startsWith(prefix)) continue;
            return type;
        }
        return USER;
    }

    @Nonnull
    public String toLogin(@Nonnull String username) {
        return this._prefix + username;
    }
}

