/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.chat.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import de.justsoftware.onx.chat.model.PubSubOperationType;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.message.shared.model.ChatMessageId;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class PubSubOperation {
    private final PubSubOperationType _type;
    private final ImmutableList<PersonId> _subscribers;
    private final ChatMessageId _chatMessageId;

    @JsonCreator
    public PubSubOperation(@JsonProperty(value="type") PubSubOperationType type, @JsonProperty(value="subscribers") ImmutableList<PersonId> subscribers, @Nullable @JsonProperty(value="chatMessageId") ChatMessageId chatMessageId) {
        this._type = type;
        this._subscribers = subscribers;
        this._chatMessageId = chatMessageId;
    }

    @Nonnull
    public PubSubOperationType getType() {
        return this._type;
    }

    @Nonnull
    public ImmutableList<PersonId> getSubscribers() {
        return this._subscribers;
    }

    @CheckForNull
    public ChatMessageId getChatMessageId() {
        return this._chatMessageId;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("type", (Object)this._type).add("subscribers", this._subscribers).add("chatMessageId", (Object)this._chatMessageId).toString();
    }

    @Nonnull
    public static PubSubOperation createNode() {
        return new PubSubOperation(PubSubOperationType.CREATE_NODE, (ImmutableList<PersonId>)ImmutableList.of(), null);
    }

    @Nonnull
    public static PubSubOperation deleteNode() {
        return new PubSubOperation(PubSubOperationType.DELETE_NODE, (ImmutableList<PersonId>)ImmutableList.of(), null);
    }

    @Nonnull
    public static PubSubOperation subscribe(List<PersonId> subscribers) {
        return new PubSubOperation(PubSubOperationType.SUBSCRIBE, (ImmutableList<PersonId>)ImmutableList.copyOf(subscribers), null);
    }

    @Nonnull
    public static PubSubOperation unsubscribe(List<PersonId> subscribers) {
        return new PubSubOperation(PubSubOperationType.UNSUBSCRIBE, (ImmutableList<PersonId>)ImmutableList.copyOf(subscribers), null);
    }

    @Nonnull
    public static PubSubOperation sendMessage(ChatMessageId chatMessageId) {
        return new PubSubOperation(PubSubOperationType.SEND_MESSAGE, (ImmutableList<PersonId>)ImmutableList.of(), chatMessageId);
    }
}

