/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.chat.model;

import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import de.justsoftware.onx.chat.model.JCXmppResourcePrefix;
import de.justsoftware.onx.chat.shared.model.JabberPresence;
import de.justsoftware.onx.common.shared.model.PersonId;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class JCXmppUserPresence {
    private final ConcurrentHashMap<String, JabberPresence> _presenceByResources;
    private final PersonId _personId;

    public JCXmppUserPresence(PersonId personId) {
        this._personId = personId;
        this._presenceByResources = new ConcurrentHashMap();
    }

    public void updatePresence(String resource, JabberPresence presence) {
        if (JabberPresence.OFFLINE.equals((Object)presence)) {
            this._presenceByResources.remove(resource);
        } else {
            this._presenceByResources.put(resource, presence);
        }
    }

    @CheckForNull
    public JabberPresence getPresenceOfResource(String resource) {
        return this._presenceByResources.get(resource);
    }

    @Nonnull
    public Set<String> getResources() {
        return this._presenceByResources.keySet();
    }

    @Nonnull
    public PersonId getPersonId() {
        return this._personId;
    }

    @Nonnull
    private static ImmutableList<Map.Entry<String, JabberPresence>> sortByHighestPresencePriority(Set<Map.Entry<String, JabberPresence>> source) {
        return ImmutableList.copyOf((Collection)Ordering.natural().onResultOf((Function)new Function<Map.Entry<String, JabberPresence>, Integer>(){

            public Integer apply(Map.Entry<String, JabberPresence> input) {
                if (input == null) {
                    return null;
                }
                return input.getValue().getPriority();
            }
        }).reverse().sortedCopy(source));
    }

    @Nonnull
    public JabberPresence getPresence() {
        return JCXmppUserPresence.getByHighestPriority(this._presenceByResources);
    }

    @Nonnull
    private static JabberPresence getByHighestPriority(Map<String, JabberPresence> source) {
        ImmutableList<Map.Entry<String, JabberPresence>> sortedByHighestPresencePriority = JCXmppUserPresence.sortByHighestPresencePriority(source.entrySet());
        if (sortedByHighestPresencePriority.isEmpty()) {
            return JabberPresence.OFFLINE;
        }
        return (JabberPresence)((Object)((Map.Entry)sortedByHighestPresencePriority.get(0)).getValue());
    }

    @Nonnull
    public JabberPresence getPresenceByResourcePrefix(final JCXmppResourcePrefix resourcePrefix) {
        return JCXmppUserPresence.getByHighestPriority(Maps.filterKeys(this._presenceByResources, (Predicate)new Predicate<String>(){

            public boolean apply(String input) {
                return input.startsWith(resourcePrefix.getPrefix());
            }
        }));
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("personId", (Object)this._personId).add("presenceByResources", this._presenceByResources == null ? null : Integer.valueOf(this._presenceByResources.size())).toString();
    }
}

