/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.chat.model;

import com.google.common.base.MoreObjects;
import de.justsoftware.onx.chat.model.ConversationControlMessageType;
import de.justsoftware.onx.message.model.ConversationSettings;
import de.justsoftware.onx.message.shared.model.ConversationId;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class ConversationControlMessage {
    private final ConversationControlMessageType _type;
    private final ConversationControlMessageParameters _parameters;

    public ConversationControlMessage(ConversationControlMessageType type) {
        this(type, new ConversationControlMessageParameters(null));
    }

    public ConversationControlMessage(ConversationControlMessageType type, @Nullable ConversationId conversationId) {
        this(type, new ConversationControlMessageParameters(conversationId));
    }

    public ConversationControlMessage(ConversationControlMessageType type, ConversationControlMessageParameters parameters) {
        this._type = type;
        this._parameters = parameters;
    }

    @Nonnull
    public ConversationControlMessageType getType() {
        return this._type;
    }

    @Nonnull
    public ConversationControlMessageParameters getParameters() {
        return this._parameters;
    }

    public String toString() {
        return this.toString(MoreObjects.toStringHelper((Object)this)).toString();
    }

    @Nonnull
    public MoreObjects.ToStringHelper toString(MoreObjects.ToStringHelper helper) {
        return helper.add("parameters", (Object)this._parameters).add("type", (Object)this._type);
    }

    @ParametersAreNonnullByDefault
    public static final class ConversationControlMessageParameters {
        private final ConversationId _conversationId;
        private final ConversationSettings _conversationSettings;

        public ConversationControlMessageParameters() {
            this(null, null);
        }

        public ConversationControlMessageParameters(@Nullable ConversationId conversationId) {
            this(conversationId, null);
        }

        public ConversationControlMessageParameters(@Nullable ConversationId conversationId, @Nullable ConversationSettings conversationSettings) {
            this._conversationId = conversationId;
            this._conversationSettings = conversationSettings;
        }

        @CheckForNull
        public ConversationId getConversationId() {
            return this._conversationId;
        }

        @CheckForNull
        public ConversationSettings getConversationSettings() {
            return this._conversationSettings;
        }

        @Nonnull
        public MoreObjects.ToStringHelper toString(MoreObjects.ToStringHelper helper) {
            return helper.add("conversationId", (Object)this._conversationId).add("conversationSettings", (Object)this._conversationSettings);
        }
    }
}

