/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.chat.model;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

public enum ChatMessageType {
    CHAT_MESSAGE(false, false){

        @Override
        public <T, E> T transform(Transformer<T, E> transformer, E message) {
            return transformer.transformChatMessage(message);
        }
    }
    ,
    ADDED_TO_CONVERSATION(false, false){

        @Override
        public <T, E> T transform(Transformer<T, E> transformer, E message) {
            return transformer.transformAddedToConversation(message);
        }
    }
    ,
    REMOVED_FROM_CONVERSATION(false, true){

        @Override
        public <T, E> T transform(Transformer<T, E> transformer, E message) {
            return transformer.transformRemovedFromConversation(message);
        }
    }
    ,
    LEFT_CONVERSATION(true, false){

        @Override
        public <T, E> T transform(Transformer<T, E> transformer, E message) {
            return transformer.transformLeftConversation(message);
        }
    }
    ,
    CONVERSATION_TITLE_CHANGED(false, false){

        @Override
        public <T, E> T transform(Transformer<T, E> transformer, E message) {
            return transformer.transformConversationTitleChanged(message);
        }
    }
    ,
    CONVERSATION_CREATED(false, false){

        @Override
        public <T, E> T transform(Transformer<T, E> transformer, E message) {
            return transformer.transformConversationCreated(message);
        }
    }
    ,
    CONVERSATION_DELETED(true, true){

        @Override
        public <T, E> T transform(Transformer<T, E> transformer, E message) {
            return transformer.transformConversationDeleted(message);
        }
    }
    ,
    ATTACHMENT_CHAT_MESSAGE(false, false){

        @Override
        public <T, E> T transform(Transformer<T, E> transformer, E message) {
            return transformer.transformAttachmentChatMessage(message);
        }
    }
    ,
    PERSON_DELETED(true, false){

        @Override
        public <T, E> T transform(Transformer<T, E> transformer, E message) {
            return transformer.transformPersonDeletedChatMessage(message);
        }
    }
    ,
    DELETED_CHAT_MESSAGE(false, false){

        @Override
        public <T, E> T transform(Transformer<T, E> transformer, E message) {
            return transformer.transformDeletedChatMessage(message);
        }
    }
    ,
    USER_GROUP_DELETED(false, true){

        @Override
        public <T, E> T transform(Transformer<T, E> transformer, E message) {
            return transformer.transformUserGroupDeletedChatMessage(message);
        }
    };

    private final boolean _deletionOfSender;
    private final boolean _deletionOfOthers;

    private ChatMessageType(boolean deletionOfSender, boolean deletionOfOthers) {
        this._deletionOfSender = deletionOfSender;
        this._deletionOfOthers = deletionOfOthers;
    }

    public boolean isDeletionOfSender() {
        return this._deletionOfSender;
    }

    public boolean isDeletionOfOthers() {
        return this._deletionOfOthers;
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    public abstract <T, E> T transform(Transformer<T, E> var1, E var2);

    @ParametersAreNonnullByDefault
    public static interface Transformer<T, E> {
        @Nonnull
        public T transformChatMessage(E var1);

        @Nonnull
        public T transformAddedToConversation(E var1);

        @Nonnull
        public T transformRemovedFromConversation(E var1);

        @Nonnull
        public T transformLeftConversation(E var1);

        @Nonnull
        public T transformConversationTitleChanged(E var1);

        @Nonnull
        public T transformConversationCreated(E var1);

        @Nonnull
        public T transformConversationDeleted(E var1);

        @Nonnull
        public T transformAttachmentChatMessage(E var1);

        @Nonnull
        public T transformPersonDeletedChatMessage(E var1);

        @Nonnull
        public T transformDeletedChatMessage(E var1);

        @Nonnull
        public T transformUserGroupDeletedChatMessage(E var1);
    }
}

