/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.chat.model;

import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import de.justsoftware.onx.chat.model.AffectedParticipantsChatMessage;
import de.justsoftware.onx.chat.model.AttachmentChatMessage;
import de.justsoftware.onx.chat.model.ChatMessageType;
import de.justsoftware.onx.chat.model.ConversationCreatedChatMessage;
import de.justsoftware.onx.chat.model.ConversationTitleChangedChatMessage;
import de.justsoftware.onx.chat.model.SenderLeftChatMessage;
import de.justsoftware.onx.chat.model.TextChatMessage;
import de.justsoftware.onx.common.shared.model.ProfileId;
import de.justsoftware.onx.common.shared.model.component.ComponentType;
import de.justsoftware.onx.container.shared.model.ItemId;
import de.justsoftware.onx.container.shared.server.model.Item;
import de.justsoftware.onx.container.shared.server.model.ItemVisitor;
import de.justsoftware.onx.message.shared.model.ChatMessageId;
import de.justsoftware.onx.message.shared.model.ConversationId;
import de.justsoftware.onx.util.shared.NullPermeableFunction;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.joda.time.DateTime;

@ParametersAreNonnullByDefault
public class ChatMessage
implements Item<ChatMessageId> {
    public static final NullPermeableFunction<ChatMessage, ConversationId> TO_CONVERSATION_ID = new NullPermeableFunction<ChatMessage, ConversationId>(){

        @Override
        protected ConversationId applySafe(ChatMessage message) {
            return message.getConversationId();
        }
    };
    public static final NullPermeableFunction<ChatMessage, ChatMessageId> TO_ID = new NullPermeableFunction<ChatMessage, ChatMessageId>(){

        @Override
        protected ChatMessageId applySafe(ChatMessage message) {
            return message.getId();
        }
    };
    public static final Function<ChatMessage, DateTime> TO_CREATE_DATE = new NullPermeableFunction<ChatMessage, DateTime>(){

        @Override
        protected DateTime applySafe(ChatMessage message) {
            return message.getCreateDate();
        }
    };
    private final ChatMessageId _id;
    private final ConversationId _conversationId;
    private final DateTime _createDate;
    private final ProfileId _sentFrom;
    private final ChatMessageType _type;

    public ChatMessage(ChatMessageId id, ConversationId conversationId, ChatMessageType type, ProfileId sentFrom, DateTime createDate) {
        this._id = id;
        this._conversationId = conversationId;
        this._sentFrom = sentFrom;
        this._type = type;
        this._createDate = createDate;
    }

    @Override
    @Nonnull
    public ChatMessageId getId() {
        return this._id;
    }

    @Nonnull
    public ConversationId getConversationId() {
        return this._conversationId;
    }

    @Nonnull
    public ChatMessageType getType() {
        return this._type;
    }

    @Nonnull
    public ProfileId getSentFrom() {
        return this._sentFrom;
    }

    @Nonnull
    public DateTime getCreateDate() {
        return this._createDate;
    }

    @Override
    public ItemId getParentId() {
        return this._conversationId;
    }

    @Override
    public ComponentType getModuleType() {
        return null;
    }

    @Override
    public <T> T accept(ItemVisitor<T> v) {
        return v.visit(this);
    }

    @Nonnull
    public <T> T apply(ChatMessageVisitor<T> visitor) {
        return visitor.visitChatMessage(this);
    }

    public String toString() {
        return this.toString(MoreObjects.toStringHelper((Object)this)).toString();
    }

    @Nonnull
    public MoreObjects.ToStringHelper toString(MoreObjects.ToStringHelper helper) {
        return helper.add("id", (Object)this._id).add("conversationId", (Object)this._conversationId).add("type", (Object)this._type).add("sentFrom", (Object)this._sentFrom).add("createDate", (Object)this._createDate);
    }

    @ParametersAreNonnullByDefault
    public static interface ChatMessageVisitor<T> {
        @Nonnull
        public T visitChatMessage(ChatMessage var1);

        @Nonnull
        public T visitAffectedParticipantsChatMessage(AffectedParticipantsChatMessage var1);

        @Nonnull
        public T visitAttachmentChatMessage(AttachmentChatMessage var1);

        @Nonnull
        public T visitConversationCreatedChatMessage(ConversationCreatedChatMessage var1);

        @Nonnull
        public T visitConversationTitleChangedChatMessage(ConversationTitleChangedChatMessage var1);

        @Nonnull
        public T visitTextChatMessage(TextChatMessage var1);

        @Nonnull
        public T visitSenderLeftChatMessage(SenderLeftChatMessage var1);
    }
}

