/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.chat.model;

import com.google.common.base.MoreObjects;
import de.justsoftware.onx.chat.shared.model.ChatUserType;
import de.justsoftware.onx.common.shared.model.PersonId;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

public final class ChatLogin {
    private final ChatUserType _type;
    private final PersonId _personId;

    private ChatLogin(@Nonnull PersonId personId, @Nonnull ChatUserType type) {
        this._personId = personId;
        this._type = type;
    }

    @CheckForNull
    public static ChatLogin parse(@Nonnull String login) {
        ChatUserType type = ChatUserType.getType(login);
        PersonId personId = PersonId.parse(login.substring(type.getPrefix().length()));
        return personId == null ? null : new ChatLogin(personId, type);
    }

    @Nonnull
    public ChatUserType getType() {
        return this._type;
    }

    @Nonnull
    public PersonId getPersonId() {
        return this._personId;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("type", (Object)this._type).add("personId", (Object)this._personId).toString();
    }
}

