/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.chat.model;

import com.google.common.base.MoreObjects;
import de.justsoftware.onx.chat.model.ChatAttachmentType;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class ChatAttachment {
    private final String _documentId;
    private final String _documentVersionId;
    private final String _filename;
    private final long _size;
    private final String _contentType;
    private final String _version;
    private final ChatAttachmentType _attachmentType;
    private final Integer _imageWidth;
    private final Integer _imageHeight;

    public ChatAttachment(String documentId, String documentVersionId, String filename, long size, String contentType, String version, ChatAttachmentType attachmentType, @Nullable Integer imageWidth, @Nullable Integer imageHeight) {
        this._documentId = documentId;
        this._documentVersionId = documentVersionId;
        this._filename = filename;
        this._size = size;
        this._contentType = contentType;
        this._version = version;
        this._attachmentType = attachmentType;
        this._imageWidth = imageWidth;
        this._imageHeight = imageHeight;
    }

    @Nonnull
    public String getDocumentId() {
        return this._documentId;
    }

    @Nonnull
    public String getDocumentVersionId() {
        return this._documentVersionId;
    }

    @Nonnull
    public String getFilename() {
        return this._filename;
    }

    public long getSize() {
        return this._size;
    }

    @Nonnull
    public String getContentType() {
        return this._contentType;
    }

    public boolean isImageContentType() {
        return this._contentType != null ? this._contentType.toLowerCase().startsWith("image/") : false;
    }

    @Nonnull
    public String getVersion() {
        return this._version;
    }

    @Nonnull
    public ChatAttachmentType getAttachmentType() {
        return this._attachmentType;
    }

    @CheckForNull
    public Integer getImageWidth() {
        return this._imageWidth;
    }

    @CheckForNull
    public Integer getImageHeight() {
        return this._imageHeight;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("documentId", (Object)this._documentId).add("documentVersionId", (Object)this._documentVersionId).add("filename", (Object)this._filename).add("size", this._size).add("contentType", (Object)this._contentType).add("version", (Object)this._version).add("attachmentType", (Object)this._attachmentType).add("imageWidth", (Object)this._imageWidth).add("imageHeight", (Object)this._imageHeight).toString();
    }
}

