/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.chat.integration.persistence.ibatis;

import com.freiheit.toro.common.integration.persistence.ibatis.IbatisDAOUtil;
import com.google.common.collect.ImmutableSet;
import com.ibatis.sqlmap.client.SqlMapClient;
import de.justsoftware.onx.chat.integration.persistence.JabberContactSyncDAO;
import de.justsoftware.onx.common.shared.model.PersonId;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service(value="jabberContactSyncDAO")
public class IbatisJabberContactSyncDAO
implements JabberContactSyncDAO {
    private static final String NAMESPACE = "JabberContactSync.";
    @Autowired
    @Qualifier(value="sqlMapClient")
    private SqlMapClient _sqlMapper;

    @Override
    public ImmutableSet<PersonId> getUnsyncedProfiles(int limit) {
        List result = IbatisDAOUtil.wrappedQueryForList(this._sqlMapper, "JabberContactSync.getUnsyncedProfiles", null, 0, limit);
        return ImmutableSet.copyOf(result);
    }

    @Override
    public void markUnsynced(Set<PersonId> ids) {
        IbatisDAOUtil.wrappedPartitionDelete(this._sqlMapper, "JabberContactSync.markUnsynced", ids, IbatisDAOUtil.IDS_TO_IBATIS_LIST);
    }

    @Override
    public void markEverybodyUnsynced() {
        IbatisDAOUtil.wrappedDelete(this._sqlMapper, "JabberContactSync.markEverybodyUnsynced", null);
    }

    @Override
    public void markInProgress(Set<PersonId> ids) {
        IbatisDAOUtil.wrappedPartitionInsert(this._sqlMapper, "JabberContactSync.markInProgress", ids, IbatisDAOUtil.OBJECTS_TO_IBATIS_LIST);
    }

    @Override
    public void markSynced(Set<PersonId> ids) {
        IbatisDAOUtil.wrappedPartitionUpdate(this._sqlMapper, "JabberContactSync.markSynced", ids, IbatisDAOUtil.IDS_TO_IBATIS_LIST);
    }
}

