/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.chat.integration.persistence.file;

import de.justsoftware.onx.authorization.business.AuthorizationCheckContextWithUserId;
import de.justsoftware.onx.chat.integration.persistence.ChatAttachmentRepository;
import de.justsoftware.onx.chat.integration.persistence.file.model.DriveChatAttachmentResource;
import de.justsoftware.onx.chat.integration.persistence.file.model.MultipartFileResource;
import de.justsoftware.onx.chat.model.ChatAttachment;
import de.justsoftware.onx.chat.model.ChatAttachmentType;
import de.justsoftware.onx.chat.model.ResourceWithHeaders;
import de.justsoftware.onx.common.server.FileUploadRestTemplate;
import de.justsoftware.onx.drive.business.model.DriveUploadResultModel;
import de.justsoftware.onx.message.shared.model.ConversationId;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.util.Iterator;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestOperations;
import org.springframework.web.multipart.MultipartFile;

@Service
@ParametersAreNonnullByDefault
public class DriveChatAttachmentRepositoryImpl
implements ChatAttachmentRepository {
    private static final Logger LOG = LoggerFactory.getLogger(DriveChatAttachmentRepositoryImpl.class);
    private final String _apiUrl;
    private final String _apiHostUrl;
    private final RestOperations _defaultRestOperations;

    @Autowired
    public DriveChatAttachmentRepositoryImpl(@Value(value="${just-drive.internalApi.url}") String driveInternalApiUrl, @Value(value="${just-drive.internalApi.host.url}") String driveInternalApiHostUrl, @Qualifier(value="defaultRestTemplate") RestOperations restOperations) {
        this._apiUrl = driveInternalApiUrl;
        this._apiHostUrl = driveInternalApiHostUrl;
        this._defaultRestOperations = restOperations;
    }

    @Override
    public ChatAttachment persist(ConversationId conversationId, MultipartFile attachment, AuthorizationCheckContextWithUserId authContext) {
        FileUploadRestTemplate rest = new FileUploadRestTemplate(attachment.getSize());
        Dimension imageDimension = null;
        try {
            imageDimension = DriveChatAttachmentRepositoryImpl.getImageDimension(attachment);
        }
        catch (RuntimeException e) {
            LOG.warn("Failed to read the dimension of attachment: " + e.getMessage());
        }
        HttpHeaders headers = new HttpHeaders();
        String originalContentType = attachment.getContentType();
        if (originalContentType != null) {
            headers.set("Content-Type", originalContentType);
        }
        HttpEntity attachmentHttpEntity = new HttpEntity((Object)new MultipartFileResource(attachment), (MultiValueMap)headers);
        LinkedMultiValueMap postData = new LinkedMultiValueMap();
        postData.add((Object)"ownerId", (Object)authContext.getUserId().toString());
        postData.add((Object)"file", (Object)attachmentHttpEntity);
        DriveUploadResultModel result = (DriveUploadResultModel)rest.postForObject(this._apiUrl + "/item/" + conversationId.asString(), postData, DriveUploadResultModel.class, new Object[0]);
        return new ChatAttachment(result.getId().getId(), result.getVersionId(), result.getName(), result.getSize(), result.getMimeType(), result.getVersion(), ChatAttachmentType.NEW_ATTACHMENT, imageDimension == null ? null : Integer.valueOf(imageDimension.getWidth()), imageDimension == null ? null : Integer.valueOf(imageDimension.getHeight()));
    }

    private static boolean isImageContentType(String contentType) {
        return contentType.toLowerCase().startsWith("image/");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CheckForNull
    private static Dimension getImageDimension(MultipartFile file) {
        block9: {
            if (!DriveChatAttachmentRepositoryImpl.isImageContentType(file.getContentType())) {
                return null;
            }
            ImageInputStream in = ImageIO.createImageInputStream(file.getInputStream());
            Iterator<ImageReader> readers = ImageIO.getImageReaders(in);
            if (!readers.hasNext()) break block9;
            ImageReader reader = readers.next();
            try {
                reader.setInput(in);
                Dimension dimension = new Dimension(reader.getWidth(0), reader.getHeight(0));
                reader.dispose();
                return dimension;
            }
            catch (IOException e) {
                try {
                    try {
                        LOG.warn("Failed to read dimension of image. Maybe image is corrupt: " + e.getMessage());
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        reader.dispose();
                    }
                }
                catch (IOException ex) {
                    LOG.warn("Failed to read image. Maybe image is corrupt: " + ex.getMessage());
                }
            }
        }
        return null;
    }

    @Override
    @SuppressFBWarnings(value={"NP_NONNULL_PARAM_VIOLATION"}, justification="false positive: responseType parameter of postForEntity is actually nullable.")
    public boolean rollbackByDocumentId(String documentId) {
        HttpStatus resultStatusCode = new FileUploadRestTemplate(0L).postForEntity(this._apiUrl + "/file/" + documentId + "/rollback", null, null, new Object[0]).getStatusCode();
        return HttpStatus.OK.equals((Object)resultStatusCode);
    }

    @Override
    public boolean deleteByDocumentId(String documentId, AuthorizationCheckContextWithUserId authContext) {
        try {
            this._defaultRestOperations.delete(this._apiUrl + "/file/{documentId}/delete?deletingUser={userId}", new Object[]{documentId, authContext.getUserId()});
            return true;
        }
        catch (RestClientException e) {
            LOG.error("Error deleting Drive document with ID " + documentId, (Throwable)e);
            return false;
        }
    }

    @Override
    public String getThumbnailDownloadUrl(String documentVersionId) {
        return this.getDownloadUrl(this._apiHostUrl, documentVersionId);
    }

    @Nonnull
    private String getDownloadUrl(String apiUrl, String documentVersionId) {
        return apiUrl + "/fileversion/" + documentVersionId + "/download";
    }

    @Override
    public ResourceWithHeaders getByDocumentVersionId(String documentVersionId) {
        return new DriveChatAttachmentResource(this.getDownloadUrl(this._apiUrl, documentVersionId));
    }

    private static class Dimension {
        private final int _height;
        private final int _width;

        public Dimension(int width, int height) {
            this._width = width;
            this._height = height;
        }

        public int getHeight() {
            return this._height;
        }

        public int getWidth() {
            return this._width;
        }
    }
}

