/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.chat.integration.admin.impl;

import com.google.common.base.MoreObjects;
import com.google.common.xml.XmlEscapers;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class PublishItemIq {
    private final String _nodeName;
    private final String _payload;
    private final String _stanzaId;
    private final String _itemId;

    public PublishItemIq(String nodeName, String payload) {
        this._nodeName = nodeName;
        this._payload = payload;
        this._stanzaId = UUID.randomUUID().toString();
        this._itemId = UUID.randomUUID().toString();
    }

    @Nonnull
    public String toXML() {
        StringBuilder sb = new StringBuilder();
        sb.append("<iq type='set' id='").append(this._stanzaId).append("'>");
        sb.append("<pubsub xmlns='http://jabber.org/protocol/pubsub'>");
        sb.append("<publish node='").append(this._nodeName).append("'>");
        sb.append("<item>");
        sb.append("<payload>");
        sb.append(XmlEscapers.xmlContentEscaper().escape(this._payload));
        sb.append("</payload>");
        sb.append("</item>");
        sb.append("</publish>");
        sb.append("</pubsub>");
        sb.append("</iq>");
        return sb.toString();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("nodeName", (Object)this._nodeName).add("payload", (Object)"[payload]").toString();
    }
}

