/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.chat.integration.admin.impl;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import com.google.common.xml.XmlEscapers;
import de.justsoftware.onx.chat.integration.admin.JID;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class MulticastMessage {
    private final String _subject;
    private final String _body;
    private final ImmutableSet<JID> _addresses;

    public MulticastMessage(String subject, String body, ImmutableSet<JID> addresses) {
        this._subject = subject;
        this._body = body;
        this._addresses = addresses;
    }

    @Nonnull
    public String toXML() {
        StringBuilder sb = new StringBuilder();
        sb.append("<message>");
        sb.append("<addresses xmlns='http://jabber.org/protocol/address'>");
        for (JID address : this._addresses) {
            sb.append("<address type='bcc' jid='");
            sb.append(address.asString());
            sb.append("'/>");
        }
        sb.append("</addresses>");
        sb.append("<body>");
        sb.append(XmlEscapers.xmlContentEscaper().escape(this._body));
        sb.append("</body>");
        sb.append("<subject>");
        sb.append(XmlEscapers.xmlContentEscaper().escape(this._subject));
        sb.append("</subject>");
        sb.append("</message>");
        return sb.toString();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("subject", (Object)this._subject).add("body", (Object)"[body]").add("addresses", this._addresses.size()).toString();
    }
}

