/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.chat.integration.admin;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.freiheit.toro.admin.shared.server.superoperty.Settings;
import com.freiheit.toro.common.shared.model.ServiceException;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Streams;
import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import de.justsoftware.onx.authorization.business.AuthorizationCheckContext;
import de.justsoftware.onx.authorization.business.AuthorizationCheckContextWithUserId;
import de.justsoftware.onx.authorization.business.ProfileReadRole;
import de.justsoftware.onx.chat.business.impl.XmppSystemUserConnection;
import de.justsoftware.onx.chat.integration.admin.JID;
import de.justsoftware.onx.chat.integration.admin.impl.PublishItemIq;
import de.justsoftware.onx.chat.model.ChatLogin;
import de.justsoftware.onx.chat.model.ChatMessage;
import de.justsoftware.onx.chat.model.ConversationControlMessage;
import de.justsoftware.onx.chat.model.JCXmppMessage;
import de.justsoftware.onx.chat.model.JCXmppResourcePrefix;
import de.justsoftware.onx.chat.model.JCXmppRosterItem;
import de.justsoftware.onx.chat.model.JCXmppStanza;
import de.justsoftware.onx.chat.model.JCXmppUserPresence;
import de.justsoftware.onx.chat.model.JCXmppUserPresenceUpdateEvent;
import de.justsoftware.onx.chat.model.PubSubOperation;
import de.justsoftware.onx.chat.shared.model.ChatUserType;
import de.justsoftware.onx.chat.shared.model.JabberPresence;
import de.justsoftware.onx.chat.util.JCXmppUtil;
import de.justsoftware.onx.common.business.events.ServerEventHandler;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.common.shared.model.ProfileId;
import de.justsoftware.onx.message.business.MessageReadDataService;
import de.justsoftware.onx.message.integration.persistence.ibatis.DBConversationParticipant;
import de.justsoftware.onx.message.shared.model.ChatMessageId;
import de.justsoftware.onx.message.shared.model.ConversationId;
import de.justsoftware.onx.usergroup.event.UserGroupMemberAddedEvent;
import de.justsoftware.onx.usergroup.event.UserGroupMemberRemovedEvent;
import de.justsoftware.onx.usergroup.model.UserGroupId;
import de.justsoftware.toolbox.kafka.client.KafkaCleaningProducer;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.jxmpp.jid.Jid;
import org.jxmpp.jid.impl.JidCreate;
import org.jxmpp.stringprep.XmppStringprepException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

@Service(value="xmppService")
@ParametersAreNonnullByDefault
public class XmppService
implements ServerEventHandler {
    private static final Logger LOG = LoggerFactory.getLogger(XmppService.class);
    private static final int GROUP_CONVERSATION_FETCH_SIZE = 1000;
    private static final int SUBSCRIBER_PARTITION_SIZE = 200;
    private static final String ROSTER_GROUP_NAME = "JustConnect";
    private static final String SUBSCRIPTION_NONE = "none";
    private static final String SUBSCRIPTION_BOTH = "both";
    private final String _ejabberdApiUrlPrefix;
    private final String _domain;
    private final RestTemplate _restTemplate = new RestTemplate();
    private final ObjectMapper _jsonMapper;
    private final Settings _settings;
    private final XmppSystemUserConnection _xmppSystemUserConnection;
    private final MessageReadDataService _messageReadDataService;
    @CheckForNull
    private final KafkaCleaningProducer<String, String> _producer;
    private final ConcurrentHashMap<PersonId, JCXmppUserPresence> _userPresenceStatus = new ConcurrentHashMap();

    @Autowired
    public XmppService(@Value(value="${xmpp.host}") String xmppHost, @Value(value="${domain}") String domain, ObjectMapper jsonMapper, Settings settings, XmppSystemUserConnection xmppSystemUserConnection, MessageReadDataService messageReadDataService, @Nullable @Qualifier(value="KAFKA_STRING_PRODUCER") KafkaCleaningProducer<String, String> producer) {
        this._ejabberdApiUrlPrefix = "http://" + xmppHost + ":5285/api/";
        this._domain = domain;
        this._jsonMapper = jsonMapper;
        this._settings = settings;
        this._xmppSystemUserConnection = xmppSystemUserConnection;
        this._messageReadDataService = messageReadDataService;
        this._producer = producer;
    }

    public void addContacts(JID user1, JID user2) {
        this.addOneContact(user1, user2, SUBSCRIPTION_NONE);
        this.addOneContact(user2, user1, SUBSCRIPTION_BOTH);
        this.addOneContact(user1, user2, SUBSCRIPTION_BOTH);
    }

    private void addOneContact(JID user1, JID user2, String subscription) {
        JCXmppRosterItem rosterItem = new JCXmppRosterItem(user1.getNode(), user1.getDomain(), user2.getNode(), user2.getDomain(), user2.getNode(), ROSTER_GROUP_NAME, subscription);
        this.sendCommand("add_rosteritem", rosterItem);
    }

    public void sendMessage(PersonId recipient, ConversationControlMessage controlMessage) {
        this.sendMessage((ImmutableSet<PersonId>)ImmutableSet.of((Object)recipient), controlMessage);
    }

    public void sendMessage(ImmutableSet<PersonId> recipients, ConversationControlMessage controlMessage) {
        ImmutableSet connectedRecipients = (ImmutableSet)recipients.stream().filter(personId -> this.getPresenceByUserId((PersonId)personId) != JabberPresence.OFFLINE).collect(ImmutableSet.toImmutableSet());
        this.sendMessage((Set<PersonId>)connectedRecipients, "Notification", controlMessage);
    }

    public void sendMessage(Set<PersonId> recipients, ChatMessage message) {
        this.sendMessage(recipients, "Message", message);
    }

    private void sendMessage(Set<PersonId> recipients, String subject, Object message) {
        if (recipients.isEmpty()) {
            return;
        }
        try {
            String jsonMessage = this._jsonMapper.writeValueAsString(message);
            JID systemUserJid = this._xmppSystemUserConnection.getSystemUserJid();
            ImmutableSet recipientJIDs = (ImmutableSet)recipients.stream().map(personId -> JCXmppUtil.getJid(personId, this._domain)).collect(ImmutableSet.toImmutableSet());
            for (JID recipientJID : recipientJIDs) {
                this.sendMessage(systemUserJid, recipientJID, subject, jsonMessage);
            }
        }
        catch (JsonProcessingException e) {
            throw new ServiceException("Failed to create json String from OutgoingMessage", e);
        }
    }

    private void sendMessage(JID from, JID to, String subject, String message) {
        try {
            JCXmppMessage xmppMessage = new JCXmppMessage("normal", from.asString(), to.asString(), subject, message);
            this.sendCommand("send_message", xmppMessage);
        }
        catch (RestClientException e) {
            throw new ServiceException("Could not access ejabberd at: " + this._ejabberdApiUrlPrefix, e);
        }
    }

    private void sendCommand(String command, Object payload) throws RestClientException, ServiceException {
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.add("Content-Type", "application/json");
        HttpEntity httpEntity = new HttpEntity(payload, (MultiValueMap)httpHeaders);
        String commandUrl = this._ejabberdApiUrlPrefix + command;
        ResponseEntity response = this._restTemplate.postForEntity(commandUrl, (Object)httpEntity, Integer.class, new Object[0]);
        if (response.getStatusCode() != HttpStatus.OK) {
            throw new ServiceException("Sending command " + command + " failed with http status: " + response.getStatusCode().value());
        }
        if ((Integer)response.getBody() != 0) {
            throw new ServiceException("Sending command " + command + " resulted in error (" + response.getBody() + ")");
        }
    }

    @Nonnull
    public JID getMessageDistributorJid() {
        return this._xmppSystemUserConnection.getSystemUserJid();
    }

    @Subscribe
    @AllowConcurrentEvents
    public void onPresenceUpdateEvent(JCXmppUserPresenceUpdateEvent event) {
        JabberPresence presence = event.getPresence();
        JID fromJid = event.getFrom();
        ChatLogin chatLogin = ChatLogin.parse(fromJid.getNode());
        if (chatLogin != null && chatLogin.getType() == ChatUserType.USER) {
            PersonId personId = chatLogin.getPersonId();
            this._userPresenceStatus.putIfAbsent(personId, new JCXmppUserPresence(personId));
            JCXmppUserPresence userPresence = this._userPresenceStatus.get(personId);
            userPresence.updatePresence((String)MoreObjects.firstNonNull((Object)fromJid.getResource(), (Object)""), presence);
        }
    }

    @Nonnull
    public ImmutableMap<PersonId, JabberPresence> getPresencesByUserIds(Iterable<PersonId> userIds, AuthorizationCheckContextWithUserId authorizationContext) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        if (!this._settings.isChatEnabled()) {
            for (PersonId personId : userIds) {
                builder.put((Object)personId, (Object)JabberPresence.UNKNOWN);
            }
            return builder.build();
        }
        ImmutableSet<ProfileId> allowedIds = authorizationContext.filterRoles((ImmutableCollection<ProfileReadRole>)((ImmutableCollection)Streams.stream(userIds).map(ProfileReadRole::of).collect(ImmutableSet.toImmutableSet())));
        PersonId currentUser = authorizationContext.getUserId();
        ImmutableSet<PersonId> participants = this._messageReadDataService.fetchParticipantsSharingAConversationWith(currentUser);
        for (PersonId personId : userIds) {
            if (participants.contains((Object)personId) || allowedIds.contains((Object)personId.asProfileId())) {
                builder.put((Object)personId, (Object)this.getPresenceByUserId(personId));
                continue;
            }
            builder.put((Object)personId, (Object)JabberPresence.UNKNOWN);
        }
        return builder.build();
    }

    @Nonnull
    public JabberPresence getPresenceByUserId(PersonId userId, AuthorizationCheckContextWithUserId authorizationContext) {
        if (!this._settings.isChatEnabled() || !this.isUserIsAllowedToSeePresence(authorizationContext, userId)) {
            return JabberPresence.UNKNOWN;
        }
        return this.getPresenceByUserId(userId);
    }

    private boolean isUserIsAllowedToSeePresence(AuthorizationCheckContextWithUserId authCtx, PersonId userId) {
        return this._messageReadDataService.isParticipantOfACommonConversation(authCtx.getUserId(), userId) || authCtx.may(ProfileReadRole.of(userId));
    }

    @Nonnull
    private JabberPresence getPresenceByUserId(PersonId userId) {
        JCXmppUserPresence presence = this._userPresenceStatus.get(userId);
        return presence != null ? presence.getPresence() : JabberPresence.OFFLINE;
    }

    @Nonnull
    private JabberPresence getPresenceByUserIdAndResourcePrefix(PersonId userId, JCXmppResourcePrefix prefix) {
        JCXmppUserPresence presence = this._userPresenceStatus.get(userId);
        return presence != null ? presence.getPresenceByResourcePrefix(prefix) : JabberPresence.OFFLINE;
    }

    @Nonnull
    public ImmutableMap<PersonId, JabberPresence> getPresenceByUserIdsAndResourcePrefix(Iterable<PersonId> userIds, JCXmppResourcePrefix prefix, AuthorizationCheckContext authorizationContext) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        if (!this._settings.isChatEnabled()) {
            for (PersonId personId : userIds) {
                builder.put((Object)personId, (Object)JabberPresence.UNKNOWN);
            }
            return builder.build();
        }
        ImmutableSet<ProfileId> allowedIds = authorizationContext.filterRoles((ImmutableCollection<ProfileReadRole>)((ImmutableCollection)Streams.stream(userIds).map(ProfileReadRole::of).collect(ImmutableSet.toImmutableSet())));
        for (PersonId personId : userIds) {
            if (allowedIds.contains((Object)personId.asProfileId())) {
                builder.put((Object)personId, (Object)this.getPresenceByUserIdAndResourcePrefix(personId, prefix));
                continue;
            }
            builder.put((Object)personId, (Object)JabberPresence.UNKNOWN);
        }
        return builder.build();
    }

    public void clearAndSyncConversationNodes() {
        ImmutableList<ConversationId> fetchResults;
        if (this._producer == null) {
            return;
        }
        int offset = 0;
        do {
            fetchResults = this._messageReadDataService.getAllGroupConversations(offset, 1000);
            offset += 1000;
            for (ConversationId conversationId : fetchResults) {
                this.enqueueDeleteNodeTask(conversationId);
                this.enqueueCreateNodeTask(conversationId);
                ImmutableList<DBConversationParticipant> dbConversationParticipants = this._messageReadDataService.getDBConversationParticipantsByConversationIds((Set<? extends ConversationId>)ImmutableSet.of((Object)conversationId));
                ImmutableList subscribers = (ImmutableList)dbConversationParticipants.stream().filter(participant -> !participant.isDeleted()).map(DBConversationParticipant::getParticipantId).collect(ImmutableList.toImmutableList());
                this.enqueueSubscribeTask(conversationId, (ImmutableList<PersonId>)subscribers);
            }
        } while (!fetchResults.isEmpty());
    }

    private void publishPubSubOperation(String nodeName, PubSubOperation operation) {
        if (this._producer == null) {
            return;
        }
        try {
            this._producer.send(new ProducerRecord("just.connect.pubSub.operations", (Object)nodeName, (Object)this._jsonMapper.writeValueAsString((Object)operation)));
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException("Serialization of PubSubOperation " + operation + " failed.");
        }
    }

    public void enqueueSendMessageTask(ConversationId conversationId, ChatMessageId chatMessageId) {
        this.publishPubSubOperation(conversationId.asString(), PubSubOperation.sendMessage(chatMessageId));
    }

    public void enqueueSendMessageTask(UserGroupId userGroupId, ChatMessageId chatMessageId) {
        this.publishPubSubOperation(userGroupId.toString(), PubSubOperation.sendMessage(chatMessageId));
    }

    @Deprecated
    public void publishToNode(String nodeName, ChatMessageId messageId) {
        ChatMessage message = (ChatMessage)this._messageReadDataService.getMessagesByIds((ImmutableSet<ChatMessageId>)ImmutableSet.of((Object)messageId)).get((Object)messageId);
        if (message == null) {
            LOG.info("Could not load message with id {} from db while trying to send message.", (Object)messageId);
            return;
        }
        try {
            String jsonMessage = this._jsonMapper.writeValueAsString((Object)message);
            Jid toPubSub = JidCreate.from((String)("pubsub." + this._domain));
            JID from = this._xmppSystemUserConnection.getSystemUserJid();
            PublishItemIq publishItemIq = new PublishItemIq(nodeName, jsonMessage);
            JCXmppStanza stanza = new JCXmppStanza(from.asString(), toPubSub.toString(), publishItemIq.toXML());
            this.sendCommand("send_stanza", stanza);
        }
        catch (XmppStringprepException | RestClientException e) {
            throw new ServiceException("Could not access ejabberd at: " + this._ejabberdApiUrlPrefix, e);
        }
        catch (JsonProcessingException e) {
            throw new ServiceException("Could not serialize chat message with id " + messageId, e);
        }
    }

    public void enqueueCreateNodeTask(ConversationId conversationId) {
        this.publishPubSubOperation(conversationId.asString(), PubSubOperation.createNode());
    }

    private void enqueueCreateNodeTask(UserGroupId userGroupId) {
        this.publishPubSubOperation(userGroupId.toString(), PubSubOperation.createNode());
    }

    private void enqueueSubscribeTask(String nodeName, ImmutableList<PersonId> subscribers) {
        if (subscribers.isEmpty()) {
            return;
        }
        Lists.partition(subscribers, (int)200).forEach(partition -> this.publishPubSubOperation(nodeName, PubSubOperation.subscribe(partition)));
    }

    private void enqueueUnsubscribeTask(String nodeName, ImmutableList<PersonId> subscribers) {
        if (subscribers.isEmpty()) {
            return;
        }
        Lists.partition(subscribers, (int)200).forEach(partition -> this.publishPubSubOperation(nodeName, PubSubOperation.unsubscribe(partition)));
    }

    public void enqueueSubscribeTask(ConversationId conversationId, ImmutableList<PersonId> subscribers) {
        this.enqueueSubscribeTask(conversationId.asString(), subscribers);
    }

    private void enqueueSubscribeTask(UserGroupId userGroupId, ImmutableList<PersonId> subscribers) {
        this.enqueueSubscribeTask(userGroupId.toString(), subscribers);
    }

    public void enqueueUnsubscribeTask(ConversationId conversationId, ImmutableList<PersonId> subscribers) {
        this.enqueueUnsubscribeTask(conversationId.asString(), subscribers);
    }

    private void enqueueUnsubscribeTask(UserGroupId userGroupId, ImmutableList<PersonId> subscribers) {
        this.enqueueUnsubscribeTask(userGroupId.toString(), subscribers);
    }

    public void enqueueDeleteNodeTask(ConversationId conversationId) {
        this.publishPubSubOperation(conversationId.asString(), PubSubOperation.deleteNode());
    }

    @Subscribe
    public void onUserGroupMemberAdded(@Nonnull UserGroupMemberAddedEvent event) {
        ImmutableMap addedMembers = event.getAddedMembers().asMap();
        addedMembers.forEach((userGroupId, memberIds) -> this.enqueueSubscribeTask((UserGroupId)userGroupId, (ImmutableList<PersonId>)ImmutableList.copyOf((Collection)memberIds)));
    }

    @Subscribe
    public void onUserGroupMemberRemoved(@Nonnull UserGroupMemberRemovedEvent event) {
        ImmutableMap removedMembers = event.getRemovedMembers().asMap();
        removedMembers.forEach((userGroupId, memberIds) -> this.enqueueUnsubscribeTask((UserGroupId)userGroupId, (ImmutableList<PersonId>)ImmutableList.copyOf((Collection)memberIds)));
    }
}

