/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.chat.integration.admin;

import com.google.common.base.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class JID {
    private final String _node;
    private final String _domain;
    private final String _resource;

    public JID(String jid) {
        String[] ss = jid.split("@");
        this._node = ss[0];
        int resouceIndex = ss[1].indexOf("/");
        if (resouceIndex < 0) {
            this._domain = ss[1];
            this._resource = null;
        } else {
            this._domain = ss[1].substring(0, resouceIndex);
            this._resource = ss[1].substring(resouceIndex + 1);
        }
    }

    public JID(String node, String domain) {
        this(node, domain, null);
    }

    public JID(String node, String domain, @Nullable String resource) {
        this._node = node;
        this._domain = domain;
        this._resource = resource;
    }

    public String getNode() {
        return this._node;
    }

    public String getDomain() {
        return this._domain;
    }

    public String getResource() {
        return this._resource;
    }

    @Nonnull
    public String asString() {
        return this._node + "@" + this._domain + (String)(this._resource == null ? "" : "/" + this._resource);
    }

    public String toString() {
        return this.asString();
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this._node, this._domain, this._resource});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !this.getClass().equals(obj.getClass())) {
            return false;
        }
        JID other = (JID)obj;
        return Objects.equal((Object)this._node, (Object)other._node) && Objects.equal((Object)this._domain, (Object)other._domain) && Objects.equal((Object)this._resource, (Object)other._resource);
    }
}

