/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.chat.business.impl;

import com.freiheit.superoperty.event.SuperopertyChangeEvent;
import com.freiheit.superoperty.event.SuperopertyChangeListener;
import com.freiheit.toro.admin.shared.server.superoperty.Settings;
import com.freiheit.toro.common.shared.model.ServiceException;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import de.justsoftware.onx.chat.business.ChatAuthenticationService;
import de.justsoftware.onx.chat.integration.admin.JID;
import de.justsoftware.onx.chat.model.JCXmppUserPresenceUpdateEvent;
import de.justsoftware.onx.chat.model.SmackInitializationException;
import de.justsoftware.onx.chat.shared.model.JabberPresence;
import de.justsoftware.onx.chat.util.JCXmppUtil;
import de.justsoftware.onx.common.business.events.JCEventBus;
import de.justsoftware.onx.common.shared.util.Numbers;
import de.justsoftware.toolbox.clock.Clock;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.X509TrustManager;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.jivesoftware.smack.AbstractXMPPConnection;
import org.jivesoftware.smack.ConnectionConfiguration;
import org.jivesoftware.smack.ConnectionListener;
import org.jivesoftware.smack.SmackConfiguration;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.SmackInitialization;
import org.jivesoftware.smack.StanzaListener;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.StanzaFilter;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Presence;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smack.tcp.XMPPTCPConnection;
import org.jivesoftware.smack.tcp.XMPPTCPConnectionConfiguration;
import org.jivesoftware.smackx.pubsub.AccessModel;
import org.jivesoftware.smackx.pubsub.NodeExtension;
import org.jivesoftware.smackx.pubsub.PubSubException;
import org.jivesoftware.smackx.pubsub.PubSubManager;
import org.jivesoftware.smackx.pubsub.PublishModel;
import org.jivesoftware.smackx.pubsub.Subscription;
import org.jivesoftware.smackx.pubsub.SubscriptionsExtension;
import org.jivesoftware.smackx.pubsub.form.FillableConfigureForm;
import org.jivesoftware.smackx.pubsub.packet.PubSub;
import org.jivesoftware.smackx.xdata.FormField;
import org.jivesoftware.smackx.xdata.ListSingleFormField;
import org.joda.time.DateTime;
import org.jxmpp.jid.Jid;
import org.jxmpp.jid.impl.JidCreate;
import org.jxmpp.stringprep.XmppStringprepException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.core.io.ClassPathResource;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.stereotype.Service;

@Service
@ParametersAreNonnullByDefault
public class XmppSystemUserConnection
implements SuperopertyChangeListener,
ConnectionListener,
StanzaListener,
StanzaFilter,
InitializingBean,
DisposableBean,
ApplicationListener<ContextRefreshedEvent> {
    private static final int SUBSCRIBER_PARTITION_SIZE = 50;
    private static final long SMACK_CONNECTION_TIMEOUT_IN_MS = 10000L;
    private static final String XMPP_SYSTEM_USERNAME = "xmpp-system-user";
    private static final Logger LOG = LoggerFactory.getLogger(XmppSystemUserConnection.class);
    private final Runnable _connectLater = () -> {
        this.updateSettings();
        LOG.info("retry connection to jabber server...");
        this.start();
    };
    private final ChatAuthenticationService _chatAuthenticationService;
    private final Settings _settings;
    private final JCEventBus _eventBus;
    private final Clock _clock;
    private final TaskScheduler _scheduler;
    private final String _host;
    private final int _port;
    private final String _resource;
    private final String _domain;
    private AbstractXMPPConnection _connection;
    private boolean _chatEnabled;
    private int _reconnectAttempts;
    private FillableConfigureForm _nodeConfig;

    @Autowired
    public XmppSystemUserConnection(ChatAuthenticationService chatAuthenticationService, Settings settings, JCEventBus eventBus, Clock clock, @Qualifier(value="jabberSystemUserConnectionTaskScheduler") TaskScheduler scheduler, @Value(value="${domain}") String domain, @Value(value="${xmpp.host}") String host, @Value(value="${xmpp.port}") int port, @Value(value="${xmpp.systemuser.resource}") String resource) throws KeyManagementException, NoSuchAlgorithmException {
        this._chatAuthenticationService = chatAuthenticationService;
        this._settings = settings;
        this._eventBus = eventBus;
        this._clock = clock;
        this._scheduler = scheduler;
        this._domain = domain;
        this._host = host;
        this._port = port;
        this._resource = resource;
        this.updateSettings();
        this._connection = null;
        this._reconnectAttempts = 0;
    }

    private void restart() {
        this.stop();
        this.start();
    }

    private void start() {
        if (!this._chatEnabled) {
            LOG.info("chat disabled - skip connecting to XMPP server ....");
        } else {
            try {
                LOG.info("start connecting system user");
                AbstractXMPPConnection connection = this.getConnection();
                connection.connect();
                LOG.info("login system user with JID: " + this.getSystemUserJid());
                connection.login();
                LOG.info("register listeners on connection");
                connection.addAsyncStanzaListener((StanzaListener)this, (StanzaFilter)this);
                connection.addConnectionListener((ConnectionListener)this);
                LOG.info("system user connected");
                this._reconnectAttempts = 0;
            }
            catch (SmackInitializationException | IOException | InterruptedException | SmackException | XMPPException e) {
                LOG.warn("error initializing system user connection (this might be OK at startup) : " + e.getMessage());
                this.stop();
                this.startLater();
            }
        }
    }

    @Nonnull
    private AbstractXMPPConnection getConnection() throws SmackInitializationException, XmppStringprepException {
        if (this._connection == null) {
            this._connection = this.createConnection();
        }
        return this._connection;
    }

    private void startLater() {
        if (this._reconnectAttempts < 50) {
            ++this._reconnectAttempts;
        }
        this._scheduler.schedule(this._connectLater, this.getReconnectTime(this._reconnectAttempts).toDate());
    }

    @Nonnull
    private DateTime getReconnectTime(int attemptCount) {
        int millisToWait = Numbers.longToInt(this.getReconnectStartDelay(attemptCount));
        return this._clock.now().plusMillis(millisToWait);
    }

    private long getReconnectStartDelay(int attemptCount) {
        if (attemptCount < 11) {
            return TimeUnit.SECONDS.toMillis(attemptCount / 4);
        }
        if (attemptCount < 21) {
            return TimeUnit.SECONDS.toMillis(attemptCount / 2);
        }
        if (attemptCount < 41) {
            return TimeUnit.SECONDS.toMillis(attemptCount);
        }
        return TimeUnit.MINUTES.toMillis(1L);
    }

    @CheckForNull
    private String getPassword(JID jid) {
        String user = jid.getNode();
        String host = jid.getDomain();
        return user != null && host != null ? this._chatAuthenticationService.getSystemUserChatPassword(user, host).getPassword() : null;
    }

    private void stop() {
        AbstractXMPPConnection connection = this._connection;
        this._connection = null;
        if (connection != null) {
            LOG.info("Stop XMPP connection for user: " + this.getSystemUserJid());
            connection.removeConnectionListener((ConnectionListener)this);
            connection.removeAsyncStanzaListener((StanzaListener)this);
            connection.disconnect();
        }
    }

    public void superopertyChange(SuperopertyChangeEvent paramSuperopertyChangeEvent) {
        LOG.info("Superoperty Chat Settings changed. Stop and reconnect the xmpp-system-user connection now.");
        this.updateSettings();
        this.restart();
    }

    private void updateSettings() {
        this._chatEnabled = this._settings.isChatEnabled();
    }

    public void afterPropertiesSet() {
        this._settings.getChatEnabledProperty().addSuperopertyChangeListener((SuperopertyChangeListener)this);
    }

    public void onApplicationEvent(ContextRefreshedEvent event) {
        this.startLater();
    }

    @Nonnull
    private AbstractXMPPConnection createConnection() throws SmackInitializationException, XmppStringprepException {
        if (!SmackConfiguration.isSmackInitialized()) {
            this.initializeSmack();
        }
        JID jid = this.getSystemUserJid();
        return new XMPPTCPConnection(((XMPPTCPConnectionConfiguration.Builder)((XMPPTCPConnectionConfiguration.Builder)((XMPPTCPConnectionConfiguration.Builder)((XMPPTCPConnectionConfiguration.Builder)((XMPPTCPConnectionConfiguration.Builder)((XMPPTCPConnectionConfiguration.Builder)((XMPPTCPConnectionConfiguration.Builder)((XMPPTCPConnectionConfiguration.Builder)((XMPPTCPConnectionConfiguration.Builder)((XMPPTCPConnectionConfiguration.Builder)XMPPTCPConnectionConfiguration.builder().setHost((CharSequence)this._host)).setXmppDomain(this._domain)).setPort(this._port)).setResource((CharSequence)this._resource)).setUsernameAndPassword((CharSequence)jid.asString(), this.getPassword(jid))).setCompressionEnabled(true)).setSendPresence(true)).setSecurityMode(ConnectionConfiguration.SecurityMode.ifpossible)).setCustomX509TrustManager(this.createEverythingAllowedTrustManager())).setHostnameVerifier((HostnameVerifier)NoopHostnameVerifier.INSTANCE)).build());
    }

    @Nonnull
    private X509TrustManager createEverythingAllowedTrustManager() {
        return new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                LOG.info("connection factory - check client certificate - allow all");
            }

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                LOG.info("connection factory - check server certificate - allow all");
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }
        };
    }

    private boolean initializeSmack() throws SmackInitializationException {
        ArrayList errors = Lists.newArrayList();
        try {
            ClassPathResource config = new ClassPathResource("org.jivesoftware.smack/smack-config.xml");
            SmackInitialization.processConfigFile((InputStream)config.getInputStream(), (Collection)errors);
            return errors.isEmpty() && SmackConfiguration.isSmackInitialized();
        }
        catch (Exception e) {
            for (Exception internalError : errors) {
                LOG.error("internal error while initializing smack", (Throwable)internalError);
            }
            throw new SmackInitializationException("error initializing smack", e);
        }
    }

    public void destroy() {
        this.stop();
    }

    public void authenticated(XMPPConnection connection, boolean resumed) {
        LOG.info("connection with XMPP server - connection authenticated");
    }

    public void connecting(XMPPConnection connection) {
        LOG.info("connecting to XMPP server");
    }

    public void connected(XMPPConnection connection) {
        LOG.info("connection with XMPP server - connection established");
    }

    public void connectionClosed() {
        LOG.info("connection with XMPP server - connection closed");
        this.restart();
    }

    public void connectionClosedOnError(Exception e) {
        LOG.error("connection with XMPP server - connection closed due to error", (Throwable)e);
        this.restart();
    }

    @Nonnull
    private static JabberPresence toJabberPresence(@Nullable Presence presence) {
        if (presence != null) {
            if (!presence.isAvailable()) {
                return JabberPresence.OFFLINE;
            }
            Presence.Mode mode = presence.getMode();
            if (mode == null || mode == Presence.Mode.available) {
                return JabberPresence.ONLINE;
            }
            for (JabberPresence val : JabberPresence.values()) {
                if (!mode.name().equals(val.getShow())) continue;
                return val;
            }
        }
        return JabberPresence.UNKNOWN;
    }

    private void processPresence(Presence presence) {
        JID sender = JCXmppUtil.getJid(presence.getFrom().toString());
        JabberPresence jabberPresence = XmppSystemUserConnection.toJabberPresence(presence);
        if (LOG.isDebugEnabled()) {
            LOG.debug("presence changed: " + sender + " - " + jabberPresence);
        }
        this._eventBus.post(new JCXmppUserPresenceUpdateEvent(sender, jabberPresence));
    }

    public boolean accept(Stanza stanza) {
        return stanza instanceof Presence;
    }

    public void processStanza(Stanza stanza) {
        if (stanza != null) {
            try {
                if (stanza instanceof Presence) {
                    this.processPresence((Presence)stanza);
                }
            }
            catch (ClassCastException cce) {
                LOG.error("could not process stanza, unknown type : " + stanza, (Throwable)cce);
            }
        }
    }

    @Nonnull
    public JID getSystemUserJid() {
        return JCXmppUtil.getJid(XMPP_SYSTEM_USERNAME, this._domain, this._resource);
    }

    private static boolean doesNodeExist(String nodeName, PubSubManager pubsubManager) throws SmackException.NotConnectedException, SmackException.NoResponseException, InterruptedException {
        try {
            pubsubManager.getNode(nodeName);
            return true;
        }
        catch (XMPPException.XMPPErrorException | PubSubException.NotAPubSubNodeException e) {
            return false;
        }
    }

    private FillableConfigureForm getNodeConfig(PubSubManager pubSubManager) throws XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException, SmackException.NoResponseException {
        if (this._nodeConfig == null) {
            this._nodeConfig = pubSubManager.getDefaultConfiguration().getFillableForm();
            this._nodeConfig.setAccessModel(AccessModel.authorize);
            this._nodeConfig.setPublishModel(PublishModel.publishers);
            this._nodeConfig.setPresenceBasedDelivery(true);
            this._nodeConfig.setNotifyRetract(false);
            this._nodeConfig.setPersistentItems(false);
            this._nodeConfig.write((FormField)((ListSingleFormField.Builder)FormField.listSingleBuilder((String)"pubsub#send_last_published_item").setValue((CharSequence)"never")).build());
        }
        return this._nodeConfig;
    }

    public void createNode(String nodeName) throws SmackException, XMPPException.XMPPErrorException, InterruptedException, XmppStringprepException, SmackInitializationException {
        PubSubManager pubSubManager = PubSubManager.getInstanceFor((XMPPConnection)this.getConnection());
        if (XmppSystemUserConnection.doesNodeExist(nodeName, pubSubManager)) {
            LOG.warn("PubSub Node {} already exists. Delete node and create a new one.", (Object)nodeName);
            this.deleteNode(nodeName);
        }
        LOG.debug("Create PubSub node {}.", (Object)nodeName);
        pubSubManager.createNode(nodeName, this.getNodeConfig(pubSubManager));
    }

    public void deleteNode(String nodeName) throws SmackException, XMPPException.XMPPErrorException, XmppStringprepException, SmackInitializationException, InterruptedException {
        PubSubManager pubSubManager = PubSubManager.getInstanceFor((XMPPConnection)this.getConnection());
        if (XmppSystemUserConnection.doesNodeExist(nodeName, pubSubManager)) {
            LOG.debug("Deleting PubSub node {}.", (Object)nodeName);
            pubSubManager.deleteNode(nodeName);
        } else {
            LOG.debug("PubSub node {} does not exist. Skip deleting node.", (Object)nodeName);
        }
    }

    public void subscribe(String nodeName, ImmutableSet<JID> subscribers) throws SmackException, XMPPException.XMPPErrorException, XmppStringprepException, InterruptedException, SmackInitializationException {
        LOG.debug("Subscribe {} subscribers to PubSub node {}.", (Object)subscribers.size(), (Object)nodeName);
        this.manageSubscriptions(nodeName, subscribers, Subscription.State.subscribed);
    }

    public void unsubscribe(String nodeName, ImmutableSet<JID> subscribers) throws SmackException, XMPPException.XMPPErrorException, XmppStringprepException, InterruptedException, SmackInitializationException {
        LOG.debug("Unsubscribe {} subscribers to PubSub node {}.", (Object)subscribers.size(), (Object)nodeName);
        this.manageSubscriptions(nodeName, subscribers, Subscription.State.none);
    }

    private static Jid convertJID(JID jid) {
        try {
            return JidCreate.from((String)jid.asString());
        }
        catch (XmppStringprepException e) {
            throw new ServiceException("Cannot convert JID " + jid.asString() + " to Jid.", e);
        }
    }

    private ImmutableList<Jid> getSubscriptions(String nodeName) throws XmppStringprepException, SmackInitializationException, SmackException.NotConnectedException, InterruptedException, XMPPException.XMPPErrorException, SmackException.NoResponseException {
        PubSub subscriptionIq = PubSub.createPubsubPacket((Jid)JidCreate.from((String)("pubsub." + this._domain)), (IQ.Type)IQ.Type.get, (NodeExtension)new SubscriptionsExtension(SubscriptionsExtension.SubscriptionsNamespace.owner, nodeName, null));
        SubscriptionsExtension extension = (SubscriptionsExtension)this.getConnection().createStanzaCollectorAndSend((IQ)subscriptionIq).nextResultOrThrow(10000L).getExtension(SubscriptionsExtension.SubscriptionsNamespace.owner.type.getNamespace().getXmlns());
        return (ImmutableList)extension.getSubscriptions().stream().map(Subscription::getJid).collect(ImmutableList.toImmutableList());
    }

    private void manageSubscriptions(String nodeName, ImmutableSet<JID> subscribers, Subscription.State state) throws XmppStringprepException, SmackInitializationException, SmackException.NotConnectedException, InterruptedException, XMPPException.XMPPErrorException, SmackException.NoResponseException {
        List subscriptions = subscribers.stream().map(XmppSystemUserConnection::convertJID).map(jid -> new Subscription(jid, nodeName, null, state)).collect(Collectors.toList());
        List subscriptionPartitions = Lists.partition(subscriptions, (int)50);
        for (List subscriptionPartition : subscriptionPartitions) {
            PubSub subscriptionIq = PubSub.createPubsubPacket((Jid)JidCreate.from((String)("pubsub." + this._domain)), (IQ.Type)IQ.Type.set, (NodeExtension)new SubscriptionsExtension(SubscriptionsExtension.SubscriptionsNamespace.owner, nodeName, subscriptionPartition));
            try {
                this.getConnection().createStanzaCollectorAndSend((IQ)subscriptionIq).nextResultOrThrow(10000L);
            }
            catch (XMPPException.XMPPErrorException e) {
                if (state == Subscription.State.none) {
                    LOG.info("Failed to unsubscribe from node {}, try to unsubscribe via deltas.", (Object)nodeName);
                    this.sendDeltaSubscriptions(nodeName, subscriptionPartition);
                    return;
                }
                throw e;
            }
        }
    }

    private void sendDeltaSubscriptions(String nodeName, List<Subscription> subscriptions) throws SmackInitializationException, SmackException.NoResponseException, SmackException.NotConnectedException, InterruptedException, XmppStringprepException, XMPPException.XMPPErrorException {
        ImmutableList<Jid> currentSubscriptions = this.getSubscriptions(nodeName);
        List deltaSubscriptions = subscriptions.stream().filter(subscription -> currentSubscriptions.contains((Object)subscription.getJid())).collect(Collectors.toList());
        if (deltaSubscriptions.isEmpty()) {
            return;
        }
        PubSub deltaSubscriptionIq = PubSub.createPubsubPacket((Jid)JidCreate.from((String)("pubsub." + this._domain)), (IQ.Type)IQ.Type.set, (NodeExtension)new SubscriptionsExtension(SubscriptionsExtension.SubscriptionsNamespace.owner, nodeName, deltaSubscriptions));
        this.getConnection().createStanzaCollectorAndSend((IQ)deltaSubscriptionIq).nextResultOrThrow(10000L);
    }
}

