/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.chat.business.impl;

import com.freiheit.toro.admin.shared.server.superoperty.Settings;
import com.freiheit.toro.cache.CacheKey;
import com.freiheit.toro.cache.CacheName;
import com.freiheit.toro.cache.memcached.MemcachedClientCache;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import de.justsoftware.onx.chat.business.JabberContactSyncService;
import de.justsoftware.onx.chat.business.impl.XmppSystemUserConnection;
import de.justsoftware.onx.chat.integration.admin.JID;
import de.justsoftware.onx.chat.integration.admin.XmppService;
import de.justsoftware.onx.chat.integration.persistence.JabberContactSyncDAO;
import de.justsoftware.onx.chat.shared.model.ChatUserType;
import de.justsoftware.onx.common.business.events.ServerEventHandler;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.events.PersonActivatedEvent;
import de.justsoftware.onx.events.PersonDeactivatedOrDeletedEvent;
import de.justsoftware.onx.events.PersonDeletedEvent;
import de.justsoftware.onx.events.PersonUpdatedEvent;
import de.justsoftware.onx.events.ProfileVisibilitiesChangedEvent;
import de.justsoftware.onx.message.business.MessageReadDataService;
import de.justsoftware.onx.message.business.MessageService;
import de.justsoftware.onx.message.business.events.ConversationUpdatedEvent;
import de.justsoftware.onx.message.model.Conversation;
import de.justsoftware.onx.message.shared.model.ConversationId;
import de.justsoftware.onx.message.shared.model.ConversationType;
import de.justsoftware.onx.person.business.PersonService;
import de.justsoftware.onx.server.business.ClusterConfiguration;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="jabberContactSyncService")
@ParametersAreNonnullByDefault
public class JabberContactSyncServiceImpl
implements ServerEventHandler,
JabberContactSyncService {
    private static final Logger LOG = LoggerFactory.getLogger(JabberContactSyncServiceImpl.class);
    private static final int BULK_SIZE = 100;
    private static final CacheKey SYNCED_CACHE_KEY = new CacheKey((CacheName)JabberContactSyncServiceCacheName.GENERIC, "Synced");
    private static final long SYNCED_CACHE_DURATION = 600L;
    private static final String SYNCED_CACHE_DATA = "Some unused data for memcache";
    @Autowired
    private JabberContactSyncDAO _jabberContactSyncDAO;
    @Autowired
    private Settings _settings;
    @Autowired
    private XmppService _xmppService;
    @Autowired
    private PersonService _personService;
    @Autowired
    private MessageService _messageService;
    @Autowired
    private MessageReadDataService _messageReadDataService;
    @Autowired
    private MemcachedClientCache _cache;
    @Autowired
    private XmppSystemUserConnection _xmppSystemUserConnection;
    @Autowired
    private ClusterConfiguration _clusterConfiguration;
    @Value(value="${domain}")
    private String _domain;

    @Override
    public void executeSync() {
        if (!this._clusterConfiguration.isMaster()) {
            return;
        }
        if (!this._settings.isChatEnabled()) {
            return;
        }
        if (this._cache.get(SYNCED_CACHE_KEY) != null) {
            return;
        }
        this._cache.set(SYNCED_CACHE_KEY, (Object)SYNCED_CACHE_DATA, 600L);
        long startTime = System.currentTimeMillis();
        int totalCount = 0;
        boolean workLeft = true;
        while (workLeft) {
            int count = this.syncOneBulk();
            totalCount += count;
            workLeft = count > 0;
        }
        if (totalCount > 0) {
            LOG.debug(String.format("Synced %s jabber profiles in %s seconds.", totalCount, (double)(System.currentTimeMillis() - startTime) / 1000.0));
        }
    }

    @Nonnull
    private JID jidFor(PersonId id) {
        return this.jidFor(id, ChatUserType.USER);
    }

    @Nonnull
    private JID jidFor(PersonId id, ChatUserType chatUserType) {
        return new JID(chatUserType.toLogin(id.toString()), this._domain);
    }

    private int syncOneBulk() {
        ImmutableSet<PersonId> rosterIds = this._jabberContactSyncDAO.getUnsyncedProfiles(100);
        this._jabberContactSyncDAO.markInProgress((Set<PersonId>)rosterIds);
        boolean finished = false;
        try {
            rosterIds.forEach(this::syncOneUser);
            finished = true;
        }
        finally {
            if (!finished) {
                this._jabberContactSyncDAO.markUnsynced((Set<PersonId>)rosterIds);
            }
        }
        this._jabberContactSyncDAO.markSynced((Set<PersonId>)rosterIds);
        return rosterIds.size();
    }

    private void syncOneUser(PersonId userToSync) {
        JID userJid = this.jidFor(userToSync);
        ImmutableSet<PersonId> conversationPartners = this._messageReadDataService.getOneOnOneConversationPartnersByPersonId(userToSync);
        for (PersonId id : conversationPartners) {
            this._xmppService.addContacts(userJid, this.jidFor(id));
        }
        this._xmppService.addContacts(userJid, this._xmppSystemUserConnection.getSystemUserJid());
    }

    private void deleteMemcache() {
        try {
            this._cache.delete(SYNCED_CACHE_KEY).get();
        }
        catch (InterruptedException | ExecutionException exception) {
            // empty catch block
        }
    }

    @Override
    public void markEverybodyUnsynced() {
        this._jabberContactSyncDAO.markEverybodyUnsynced();
        this.deleteMemcache();
        LOG.info("markEverybodyUnsynced was called");
    }

    private void markUnsynched(PersonId id) {
        this.markUnsynched((Set<PersonId>)ImmutableSet.of((Object)id));
    }

    private void markUnsynched(Set<PersonId> personIds) {
        if (!personIds.isEmpty()) {
            this._jabberContactSyncDAO.markUnsynced(personIds);
            this.deleteMemcache();
        }
    }

    @Override
    public void contactListChanged(PersonId id) {
        this.markUnsynched(id);
    }

    @Subscribe
    @AllowConcurrentEvents
    public void onPersonActivated(PersonActivatedEvent event) {
        this.markUnsynched(event.getPersonId());
    }

    @Subscribe
    @AllowConcurrentEvents
    public void onPersonDeactivatedOrDeleted(PersonDeactivatedOrDeletedEvent event) {
        this.markUnsynched(event.getPersonId());
    }

    @Subscribe
    @AllowConcurrentEvents
    public void onPersonUpdatedEvent(PersonUpdatedEvent event) {
        this.markUnsynched(event.getPersonId());
    }

    @Subscribe
    @AllowConcurrentEvents
    public void onPersonDeletedEvent(PersonDeletedEvent event) {
        this.markEverybodyUnsynced();
    }

    @Subscribe
    @AllowConcurrentEvents
    public void onProfileVisibilitiesChangedEvent(ProfileVisibilitiesChangedEvent event) {
        this.markUnsynched(event.getProfileId().asPersonId());
    }

    @Subscribe
    @AllowConcurrentEvents
    public void onConversationUpdatedEvent(ConversationUpdatedEvent event) {
        Conversation conversation;
        if (this._settings.isChatEnabled() && (conversation = (Conversation)this._messageReadDataService.getConversationsByIds((Set<ConversationId>)ImmutableSet.of((Object)event.getConversationId())).get((Object)event.getConversationId())) != null && conversation.getType() == ConversationType.ONE_ON_ONE) {
            this.markUnsynched((Set<PersonId>)Sets.union(event.getAddedParticipants(), event.getRemovedParticipants()));
        }
    }

    private static enum JabberContactSyncServiceCacheName implements CacheName
    {
        GENERIC("JabberContactSyncService");

        private final String _name;

        private JabberContactSyncServiceCacheName(String name) {
            this._name = name;
        }

        @Override
        public String getCacheName() {
            return this._name;
        }
    }
}

