/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.chat.business.impl;

import com.freiheit.superoperty.event.SuperopertyChangeEvent;
import com.freiheit.superoperty.event.SuperopertyChangeListener;
import com.freiheit.toro.admin.shared.server.superoperty.Settings;
import com.google.common.collect.Lists;
import de.justsoftware.onx.chat.business.ChatAuthenticationService;
import de.justsoftware.onx.chat.integration.admin.JID;
import de.justsoftware.onx.chat.model.SmackInitializationException;
import de.justsoftware.onx.chat.shared.model.ChatUserType;
import de.justsoftware.onx.chat.util.JCXmppUtil;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.common.shared.util.Numbers;
import de.justsoftware.onx.message.business.ChatBotService;
import de.justsoftware.toolbox.clock.Clock;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.X509TrustManager;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.jivesoftware.smack.AbstractXMPPConnection;
import org.jivesoftware.smack.ConnectionConfiguration;
import org.jivesoftware.smack.ConnectionListener;
import org.jivesoftware.smack.SmackConfiguration;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.SmackInitialization;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.tcp.XMPPTCPConnection;
import org.jivesoftware.smack.tcp.XMPPTCPConnectionConfiguration;
import org.joda.time.DateTime;
import org.jxmpp.stringprep.XmppStringprepException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.core.io.ClassPathResource;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.stereotype.Service;

@Service(value="jabberBotUserConnection")
@ParametersAreNonnullByDefault
public class JabberBotUserConnectionImpl
implements SuperopertyChangeListener,
ConnectionListener,
InitializingBean,
DisposableBean,
ApplicationListener<ContextRefreshedEvent> {
    private static final Logger LOG = LoggerFactory.getLogger(JabberBotUserConnectionImpl.class);
    private final ChatAuthenticationService _chatAuthenticationService;
    private final ChatBotService _chatBotService;
    private final Settings _settings;
    private final Clock _clock;
    private final TaskScheduler _scheduler;
    private final String _host;
    private final int _port;
    private final String _resource;
    private final String _jabberDomain;
    private AbstractXMPPConnection _connection;
    private int _reconnectAttempts;
    private boolean _chatBotEnabled;
    private PersonId _chatBotPersonId;

    @Autowired
    public JabberBotUserConnectionImpl(ChatAuthenticationService chatAuthenticationService, ChatBotService chatBotService, Settings settings, Clock clock, @Qualifier(value="jabberSystemUserConnectionTaskScheduler") TaskScheduler scheduler, @Value(value="${domain}") String jabberDomain, @Value(value="${xmpp.host}") String host, @Value(value="${xmpp.port}") int port, @Value(value="${xmpp.systemuser.resource}") String resource) throws KeyManagementException, NoSuchAlgorithmException {
        this._chatAuthenticationService = chatAuthenticationService;
        this._chatBotService = chatBotService;
        this._settings = settings;
        this._clock = clock;
        this._scheduler = scheduler;
        this._jabberDomain = jabberDomain;
        this._host = host;
        this._port = port;
        this._resource = resource;
        this.updateSettings();
        this._connection = null;
        this._reconnectAttempts = 0;
    }

    private void restart() {
        this.stop();
        this.start();
    }

    private void start() {
        if (!this._chatBotEnabled) {
            LOG.info("chat bot disabled - skip connecting to jabber server ....");
        } else {
            try {
                LOG.info("start connecting bot user");
                AbstractXMPPConnection connection = this.getConnection();
                connection.connect();
                LOG.info("login bot user with JID: " + this.getJabberBotUserJid());
                connection.login();
                LOG.info("register listeners on connection");
                connection.addConnectionListener((ConnectionListener)this);
                LOG.info("bot user connected");
                this._reconnectAttempts = 0;
            }
            catch (SmackInitializationException | IOException | InterruptedException | SmackException | XMPPException e) {
                LOG.warn("error initializing bot user connection (this might be OK at startup) : " + e.getMessage());
                this.stop();
                this.startLater();
            }
        }
    }

    @Nonnull
    private JID getJabberBotUserJid() {
        return JCXmppUtil.getJid(this._chatBotPersonId, this._jabberDomain, this._resource);
    }

    @Nonnull
    private AbstractXMPPConnection getConnection() throws XmppStringprepException, SmackInitializationException {
        if (this._connection == null) {
            this._connection = this.createConnection();
        }
        return this._connection;
    }

    private void startLater() {
        if (this._reconnectAttempts < 50) {
            ++this._reconnectAttempts;
        }
        this._scheduler.schedule(this::reconnect, this.getReconnectTime(this._reconnectAttempts).toDate());
    }

    private void reconnect() {
        this.updateSettings();
        LOG.info("retry connection to jabber server...");
        this.start();
    }

    @Nonnull
    private DateTime getReconnectTime(int attemptCount) {
        int millisToWait = Numbers.longToInt(this.getReconnectStartDelay(attemptCount));
        return this._clock.now().plusMillis(millisToWait);
    }

    private long getReconnectStartDelay(int attemptCount) {
        if (attemptCount < 11) {
            return TimeUnit.SECONDS.toMillis(attemptCount / 4);
        }
        if (attemptCount < 21) {
            return TimeUnit.SECONDS.toMillis(attemptCount / 2);
        }
        if (attemptCount < 41) {
            return TimeUnit.SECONDS.toMillis(attemptCount);
        }
        return TimeUnit.MINUTES.toMillis(1L);
    }

    private void stop() {
        AbstractXMPPConnection connection = this._connection;
        this._connection = null;
        if (connection != null) {
            LOG.info("Stop jabber connection for user: " + this.getJabberBotUserJid());
            connection.removeConnectionListener((ConnectionListener)this);
            connection.disconnect();
        }
    }

    public void superopertyChange(SuperopertyChangeEvent paramSuperopertyChangeEvent) {
        LOG.info("Superoperty Chat Settings changed. Stop and reconnect the xmpp-system-user connection now.");
        this.updateSettings();
        this.restart();
    }

    private void updateSettings() {
        boolean chatEnabled = this._settings.isChatEnabled();
        this._chatBotPersonId = this._chatBotService.getChatBotPersonId().orElse(null);
        this._chatBotEnabled = chatEnabled && this._settings.isChatBotEnabled() && this._chatBotPersonId != null;
    }

    public void afterPropertiesSet() {
        this._settings.getChatEnabledProperty().addSuperopertyChangeListener((SuperopertyChangeListener)this);
        this._settings.getChatBotEnabledProperty().addSuperopertyChangeListener((SuperopertyChangeListener)this);
        this._settings.getChatBotPersonIdProperty().addSuperopertyChangeListener((SuperopertyChangeListener)this);
    }

    public void onApplicationEvent(ContextRefreshedEvent event) {
        this.startLater();
    }

    @Nonnull
    private AbstractXMPPConnection createConnection() throws XmppStringprepException, SmackInitializationException {
        if (!SmackConfiguration.isSmackInitialized()) {
            this.initializeSmack();
        }
        String userName = this.getJabberBotUserJid().asString();
        String password = this._chatAuthenticationService.getChatPassword(ChatUserType.USER, this._chatBotPersonId);
        return new XMPPTCPConnection(((XMPPTCPConnectionConfiguration.Builder)((XMPPTCPConnectionConfiguration.Builder)((XMPPTCPConnectionConfiguration.Builder)((XMPPTCPConnectionConfiguration.Builder)((XMPPTCPConnectionConfiguration.Builder)((XMPPTCPConnectionConfiguration.Builder)((XMPPTCPConnectionConfiguration.Builder)((XMPPTCPConnectionConfiguration.Builder)((XMPPTCPConnectionConfiguration.Builder)((XMPPTCPConnectionConfiguration.Builder)XMPPTCPConnectionConfiguration.builder().setHost((CharSequence)this._host)).setXmppDomain(this._jabberDomain)).setPort(this._port)).setResource((CharSequence)this._resource)).setUsernameAndPassword((CharSequence)userName, password)).setCompressionEnabled(true)).setSendPresence(true)).setSecurityMode(ConnectionConfiguration.SecurityMode.ifpossible)).setCustomX509TrustManager(this.createEverythingAllowedTrustManager())).setHostnameVerifier((HostnameVerifier)NoopHostnameVerifier.INSTANCE)).build());
    }

    @Nonnull
    private X509TrustManager createEverythingAllowedTrustManager() {
        return new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                LOG.info("connection factory - check client certificate - allow all");
            }

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                LOG.info("connection factory - check server certificate - allow all");
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }
        };
    }

    private boolean initializeSmack() throws SmackInitializationException {
        ArrayList errors = Lists.newArrayList();
        try {
            ClassPathResource config = new ClassPathResource("org.jivesoftware.smack/smack-config.xml");
            SmackInitialization.processConfigFile((InputStream)config.getInputStream(), (Collection)errors);
            return errors.isEmpty() && SmackConfiguration.isSmackInitialized();
        }
        catch (Exception e) {
            for (Exception internalError : errors) {
                LOG.error("internal error while initializing smack", (Throwable)internalError);
            }
            throw new SmackInitializationException("error initializing smack", e);
        }
    }

    public void destroy() {
        this.stop();
    }

    public void authenticated(XMPPConnection connection, boolean resumed) {
        LOG.info("connection with jabber server - connection authenticated");
    }

    public void connected(XMPPConnection connection) {
        LOG.info("connection with jabber server - connection established");
    }

    public void connectionClosed() {
        LOG.info("connection with jabber server - connection closed");
        this.restart();
    }

    public void connectionClosedOnError(Exception e) {
        LOG.error("connection with jabber server - connection closed due to error", (Throwable)e);
        this.restart();
    }
}

