/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.chat.business.impl;

import de.justsoftware.onx.chat.business.ChatAuthenticationService;
import de.justsoftware.onx.chat.integration.persistence.JabberTemporaryPasswordDAO;
import de.justsoftware.onx.chat.integration.persistence.ibatis.model.ExpiringChatSystemUserPasswordIbatisModel;
import de.justsoftware.onx.chat.model.ChatLogin;
import de.justsoftware.onx.chat.model.ExpiringChatSystemUserPassword;
import de.justsoftware.onx.chat.shared.model.ChatUserType;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.common.shared.server.TransactionHelper;
import de.justsoftware.onx.person.business.PersonService;
import de.justsoftware.onx.util.server.SecureRandomUtil;
import de.justsoftware.toolbox.clock.Clock;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.TransactionException;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;

@Service
public class ChatAuthenticationServiceImpl
implements ChatAuthenticationService {
    private static final int PASSWD_EXPIRE_MINUTES = 10;
    private static final int SYSTEM_PASSWD_EXPIRE_HOURS = 24;
    private static final int SYSTEM_PASSWD_EXPIRATION_BUFFER_MINUTES = 5;
    @Autowired
    private JabberTemporaryPasswordDAO _passwordDAO;
    @Autowired
    private TransactionHelper _transactionHelper;
    @Autowired
    private PersonService _personService;
    @Autowired
    private Clock _clock;

    @Override
    public boolean authorize(String user, String server, String password) {
        ChatLogin login = ChatLogin.parse(user);
        return login == null ? this.verifySystemUser(user, server, password) : this.verifyUser(login, password);
    }

    @ParametersAreNonnullByDefault
    private boolean verifyUser(ChatLogin login, String password) {
        return password.equals(this._passwordDAO.getByPersonIdAndType(login.getPersonId(), login.getType()));
    }

    @ParametersAreNonnullByDefault
    private boolean verifySystemUser(String user, String server, String password) {
        ExpiringChatSystemUserPassword systemUserPassword = this.getSystemUserChatPassword(user, server);
        DateTime validUntil = systemUserPassword.getValidUntil();
        return systemUserPassword.getPassword().equals(password) && (validUntil == null || this._clock.now().isBefore((ReadableInstant)validUntil.plusMinutes(5)));
    }

    @Override
    public boolean userExists(String user) {
        ChatLogin login = ChatLogin.parse(user);
        return login != null && this._personService.getPersonById(login.getPersonId()) != null;
    }

    @Override
    public String getChatPassword(final ChatUserType userType, final PersonId loggedInPersonId) {
        String actualPasswd = this.getExistingUnexpiredChatPassword(userType, loggedInPersonId);
        if (actualPasswd != null) {
            return actualPasswd;
        }
        try {
            return this._transactionHelper.doInTransaction(new TransactionCallback<String>(){

                public String doInTransaction(TransactionStatus status) {
                    String password = SecureRandomUtil.randomHex();
                    DateTime validTo = ChatAuthenticationServiceImpl.this._clock.now().plusMinutes(10);
                    ChatAuthenticationServiceImpl.this._passwordDAO.update(loggedInPersonId, userType, password, validTo);
                    ChatAuthenticationServiceImpl.this._passwordDAO.tryInsert(loggedInPersonId, userType, password, validTo);
                    return password;
                }
            });
        }
        catch (TransactionException e) {
            String password = this.getExistingUnexpiredChatPassword(userType, loggedInPersonId);
            if (password == null) {
                throw new IllegalStateException("Error during get temp chat password. Couldn't create a new temp password and also don't find an existing temp password!");
            }
            return password;
        }
    }

    @CheckForNull
    private String getExistingUnexpiredChatPassword(@Nonnull ChatUserType userType, @Nonnull PersonId loggedInPersonId) {
        String actualPasswd = this._passwordDAO.getByPersonIdAndType(loggedInPersonId, userType);
        if (actualPasswd == null) {
            return null;
        }
        this._passwordDAO.update(loggedInPersonId, userType, actualPasswd, this._clock.now().plusMinutes(10));
        return actualPasswd;
    }

    @Override
    public ExpiringChatSystemUserPassword getSystemUserChatPassword(String username, String server) {
        ExpiringChatSystemUserPasswordIbatisModel dbModel = this._passwordDAO.getChatSystemUserPassword(username, server);
        if (dbModel == null) {
            return this.insertNewSystemUserPassword(username, server);
        }
        DateTime validUntil = dbModel.getValidUntil();
        if (validUntil != null && validUntil.isBefore((ReadableInstant)this._clock.now())) {
            return this.updateSystemUserPassword(username, server);
        }
        return new ExpiringChatSystemUserPassword(dbModel.getPassword(), dbModel.getValidUntil());
    }

    @Nonnull
    private ExpiringChatSystemUserPassword insertNewSystemUserPassword(@Nonnull String username, @Nonnull String server) {
        ExpiringChatSystemUserPassword newPwd = this.createNewSystemUserPassword();
        this._passwordDAO.insertChatSystemUserPassword(username, server, newPwd.getPassword(), newPwd.getValidUntil());
        return newPwd;
    }

    @Nonnull
    private ExpiringChatSystemUserPassword updateSystemUserPassword(@Nonnull String username, @Nonnull String server) {
        ExpiringChatSystemUserPassword updatedPwd = this.createNewSystemUserPassword();
        this._passwordDAO.updateChatSystemUserPassword(username, server, updatedPwd.getPassword(), updatedPwd.getValidUntil());
        return updatedPwd;
    }

    @Nonnull
    private ExpiringChatSystemUserPassword createNewSystemUserPassword() {
        return new ExpiringChatSystemUserPassword(SecureRandomUtil.randomHex(), this._clock.now().plusHours(24));
    }
}

