/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.chat.business;

import com.google.common.annotations.VisibleForTesting;
import de.justsoftware.onx.common.shared.server.TransactionHelper;
import de.justsoftware.onx.container.shared.model.IdParseException;
import de.justsoftware.onx.container.shared.model.TenantId;
import de.justsoftware.onx.kafka.AbstractKafkaConsumer;
import de.justsoftware.onx.kafka.KafkaConfigurationProvider;
import de.justsoftware.onx.kafka.KafkaConsumerContext;
import de.justsoftware.onx.message.business.MessageService;
import java.util.NoSuchElementException;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
@Lazy(value=false)
@ParametersAreNonnullByDefault
public class KafkaTenantsConsumer
extends AbstractKafkaConsumer<String, String> {
    private static final Logger LOG = LoggerFactory.getLogger(KafkaTenantsConsumer.class);
    private final MessageService _messageService;

    @Autowired
    public KafkaTenantsConsumer(KafkaConfigurationProvider configProvider, TransactionHelper transactionHelper, MessageService messageService) {
        this(configProvider.stringConsumer("just.connect.TenantsConsumer"), transactionHelper, messageService);
    }

    @VisibleForTesting
    KafkaTenantsConsumer(@Nullable Consumer<String, String> consumer, TransactionHelper transactionHelper, MessageService messageService) {
        super(consumer, transactionHelper, "just.tenants");
        this._messageService = messageService;
    }

    @Override
    protected Logger getLog() {
        return LOG;
    }

    @Override
    protected void process(ConsumerRecords<String, String> records, KafkaConsumerContext context) {
        for (ConsumerRecord record : records) {
            try {
                TenantId tenantId = TenantId.parse((String)record.key()).orElseThrow();
                if (record.value() != null) continue;
                this._messageService.deleteAllConversationsForTenantUnauthorized(tenantId);
                return;
            }
            catch (IdParseException | NoSuchElementException e) {
                LOG.warn(String.format("Skipping record. Could not parse record key to TenantId. %s", record), (Throwable)e);
            }
        }
    }
}

