/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.chat.business;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.freiheit.superoperty.event.SuperopertyChangeEvent;
import com.freiheit.superoperty.event.SuperopertyChangeListener;
import com.freiheit.toro.admin.shared.server.superoperty.Settings;
import com.freiheit.toro.common.shared.model.ServiceException;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.onx.chat.business.impl.XmppSystemUserConnection;
import de.justsoftware.onx.chat.integration.admin.JID;
import de.justsoftware.onx.chat.integration.admin.XmppService;
import de.justsoftware.onx.chat.model.PubSubOperation;
import de.justsoftware.onx.chat.model.SmackInitializationException;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.common.shared.server.TransactionHelper;
import de.justsoftware.onx.container.shared.model.IdParseException;
import de.justsoftware.onx.kafka.AbstractKafkaConsumer;
import de.justsoftware.onx.kafka.KafkaConfigurationProvider;
import de.justsoftware.onx.kafka.KafkaConsumerContext;
import de.justsoftware.onx.message.shared.model.ChatMessageId;
import java.io.IOException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPException;
import org.jxmpp.stringprep.XmppStringprepException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
@ParametersAreNonnullByDefault
public class KafkaPubSubOperationsConsumer
extends AbstractKafkaConsumer<String, String>
implements SuperopertyChangeListener {
    private static final Logger LOG = LoggerFactory.getLogger(KafkaPubSubOperationsConsumer.class);
    private final XmppSystemUserConnection _xmppSystemUserConnection;
    private final XmppService _xmppService;
    private final ObjectMapper _objectMapper;
    private final String _domain;
    private final Settings _settings;

    @Autowired
    public KafkaPubSubOperationsConsumer(TransactionHelper transactionHelper, KafkaConfigurationProvider kafkaConfigurationProvider, XmppSystemUserConnection xmppSystemUserConnection, XmppService xmppService, ObjectMapper objectMapper, @Value(value="${domain}") String domain, Settings settings) {
        this(kafkaConfigurationProvider.stringConsumer("just.connect.pubSub.operationsConsumer", 1), transactionHelper, xmppSystemUserConnection, xmppService, objectMapper, domain, settings);
    }

    @VisibleForTesting
    KafkaPubSubOperationsConsumer(@Nullable Consumer<String, String> consumer, TransactionHelper transactionHelper, XmppSystemUserConnection xmppSystemUserConnection, XmppService xmppService, ObjectMapper objectMapper, @Value(value="${domain}") String domain, Settings settings) {
        super(consumer, transactionHelper, "just.connect.pubSub.operations");
        this._xmppSystemUserConnection = xmppSystemUserConnection;
        this._xmppService = xmppService;
        this._objectMapper = objectMapper;
        this._domain = domain;
        this._settings = settings;
        this._settings.getChatEnabledProperty().addSuperopertyChangeListener((SuperopertyChangeListener)this);
        if (!this._settings.isChatEnabled()) {
            this.pause();
        }
    }

    @Override
    @Nonnull
    protected Logger getLog() {
        return LOG;
    }

    @Override
    protected void process(ConsumerRecords<String, String> records, KafkaConsumerContext context) {
        records.forEach(record -> {
            try {
                String nodeName = (String)record.key();
                PubSubOperation pubSubOperation = (PubSubOperation)this._objectMapper.readValue((String)record.value(), PubSubOperation.class);
                this.handlePubSubOperation(nodeName, pubSubOperation);
            }
            catch (IdParseException e) {
                LOG.error("Conversation with id {} could not be parsed.", record.key());
            }
            catch (IOException e) {
                LOG.error("PubSubOperation {} with ConversationId {} could not be parsed.", record.value(), record.key());
            }
        });
    }

    private void handlePubSubOperation(String nodeName, PubSubOperation operation) throws ServiceException {
        switch (operation.getType()) {
            case CREATE_NODE: {
                this.createNode(nodeName);
                break;
            }
            case DELETE_NODE: {
                this.deleteNode(nodeName);
                break;
            }
            case SUBSCRIBE: {
                this.subscribe(nodeName, operation.getSubscribers(), true);
                break;
            }
            case UNSUBSCRIBE: {
                this.unsubscribe(nodeName, operation.getSubscribers());
                break;
            }
            case SEND_MESSAGE: {
                this.sendMessage(nodeName, operation.getChatMessageId());
            }
        }
    }

    private void sendMessage(String nodeName, @Nullable ChatMessageId chatMessageId) {
        if (chatMessageId == null) {
            LOG.error("Error while sending chat message: Chat message id was null for conversation with id {}.", (Object)nodeName);
            return;
        }
        try {
            this._xmppService.publishToNode(nodeName, chatMessageId);
        }
        catch (Exception e) {
            LOG.error("Error while trying to send message.", (Throwable)e);
        }
    }

    private void createNode(String nodeName) throws ServiceException {
        try {
            this._xmppSystemUserConnection.createNode(nodeName);
        }
        catch (SmackInitializationException | InterruptedException | SmackException | XMPPException.XMPPErrorException | XmppStringprepException e) {
            throw new ServiceException(e.getMessage(), e);
        }
    }

    private void deleteNode(String nodeName) throws ServiceException {
        try {
            this._xmppSystemUserConnection.deleteNode(nodeName);
        }
        catch (SmackInitializationException | InterruptedException | SmackException | XMPPException.XMPPErrorException | XmppStringprepException e) {
            throw new ServiceException(e.getMessage(), e);
        }
    }

    private void subscribe(String nodeName, ImmutableList<PersonId> subscribers, boolean createNodeIfNotExist) throws ServiceException {
        try {
            this._xmppSystemUserConnection.subscribe(nodeName, this.toJIDs(subscribers));
        }
        catch (XMPPException.XMPPErrorException e) {
            if (!createNodeIfNotExist || !e.getStanzaError().getCondition().name().equals("item_not_found")) {
                throw new ServiceException(e.getMessage(), e);
            }
            this.createNode(nodeName);
            this.subscribe(nodeName, subscribers, false);
        }
        catch (SmackInitializationException | InterruptedException | SmackException | XmppStringprepException e) {
            throw new ServiceException(e.getMessage(), e);
        }
    }

    private void unsubscribe(String nodeName, ImmutableList<PersonId> subscribers) throws ServiceException {
        try {
            this._xmppSystemUserConnection.unsubscribe(nodeName, this.toJIDs(subscribers));
        }
        catch (XMPPException.XMPPErrorException e) {
            if (!e.getStanzaError().getCondition().name().equals("item_not_found")) {
                throw new ServiceException(e.getMessage(), e);
            }
            LOG.warn("PubSub Node {} does not exists. Skip unsubscribing {}", (Object)nodeName, subscribers);
        }
        catch (SmackInitializationException | InterruptedException | SmackException | XmppStringprepException e) {
            throw new ServiceException(e.getMessage(), e);
        }
    }

    @Nonnull
    private ImmutableSet<JID> toJIDs(ImmutableList<PersonId> personIds) {
        return (ImmutableSet)personIds.stream().map(id -> new JID(String.valueOf(id.getId()), this._domain)).collect(ImmutableSet.toImmutableSet());
    }

    public void superopertyChange(SuperopertyChangeEvent paramSuperopertyChangeEvent) {
        if (this._settings.isChatEnabled()) {
            this.resume();
        } else {
            this.pause();
        }
    }
}

