/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.chat.business;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.common.shared.server.TransactionHelper;
import de.justsoftware.onx.container.shared.model.TenantId;
import de.justsoftware.onx.kafka.AbstractKafkaConsumer;
import de.justsoftware.onx.kafka.KafkaConfigurationProvider;
import de.justsoftware.onx.kafka.KafkaConsumerContext;
import de.justsoftware.onx.message.business.MessageService;
import java.io.IOException;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
@Lazy(value=false)
@ParametersAreNonnullByDefault
public class KafkaPersonTenantConsumer
extends AbstractKafkaConsumer<String, String> {
    private static final Logger LOG = LoggerFactory.getLogger(KafkaPersonTenantConsumer.class);
    private final MessageService _messageService;
    private final ObjectMapper _objectMapper;

    @Autowired
    public KafkaPersonTenantConsumer(KafkaConfigurationProvider configProvider, ObjectMapper objectMapper, TransactionHelper transactionHelper, MessageService messageService) {
        this(configProvider.stringConsumer("just.connect.personTenantConsumer", 1, "latest"), objectMapper, transactionHelper, messageService);
    }

    @VisibleForTesting
    KafkaPersonTenantConsumer(@Nullable Consumer<String, String> consumer, ObjectMapper objectMapper, TransactionHelper transactionHelper, MessageService messageService) {
        super(consumer, transactionHelper, "just.persons.tenantIds");
        this._messageService = messageService;
        this._objectMapper = objectMapper;
    }

    @Override
    protected Logger getLog() {
        return LOG;
    }

    @Override
    protected void process(ConsumerRecords<String, String> records, KafkaConsumerContext context) {
        for (ConsumerRecord record : records) {
            try {
                ImmutableSet tenantIds = record.value() == null ? ImmutableSet.of() : (ImmutableSet)this._objectMapper.readValue((String)record.value(), (TypeReference)new TypeReference<ImmutableSet<TenantId>>(){});
                PersonId personId = (PersonId)Preconditions.checkNotNull((Object)PersonId.parse((String)record.key()));
                this._messageService.updateConversationForTenantChange(personId, (ImmutableSet<TenantId>)tenantIds, context);
            }
            catch (NumberFormatException e) {
                LOG.error(String.format("Skipping record. Could not parse record key to PersonId. %s", record), (Throwable)e);
            }
            catch (IOException e) {
                LOG.error("List of tenants: {} for user {} could not be parsed.", record.value(), record.key());
            }
        }
    }
}

