/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.calendar.business.impl;

import biweekly.Biweekly;
import biweekly.ICalVersion;
import biweekly.ICalendar;
import biweekly.component.VEvent;
import biweekly.property.CalendarScale;
import biweekly.property.Status;
import com.freiheit.toro.common.shared.model.DateWithoutTimezone;
import com.freiheit.toro.common.shared.model.PermissionDeniedException;
import com.freiheit.toro.common.shared.model.ServiceException;
import com.freiheit.toro.common.shared.server.util.StringUtil;
import com.freiheit.toro.common.shared.util.UrlUtil;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Joiner;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Ordering;
import de.justsoftware.onx.authorization.business.AuthorizationCheckContextWithLocale;
import de.justsoftware.onx.authorization.business.AuthorizationContext;
import de.justsoftware.onx.authorization.business.AuthorizationContextProvider;
import de.justsoftware.onx.calendar.business.CalendarFeedReadDataService;
import de.justsoftware.onx.calendar.business.CalendarFeedService;
import de.justsoftware.onx.calendar.business.CalendarFeedWriteDataService;
import de.justsoftware.onx.calendar.server.model.DBICalAccessToken;
import de.justsoftware.onx.calendar.shared.model.ICalAccessToken;
import de.justsoftware.onx.common.business.InternalLinkService;
import de.justsoftware.onx.common.business.ServerUrlUtil;
import de.justsoftware.onx.common.business.configfile.ConfigService;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.common.shared.util.Dates;
import de.justsoftware.onx.container.business.EntityDetailsService;
import de.justsoftware.onx.container.business.EntityMemberService;
import de.justsoftware.onx.container.shared.model.EntityDetails;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.EntityMember;
import de.justsoftware.onx.container.shared.model.EntityMemberRole;
import de.justsoftware.onx.container.shared.model.EntityMemberRoles;
import de.justsoftware.onx.container.shared.model.EntityMemberWithEntityType;
import de.justsoftware.onx.container.shared.model.EntityMemberWithPerson;
import de.justsoftware.onx.container.shared.model.EntityType;
import de.justsoftware.onx.container.shared.model.Identifiables;
import de.justsoftware.onx.container.shared.model.util.EntityMemberUtil;
import de.justsoftware.onx.person.business.PersonService;
import de.justsoftware.onx.person.model.DBPerson;
import de.justsoftware.onx.person.shared.model.PersonTeaserModel;
import de.justsoftware.onx.profile.business.ProfileTeaserService;
import de.justsoftware.onx.searchnew.business.SearchService;
import de.justsoftware.onx.searchnew.shared.model.ArticleSearchResultBadgeModel;
import de.justsoftware.onx.searchnew.shared.model.ChapterSearchResultBadgeModel;
import de.justsoftware.onx.searchnew.shared.model.ChatSearchResultBadgeModel;
import de.justsoftware.onx.searchnew.shared.model.ConversationSearchResultBadgeModel;
import de.justsoftware.onx.searchnew.shared.model.DriveDocumentSearchResultBadgeModel;
import de.justsoftware.onx.searchnew.shared.model.EntitySearchResultBadgeModel;
import de.justsoftware.onx.searchnew.shared.model.FederatedSearchResultEntry;
import de.justsoftware.onx.searchnew.shared.model.FilterTypes;
import de.justsoftware.onx.searchnew.shared.model.JucoOnlySearchResultVisitor;
import de.justsoftware.onx.searchnew.shared.model.NewsChannelSearchResultBadgeModel;
import de.justsoftware.onx.searchnew.shared.model.NewsPostSearchResultBadgeModel;
import de.justsoftware.onx.searchnew.shared.model.PersonSearchResultBadgeModel;
import de.justsoftware.onx.searchnew.shared.model.SearchContext;
import de.justsoftware.onx.searchnew.shared.model.SearchParameters;
import de.justsoftware.onx.searchnew.shared.model.SearchProviderId;
import de.justsoftware.onx.searchnew.shared.model.SearchResult;
import de.justsoftware.onx.searchnew.shared.model.SearchResultBadgeModel;
import de.justsoftware.onx.searchnew.shared.model.SearchResultBadgeVisitor;
import de.justsoftware.onx.searchnew.shared.model.SortType;
import de.justsoftware.onx.searchnew.shared.model.StartDateSubFilter;
import de.justsoftware.onx.searchnew.shared.model.StaticSearchFacetParameters;
import de.justsoftware.onx.searchnew.shared.model.SubFilter;
import de.justsoftware.onx.searchnew.shared.model.WikiSearchResultBadgeModel;
import de.justsoftware.onx.searchnew.shared.model.WorkstreamSearchResultBadgeModel;
import de.justsoftware.onx.util.shared.NullPermeableFunction;
import de.justsoftware.toolbox.clock.Clock;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@ParametersAreNonnullByDefault
public class CalendarFeedServiceImpl
implements CalendarFeedService {
    @Autowired
    private SearchService _searchService;
    @Autowired
    private AuthorizationContextProvider _authContextProvider;
    @Autowired
    private ConfigService _configService;
    @Autowired
    private CalendarFeedReadDataService _calendarReadDataService;
    @Autowired
    private CalendarFeedWriteDataService _calendarWriteDataService;
    @Autowired
    private EntityMemberService _entityMemberService;
    @Autowired
    private EntityDetailsService _entityDetailsService;
    @Autowired
    private PersonService _personService;
    @Autowired
    private ProfileTeaserService _profileTeaserService;
    @Autowired
    private Clock _clock;
    @Autowired
    private ServerUrlUtil _serverUrlUtil;
    @Autowired
    private InternalLinkService _internalLinkService;

    @Override
    public ICalAccessToken getICalAccessToken(PersonId personId) {
        String token;
        DBICalAccessToken accessToken = this._calendarReadDataService.getTokenByPersonId(personId);
        if (accessToken != null && (token = accessToken.getToken()) != null) {
            String url = this._serverUrlUtil.getSystemDomainWithPath(UrlUtil.getICalUrl(token));
            return new ICalAccessToken(token, url, accessToken.isActive());
        }
        String newToken = this.createNewToken();
        int result = this._calendarWriteDataService.createICalAccessToken(newToken, personId);
        if (result == 1) {
            String url = this._serverUrlUtil.getSystemDomainWithPath(UrlUtil.getICalUrl(newToken));
            return new ICalAccessToken(newToken, url, false);
        }
        throw new ServiceException("Could not create ICal token for user with id " + personId);
    }

    @Nonnull
    private String createNewToken() {
        return UUID.randomUUID().toString();
    }

    @Override
    public void invalidateICalTokenForUser(PersonId personId) {
        this._calendarWriteDataService.invalidateICalAccessToken(personId);
    }

    @Override
    public String getICS(String token) {
        if (!this._configService.isHeaderCalendarIconEnabled()) {
            throw new PermissionDeniedException();
        }
        DBICalAccessToken accessToken = this._calendarReadDataService.getPersonIdByToken(token);
        if (accessToken == null) {
            throw new PermissionDeniedException("Invalid ical access token: " + token + " - no corresponding access token");
        }
        PersonId personId = accessToken.getPersonId();
        if (personId == null) {
            throw new PermissionDeniedException("Invalid ical access token: " + token + " - no corresponding personId");
        }
        if (!accessToken.isActive()) {
            throw new PermissionDeniedException("Invalid ical access token: " + token + " - ical feed is deactivated");
        }
        List<EntityDetails> events = this.getEventsForUser(personId);
        return this.createICS(personId, events);
    }

    @Nonnull
    private List<EntityDetails> getEventsForUser(PersonId personId) {
        final AuthorizationContext auth = this._authContextProvider.getAuthorizationContextForUser(personId);
        EntityType entityType = this._configService.getHeaderCalendarEntityType();
        DateTime findEntitiesSince = this._clock.now().minusDays(this._configService.getCalendarFeedMaxEventAge());
        StartDateSubFilter startDateSubFilter = new StartDateSubFilter(findEntitiesSince.toDate());
        SearchParameters searchParameters = new SearchParameters(null, FilterTypes.getByEntityType(entityType), SearchContext.MY_CONTENT, null, null, SortType.TIME_ASCENDING, (Set<? extends SubFilter>)ImmutableSet.of((Object)startDateSubFilter), SearchProviderId.JUCO_ID, StaticSearchFacetParameters.DEFAULT_FACETS);
        SearchResult<FederatedSearchResultEntry> result = this._searchService.search(searchParameters, 0, Integer.MAX_VALUE, null, auth);
        NullPermeableFunction<FederatedSearchResultEntry, EntityDetails> searchResultToEntityInfoFunction = new NullPermeableFunction<FederatedSearchResultEntry, EntityDetails>(){

            @Override
            protected EntityDetails applySafe(FederatedSearchResultEntry input) {
                return input.invite(new EntityDetailsSearchResultVisitor(auth));
            }
        };
        return FluentIterable.from(result.getResults()).transform((Function)searchResultToEntityInfoFunction).filter(Predicates.notNull()).toList();
    }

    @Override
    public String createICS(PersonId personId, List<EntityDetails> events) {
        Map<EntityId, EntityMemberWithEntityType> memberships = this._entityMemberService.getMemberByPersonIdAndEntityIds(personId, (Set<EntityId>)Identifiables.toIdSet(events));
        DBPerson person = this._personService.getPersonByIdNotNull(personId);
        if (!person.isActive() || person.isDeleted()) {
            throw new PermissionDeniedException("The user's profile is " + (person.isDeleted() ? "deleted" : "deactivated"));
        }
        ICalendar ical = new ICalendar();
        ical.setCalendarScale(CalendarScale.gregorian());
        ical.setMethod("PUBLISH");
        ical.setVersion(ICalVersion.V2_0);
        for (EntityDetails entity : events) {
            String eventUrl = this._internalLinkService.getEntityUrl(entity.getId(), InternalLinkService.LinkType.URL);
            VEvent event = new VEvent();
            StringBuilder uid = new StringBuilder();
            uid.append(entity.getId().getId());
            uid.append('@');
            uid.append(this._serverUrlUtil.getSystemDomain());
            event.setUid(uid.toString());
            event.setStatus(Status.confirmed());
            event.setSummary(entity.getName());
            event.setLocation(entity.getLocation());
            event.setDescription(eventUrl + "\n\nAdmins: " + this.escapeText(this.adminList(entity, this._authContextProvider.getAuthorizationContextForUser(personId))) + "\n\n" + StringUtil.stripHTML(entity.getDescription()) + "\n\n" + entity.getLocation());
            event.setUrl(eventUrl);
            if (Dates.isWholeDay(entity.getStartAt(), entity.getEndAt())) {
                event.setDateStart((Date)entity.getStartAt(), false);
                DateWithoutTimezone endDate = entity.getEndAt();
                if (endDate != null) {
                    event.setDateEnd(new DateTime(endDate.getTime()).plusDays(1).toDate(), false);
                } else {
                    event.setDateEnd(null, false);
                }
            } else {
                event.setDateStart((Date)entity.getStartAt(), true);
                event.setDateEnd((Date)entity.getEndAt(), true);
            }
            EntityMemberWithEntityType membership = memberships.get(entity.getId());
            ImmutableSet<EntityMemberRole> roles = membership != null ? membership.getRoles() : ImmutableSet.of();
            event.setTransparency(Boolean.valueOf(!EntityMemberRoles.isAttendingEvent(roles)));
            ical.addEvent(event);
        }
        return Biweekly.write((ICalendar[])new ICalendar[]{ical}).go();
    }

    @Nonnull
    private String adminList(EntityDetails entity, AuthorizationCheckContextWithLocale authCtx) {
        ImmutableList<EntityMemberWithPerson> members = this._entityMemberService.getEntityMembersByEntityId(entity.getId());
        Iterable<EntityMemberWithPerson> filtered = EntityMemberUtil.filterByRoles(members, EntityMemberRoles.ADMIN_OR_COADMIN);
        ImmutableList sorted = Ordering.from((Comparator)EntityMemberRoles.Comperators.ADMINS_FIRST).onResultOf(EntityMember.GET_ROLES).immutableSortedCopy(filtered);
        ImmutableSet<PersonId> personIds = EntityMemberUtil.transformToPersonIdSet(sorted);
        ImmutableMap<PersonId, PersonTeaserModel> simplePersonsMapByIds = this._profileTeaserService.getPersonTeasersByIds((Set<PersonId>)personIds, authCtx);
        Iterable sortedTeasers = Iterables.transform(personIds, (Function)Functions.forMap(simplePersonsMapByIds, null));
        Iterable fullNames = Iterables.transform((Iterable)sortedTeasers, PersonTeaserModel.TO_FULL_NAME);
        return Joiner.on((String)", ").join(fullNames);
    }

    @Nonnull
    private String escapeText(String s) {
        if (s == null) {
            return "";
        }
        StringBuffer res = new StringBuffer();
        block6: for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '\\': {
                    res.append("\\\\");
                    continue block6;
                }
                case ';': {
                    res.append("\\;");
                    continue block6;
                }
                case ',': {
                    res.append("\\,");
                    continue block6;
                }
                case '\n': {
                    res.append("\\n");
                    continue block6;
                }
                default: {
                    res.append(c);
                }
            }
        }
        return res.toString();
    }

    @Override
    public void updateTokenStatus(PersonId personId, boolean active) {
        this._calendarWriteDataService.updateTokenStatus(personId, active);
    }

    private final class EntityDetailsSearchResultVisitor
    extends JucoOnlySearchResultVisitor<EntityDetails> {
        private final AuthorizationContext _authCtx;

        public EntityDetailsSearchResultVisitor(AuthorizationContext authCtx) {
            this._authCtx = authCtx;
        }

        @Override
        public EntityDetails visitSearchResultBadgeModel(SearchResultBadgeModel<?, ?> badge) {
            return badge.visit(new SearchResultBadgeVisitor<EntityDetails>(){

                @Override
                public EntityDetails visitPerson(PersonSearchResultBadgeModel person) {
                    return null;
                }

                @Override
                public EntityDetails visitEntity(EntitySearchResultBadgeModel entity) {
                    return CalendarFeedServiceImpl.this._entityDetailsService.getDetailsById((EntityId)entity.getId(), EntityDetailsSearchResultVisitor.this._authCtx);
                }

                @Override
                public EntityDetails visitWorkstream(WorkstreamSearchResultBadgeModel workstream) {
                    return null;
                }

                @Override
                public EntityDetails visitNewsPost(NewsPostSearchResultBadgeModel model) {
                    return null;
                }

                @Override
                public EntityDetails visitConversation(ConversationSearchResultBadgeModel conversation) {
                    return null;
                }

                @Override
                public EntityDetails visitChat(ChatSearchResultBadgeModel chat) {
                    return null;
                }

                @Override
                public EntityDetails visitDriveDocument(DriveDocumentSearchResultBadgeModel driveDocument) {
                    return null;
                }

                @Override
                public EntityDetails visitWiki(WikiSearchResultBadgeModel wiki) {
                    return null;
                }

                @Override
                public EntityDetails visitChapter(ChapterSearchResultBadgeModel chapter) {
                    return null;
                }

                @Override
                public EntityDetails visitArticle(ArticleSearchResultBadgeModel article) {
                    return null;
                }

                @Override
                public EntityDetails visitNewsChannel(NewsChannelSearchResultBadgeModel model) {
                    return null;
                }
            });
        }
    }
}

