/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.authorization.business.impl;

import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.SetMultimap;
import de.justsoftware.onx.album.shared.server.model.AlbumImageItem;
import de.justsoftware.onx.album.shared.server.model.AlbumItem;
import de.justsoftware.onx.authorization.business.ProfileRole;
import de.justsoftware.onx.authorization.business.Roles;
import de.justsoftware.onx.authorization.business.StaticPermissionRole;
import de.justsoftware.onx.authorization.business.StaticPredefinedRole;
import de.justsoftware.onx.authorization.business.StaticRole;
import de.justsoftware.onx.authorization.business.impl.CalculationContext;
import de.justsoftware.onx.chat.model.ChatItem;
import de.justsoftware.onx.chat.model.ChatMessage;
import de.justsoftware.onx.comments.shared.server.model.CommentItem;
import de.justsoftware.onx.common.business.InvalidIDException;
import de.justsoftware.onx.common.business.configfile.boolexpr.BoolExpr;
import de.justsoftware.onx.common.shared.model.Authority;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.common.shared.model.Role;
import de.justsoftware.onx.container.business.EntityMemberService;
import de.justsoftware.onx.container.business.EntityVersionService;
import de.justsoftware.onx.container.business.ItemService;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.EntityMemberRole;
import de.justsoftware.onx.container.shared.model.EntityMemberRoles;
import de.justsoftware.onx.container.shared.model.InheritsRole;
import de.justsoftware.onx.container.shared.model.ItemId;
import de.justsoftware.onx.container.shared.model.TenantId;
import de.justsoftware.onx.container.shared.model.TenantItem;
import de.justsoftware.onx.container.shared.model.db.DBEntity;
import de.justsoftware.onx.container.shared.server.model.EntityItem;
import de.justsoftware.onx.container.shared.server.model.EntityVersionItem;
import de.justsoftware.onx.container.shared.server.model.Item;
import de.justsoftware.onx.container.shared.server.model.ItemVisitor;
import de.justsoftware.onx.container.shared.server.model.NewsChannelItem;
import de.justsoftware.onx.container.shared.server.model.NewsPostItem;
import de.justsoftware.onx.container.shared.server.model.PseudoEntityItem;
import de.justsoftware.onx.document.shared.server.model.DocumentItem;
import de.justsoftware.onx.document.shared.server.model.DocumentVersionItem;
import de.justsoftware.onx.drive.business.model.DriveDocumentItem;
import de.justsoftware.onx.drive.business.model.DriveShareItem;
import de.justsoftware.onx.drive.business.model.DriveTempItem;
import de.justsoftware.onx.drive.shared.model.DriveShareId;
import de.justsoftware.onx.like.business.LikeReadDataService;
import de.justsoftware.onx.link.shared.server.model.LinkItem;
import de.justsoftware.onx.message.model.Conversation;
import de.justsoftware.onx.multiwiki.shared.server.model.MultiWiki;
import de.justsoftware.onx.multiwiki.shared.server.model.MultiWikiVersion;
import de.justsoftware.onx.multiwiki.shared.server.model.MultiWikiVersionSection;
import de.justsoftware.onx.person.business.FriendsService;
import de.justsoftware.onx.person.model.DBPerson;
import de.justsoftware.onx.person.shared.server.model.ProfileItem;
import de.justsoftware.onx.person.shared.server.model.StartpageItem;
import de.justsoftware.onx.raweditor.shared.server.model.RawEditorItem;
import de.justsoftware.onx.survey.business.SurveyService;
import de.justsoftware.onx.survey.shared.model.DBSurvey;
import de.justsoftware.onx.survey.shared.server.model.SurveyItem;
import de.justsoftware.onx.tasks.authorization.TaskRight;
import de.justsoftware.onx.tasks.authorization.TaskRole;
import de.justsoftware.onx.tasks.authorization.model.TaskItem;
import de.justsoftware.onx.tasks.authorization.model.TaskListItem;
import de.justsoftware.onx.tasks.integration.persistence.TaskDAO;
import de.justsoftware.onx.tasks.shared.model.TaskId;
import de.justsoftware.onx.tasks.shared.model.TaskListId;
import de.justsoftware.onx.tenant.business.PersonTenantService;
import de.justsoftware.onx.usergroup.business.impl.UserGroupService;
import de.justsoftware.onx.videolink.shared.server.model.VideolinkItem;
import de.justsoftware.onx.wiki.model.ArticleItem;
import de.justsoftware.onx.wiki.model.ChapterItem;
import de.justsoftware.onx.wiki.model.WikiItem;
import de.justsoftware.onx.wikieditor.shared.server.model.WikiBackupItem;
import de.justsoftware.onx.wikieditor.shared.server.model.WikiEditorItem;
import de.justsoftware.onx.wikieditor.shared.server.model.WikiVersionItem;
import de.justsoftware.onx.workstream.shared.server.model.FeedItem;
import de.justsoftware.onx.workstream.shared.server.model.WorkstreamItem;
import de.justsoftware.permission.client.model.Role;
import de.justsoftware.permission.client.rest.PermissionRequestConnector;
import de.justsoftware.polls.model.pollid.item.PollItem;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="authorizationRolesService")
public class RolesService {
    private static final Logger LOG = LoggerFactory.getLogger(RolesService.class);
    @Autowired
    private EntityMemberService _entityMemberService;
    @Autowired
    private EntityVersionService _entityVersionService;
    @Autowired
    private LikeReadDataService _likeReadDataService;
    @Autowired
    private FriendsService _friendsService;
    @Autowired
    private SurveyService _surveyService;
    @Autowired
    private TaskDAO _taskDAO;
    @Autowired
    private PermissionRequestConnector _permissionRequestConnector;
    @Autowired
    private ItemService _itemService;
    @Autowired
    private PersonTenantService _personTenantService;
    @Autowired
    private UserGroupService _userGroupService;

    @Nonnull
    public BoolExpr boolExpr(final @Nonnull CalculationContext context, final @Nullable Item<?> item, final @Nullable DBPerson person, @Nonnull StaticRole role) {
        return role.accept(new Role.DefaultRoleVisitor<BoolExpr>(){

            @Override
            public BoolExpr visitAll(StaticRole staticRole) {
                return BoolExpr.TRUE;
            }

            @Override
            public BoolExpr visitLoggedIn(StaticRole staticRole) {
                if (item != null) {
                    return item.accept(new HasRoleVisitor(context, person, staticRole));
                }
                return person != null ? BoolExpr.TRUE : BoolExpr.FALSE;
            }

            @Override
            public BoolExpr visitDefault(StaticRole staticRole) {
                if (item == null) {
                    return BoolExpr.FALSE;
                }
                HasRoleVisitor proxy = new HasRoleVisitor(context, person, staticRole);
                return item.accept(proxy);
            }
        });
    }

    @ParametersAreNonnullByDefault
    private final class HasRoleVisitor
    implements BooleanItemVisitor {
        private final DBPerson _person;
        private final StaticRole _staticRole;
        private final CalculationContext _calculationContext;

        private HasRoleVisitor(@Nullable CalculationContext calculationContext, DBPerson person, StaticRole staticRole) {
            this._calculationContext = calculationContext;
            this._person = person;
            this._staticRole = staticRole;
        }

        @Nonnull
        private BoolExpr resolvePermission(Authority role, Role permissionAction) {
            if (!this.isLoggedIn()) {
                return BoolExpr.FALSE;
            }
            return this._calculationContext.filter(role, Maps.immutableEntry((Object)Role.profileRole((long)this._person.getId().getId()), (Object)permissionAction), keys -> RolesService.this._permissionRequestConnector.filterRoles((SetMultimap)ImmutableSetMultimap.copyOf((Iterable)keys)).entries(), BoolExpr::valueOf);
        }

        private boolean isLoggedIn() {
            return this._person != null && !this._person.isDeleted();
        }

        @Override
        public BoolExpr visit(AlbumItem item) {
            return this.isCoAdminForItemPersonId(item.getAlbum().getOwnerId(), item, StaticPredefinedRole.ALBUM_OWNER);
        }

        @Override
        public BoolExpr visit(AlbumImageItem item) {
            return this.isCoAdminForItemPersonId(item.getAlbumImage().getOwnerId(), item, StaticPredefinedRole.ALBUM_IMAGE_OWNER);
        }

        @Override
        public BoolExpr visit(CommentItem item) {
            return this.isCoAdminForItemPersonId(item.getAuthorId(), item, StaticPredefinedRole.COMMENT_AUTHOR);
        }

        @Nonnull
        private BoolExpr resolveLoggedInForEntity(@Nonnull StaticRole staticRole, @Nonnull DBEntity entity) {
            return this.resolvePermission(staticRole, Role.tenantRead((UUID)entity.getTenantId().getId()));
        }

        @Override
        public BoolExpr visit(EntityItem item) {
            return this._staticRole.accept(new EntityRoleVisitor(item));
        }

        @Override
        public BoolExpr visit(DocumentItem item) {
            return BoolExpr.FALSE;
        }

        @Override
        public BoolExpr visit(DriveShareItem driveShareItem) {
            if (!this.isLoggedIn()) {
                return BoolExpr.FALSE;
            }
            final DriveShareId shareId = driveShareItem.getId();
            return this._staticRole.accept(new BaseRoleVisitor(BoolExpr.FALSE, driveShareItem){

                @Override
                public BoolExpr visitShareReader(StaticRole role) {
                    return HasRoleVisitor.this.resolvePermission(role, Role.itemRole((String)"READ", (String)shareId.asString()));
                }
            });
        }

        @Override
        public BoolExpr visit(DriveTempItem driveTempItem) {
            return this._staticRole.accept(new BaseRoleVisitor(BoolExpr.FALSE, driveTempItem));
        }

        @Override
        public BoolExpr visit(DriveDocumentItem item) {
            return this._staticRole.accept(new BaseRoleVisitor(BoolExpr.FALSE, item){

                @Override
                public BoolExpr visitCoAdmin(StaticRole staticRole) {
                    return this.logUnhandled(staticRole);
                }

                @Override
                public BoolExpr visitDocumentOwnerOfAllVersions(StaticRole staticRole) {
                    return this.logUnhandled(staticRole);
                }

                @Nonnull
                private BoolExpr logUnhandled(@Nonnull StaticRole role) {
                    LOG.warn(role + " is not handled for drive documents, remove it from authorization.cfg!");
                    return BoolExpr.FALSE;
                }
            });
        }

        @Override
        public BoolExpr visit(final TaskItem taskItem) {
            if (!this.isLoggedIn()) {
                return BoolExpr.FALSE;
            }
            final TaskId itemId = taskItem.getId();
            return this._staticRole.accept(new BaseRoleVisitor(BoolExpr.FALSE, taskItem){

                @Override
                public BoolExpr visitTaskAssignee(TaskRole role) {
                    return BoolExpr.valueOf(Objects.equal((Object)taskItem.getAssigneeId(), (Object)HasRoleVisitor.this._person.getId()));
                }

                @Override
                public BoolExpr visitTaskOwner(TaskRole role) {
                    return BoolExpr.valueOf(Objects.equal((Object)taskItem.getOwnerId(), (Object)HasRoleVisitor.this._person.getId()));
                }

                @Override
                public BoolExpr visitTaskAssigneeOfSubtask(TaskRole role) {
                    return HasRoleVisitor.this._calculationContext.filter(role, Maps.immutableEntry((Object)itemId, (Object)HasRoleVisitor.this._person.getId()), input -> RolesService.this._taskDAO.filterSubtaskAssignees((SetMultimap<TaskId, PersonId>)ImmutableSetMultimap.copyOf((Iterable)input)).entries(), BoolExpr::valueOf);
                }

                @Override
                public BoolExpr visitTaskOwnerOfSubtask(TaskRole role) {
                    return HasRoleVisitor.this._calculationContext.filter(role, Maps.immutableEntry((Object)itemId, (Object)HasRoleVisitor.this._person.getId()), input -> RolesService.this._taskDAO.filterSubtaskOwners((SetMultimap<TaskId, PersonId>)ImmutableSetMultimap.copyOf((Iterable)input)).entries(), BoolExpr::valueOf);
                }
            });
        }

        @Override
        public BoolExpr visit(TaskListItem taskListItem) {
            if (!this.isLoggedIn()) {
                return BoolExpr.FALSE;
            }
            final TaskListId itemId = taskListItem.getId();
            return this._staticRole.accept(new BaseRoleVisitor(BoolExpr.FALSE, taskListItem){

                @Override
                public BoolExpr visitTaskListReader(TaskRole role) {
                    return this.visit(role, (ImmutableSet<TaskRight>)ImmutableSet.of((Object)((Object)TaskRight.READ), (Object)((Object)TaskRight.WRITE), (Object)((Object)TaskRight.MANAGE)));
                }

                @Override
                public BoolExpr visitTaskListEditor(TaskRole role) {
                    return this.visit(role, (ImmutableSet<TaskRight>)ImmutableSet.of((Object)((Object)TaskRight.WRITE), (Object)((Object)TaskRight.MANAGE)));
                }

                @Override
                public BoolExpr visitTaskListManager(TaskRole role) {
                    return this.visit(role, (ImmutableSet<TaskRight>)ImmutableSet.of((Object)((Object)TaskRight.MANAGE)));
                }

                @Nonnull
                private BoolExpr visit(@Nonnull TaskRole role, @Nonnull ImmutableSet<TaskRight> rights) {
                    return HasRoleVisitor.this._calculationContext.get((Authority)role, Maps.immutableEntry((Object)itemId, (Object)new ProfileRole(HasRoleVisitor.this._person.getId())), this::loadTaskListRights, r -> BoolExpr.valueOf(rights.contains(r.orNull())));
                }

                @Nonnull
                private Map<Map.Entry<TaskListId, ProfileRole>, Optional<TaskRight>> loadTaskListRights(@Nonnull Set<Map.Entry<TaskListId, ProfileRole>> keys) {
                    ImmutableTable<TaskListId, ProfileRole, TaskRight> result = RolesService.this._taskDAO.filterTaskListPermissions((SetMultimap<TaskListId, ProfileRole>)ImmutableSetMultimap.copyOf(keys));
                    return Maps.asMap(keys, k -> Optional.fromNullable((Object)((Object)((TaskRight)((Object)((Object)result.get(k.getKey(), k.getValue())))))));
                }
            });
        }

        @Override
        public BoolExpr visit(DocumentVersionItem item) {
            return this.isCoAdminForItemPersonId(item.getVersion().getUploadedById(), item, StaticPredefinedRole.DOCUMENT_VERSION_AUTHOR);
        }

        @Override
        public BoolExpr visit(ProfileItem profileItem) {
            return this._staticRole.accept(new DefaultProfileRoleVisitor(profileItem));
        }

        @Override
        public BoolExpr visit(StartpageItem startPageItem) {
            final PersonId personId = startPageItem.getPerson().getId();
            return this._staticRole.accept(new BaseRoleVisitor(BoolExpr.FALSE, startPageItem){

                @Override
                public BoolExpr visitAdmin(StaticRole staticRole) {
                    return this.visitProfileOwner(StaticPredefinedRole.PROFILE_OWNER);
                }

                @Override
                public BoolExpr visitProfileOwner(StaticRole staticRole) {
                    return BoolExpr.valueOf(HasRoleVisitor.this.isLoggedIn() && personId.equals(HasRoleVisitor.this._person.getId()));
                }

                @Override
                public BoolExpr visitPersonFriend(StaticRole staticRole) {
                    return BoolExpr.valueOf(HasRoleVisitor.this.isLoggedIn() && RolesService.this._friendsService.isFriendOf(HasRoleVisitor.this._person.getId(), personId));
                }
            });
        }

        @Override
        public BoolExpr visit(FeedItem item) {
            return BoolExpr.valueOf(this.isLoggedIn());
        }

        @Override
        public BoolExpr visit(RawEditorItem item) {
            return BoolExpr.FALSE;
        }

        @Override
        public BoolExpr visit(SurveyItem item) {
            final DBSurvey survey = item.getSurvey();
            return this._staticRole.accept(new BaseRoleVisitor(BoolExpr.FALSE, item){

                @Override
                public BoolExpr visitCoAdmin(StaticRole staticRole) {
                    return this.visitSurveyOwner(StaticPredefinedRole.SURVEY_OWNER);
                }

                @Override
                public BoolExpr visitSurveyOwner(StaticRole staticRole) {
                    return BoolExpr.valueOf(HasRoleVisitor.this.isLoggedIn() && survey.getOwnerId().equals(HasRoleVisitor.this._person.getId()));
                }

                @Override
                public BoolExpr visitSurveyParticipant(StaticRole staticRole) {
                    return BoolExpr.valueOf(HasRoleVisitor.this.isLoggedIn() && (survey.getOwnerId().equals(HasRoleVisitor.this._person.getId()) || RolesService.this._surveyService.hasParticipateSurvey(HasRoleVisitor.this._person.getId(), survey.getId())));
                }
            });
        }

        @Override
        public BoolExpr visit(VideolinkItem item) {
            return this.isCoAdminForItemPersonId(item.getLink().getAuthorId(), item, StaticPredefinedRole.VIDEOLINK_AUTHOR);
        }

        @Override
        public BoolExpr visit(WikiBackupItem item) {
            return this.isCoAdminForItemPersonId(item.getBackup().getAuthorId(), item, StaticPredefinedRole.WIKI_BACKUP_AUTHOR);
        }

        @Override
        public BoolExpr visit(WikiEditorItem item) {
            return BoolExpr.FALSE;
        }

        @Override
        public BoolExpr visit(WikiVersionItem item) {
            return this.isCoAdminForItemPersonId(item.getVersion().getAuthorId(), item, StaticPredefinedRole.WIKI_VERSION_AUTHOR);
        }

        @Override
        public BoolExpr visit(WorkstreamItem item) {
            return this.isCoAdminForItemPersonId(item.getMessage().getAuthorId().asPersonId(), item, StaticPredefinedRole.WORKSTREAM_MESSAGE_AUTHOR);
        }

        @Nonnull
        private BoolExpr isCoAdminForItemPersonId(final PersonId relevantPersonId, Item item, final StaticRole ownerRole) {
            return this._staticRole.accept(new BaseRoleVisitor(BoolExpr.FALSE, item){

                @Nonnull
                private BoolExpr isOwner() {
                    return BoolExpr.valueOf(HasRoleVisitor.this.isLoggedIn() && relevantPersonId != null && relevantPersonId.equals(HasRoleVisitor.this._person.getId()));
                }

                @Override
                public BoolExpr visitCoAdmin(StaticRole staticRole) {
                    return this.isOwner();
                }

                @Override
                public BoolExpr visitDefault(StaticRole staticRole) {
                    if (staticRole == ownerRole) {
                        return this.isOwner();
                    }
                    return super.visitDefault(staticRole);
                }
            });
        }

        @Override
        public BoolExpr visit(MultiWiki multiWiki) {
            return BoolExpr.FALSE;
        }

        @Override
        public BoolExpr visit(MultiWikiVersion multiWikiVersion) {
            return BoolExpr.FALSE;
        }

        @Override
        public BoolExpr visit(MultiWikiVersionSection multiWikiSegment) {
            return BoolExpr.FALSE;
        }

        @Override
        public BoolExpr visit(EntityVersionItem entityVersionItem) {
            return BoolExpr.FALSE;
        }

        @Override
        public BoolExpr visit(LinkItem link) {
            return BoolExpr.FALSE;
        }

        @Override
        public BoolExpr visit(final Conversation conversation) {
            return this._staticRole.accept(new BaseRoleVisitor(BoolExpr.FALSE, conversation){

                @Override
                public BoolExpr visitConversationParticipant(StaticRole staticRole) {
                    if (HasRoleVisitor.this.isConversationParticipant(conversation)) {
                        return HasRoleVisitor.this.resolvePermission(staticRole, Role.tenantRead((UUID)conversation.getTenantId().getId()));
                    }
                    return BoolExpr.FALSE;
                }
            });
        }

        private boolean isConversationParticipant(Conversation conversation) {
            if (!this.isLoggedIn()) {
                return false;
            }
            if (conversation.getParticipants().contains((Object)this._person.getId())) {
                return true;
            }
            return RolesService.this._userGroupService.getUserGroupMembersByIds(conversation.getUserGroups()).values().contains((Object)this._person.getId());
        }

        @Override
        public BoolExpr visit(final ChatMessage message) {
            return this._staticRole.accept(new BaseRoleVisitor(BoolExpr.FALSE, message){

                @Override
                public BoolExpr visitChatMessageAuthor(StaticRole staticRole) {
                    return BoolExpr.valueOf(HasRoleVisitor.this.isLoggedIn() && message.getSentFrom().asPersonId().equals(HasRoleVisitor.this._person.getId()));
                }
            });
        }

        @Override
        public BoolExpr visit(ChatItem chatItem) {
            return BoolExpr.FALSE;
        }

        @Override
        public BoolExpr visit(WikiItem wiki) {
            return BoolExpr.FALSE;
        }

        @Override
        public BoolExpr visit(ChapterItem chapter) {
            return BoolExpr.FALSE;
        }

        @Override
        public BoolExpr visit(ArticleItem article) {
            return BoolExpr.FALSE;
        }

        @Override
        public BoolExpr visit(PollItem pollItem) {
            return BoolExpr.FALSE;
        }

        @Override
        public BoolExpr visit(NewsPostItem newsPostItem) {
            return BoolExpr.FALSE;
        }

        @Override
        public BoolExpr visit(NewsChannelItem newsChannelItem) {
            return BoolExpr.FALSE;
        }

        @Override
        public BoolExpr visit(PseudoEntityItem entityItem) {
            return this._staticRole.accept(new PseudoEntityRoleVisitor(entityItem));
        }

        @Override
        public BoolExpr visit(TenantItem tenantItem) {
            if (!this.isLoggedIn()) {
                return BoolExpr.FALSE;
            }
            final TenantId tenantId = (TenantId)tenantItem.getId();
            return this._staticRole.accept(new BaseRoleVisitor(BoolExpr.FALSE, tenantItem){

                @Override
                public BoolExpr visitPermissionRole(StaticPermissionRole role) {
                    return HasRoleVisitor.this.resolvePermission(role, Role.itemRole((String)role.getName(), (String)tenantId.asString()));
                }
            });
        }

        @ParametersAreNonnullByDefault
        private class PseudoEntityRoleVisitor
        extends BaseRoleVisitor {
            public PseudoEntityRoleVisitor(PseudoEntityItem entityItem) {
                super(BoolExpr.FALSE, entityItem);
            }

            @Override
            public BoolExpr visitAdmin(StaticRole staticRole) {
                return BoolExpr.valueOf(HasRoleVisitor.this.isLoggedIn());
            }

            @Override
            public BoolExpr visitCoAdmin(StaticRole staticRole) {
                return BoolExpr.valueOf(HasRoleVisitor.this.isLoggedIn());
            }

            @Override
            public BoolExpr visitEntityAdmin(StaticRole staticRole) {
                return BoolExpr.valueOf(HasRoleVisitor.this.isLoggedIn());
            }

            @Override
            public BoolExpr visitEntityCoAdmin(StaticRole staticRole) {
                return BoolExpr.valueOf(HasRoleVisitor.this.isLoggedIn());
            }
        }

        private final class DefaultProfileRoleVisitor
        extends BaseRoleVisitor {
            private final PersonId _profileId;

            private DefaultProfileRoleVisitor(ProfileItem profileItem) {
                super(BoolExpr.FALSE, profileItem);
                this._profileId = profileItem.getId().asPersonId();
            }

            @Override
            public BoolExpr visitAdmin(StaticRole staticRole) {
                return this.visitProfileOwner(StaticPredefinedRole.PROFILE_OWNER);
            }

            @Override
            public BoolExpr visitProfileOwner(StaticRole staticRole) {
                return BoolExpr.valueOf(HasRoleVisitor.this.isLoggedIn() && this.isOwner());
            }

            @Override
            public BoolExpr visitPersonFriend(StaticRole staticRole) {
                return BoolExpr.valueOf(HasRoleVisitor.this.isLoggedIn() && (this.isOwner() || RolesService.this._friendsService.isFriendOf(HasRoleVisitor.this._person.getId(), this._profileId)));
            }

            @Override
            public BoolExpr visitPersonHasInvited(StaticRole staticRole) {
                return BoolExpr.valueOf(HasRoleVisitor.this.isLoggedIn() && RolesService.this._friendsService.hasInvited(HasRoleVisitor.this._person.getId(), this._profileId));
            }

            @Override
            public BoolExpr visitPersonHasInvitation(StaticRole staticRole) {
                return BoolExpr.valueOf(HasRoleVisitor.this.isLoggedIn() && RolesService.this._friendsService.hasInvited(this._profileId, HasRoleVisitor.this._person.getId()));
            }

            @Override
            public BoolExpr visitPersonMemberOfSameEntity(StaticRole staticRole) {
                return BoolExpr.valueOf(HasRoleVisitor.this.isLoggedIn() && RolesService.this._entityMemberService.isMemberOfSameEntity(HasRoleVisitor.this._person.getId(), this._profileId));
            }

            @Override
            public BoolExpr visitLoggedIn(StaticRole staticRole) {
                return BoolExpr.valueOf(HasRoleVisitor.this.isLoggedIn());
            }

            public boolean isOwner() {
                return HasRoleVisitor.this._person != null && this._profileId != null && this._profileId.equals(HasRoleVisitor.this._person.getId());
            }

            @Override
            public BoolExpr visitPermissionRole(StaticPermissionRole role) {
                switch (role) {
                    case READ: {
                        return HasRoleVisitor.this.resolvePermission(role, Role.read((String)this._profileId.asProfileId().asString()));
                    }
                    case MANAGE: {
                        ImmutableSet<TenantId> tenantIds = RolesService.this._personTenantService.getTenantIdsForPerson(this._profileId);
                        if (tenantIds.size() != 1) break;
                        TenantId tenantId = (TenantId)Iterables.getOnlyElement(tenantIds);
                        return HasRoleVisitor.this.resolvePermission(role, Role.manage((String)tenantId.asString()));
                    }
                }
                return BoolExpr.FALSE;
            }
        }

        @ParametersAreNonnullByDefault
        private final class EntityRoleVisitor
        extends BaseRoleVisitor {
            private final DBEntity _entity;

            EntityRoleVisitor(EntityItem entity) {
                super(BoolExpr.FALSE, entity);
                this._entity = entity.getEntity();
            }

            @Override
            public BoolExpr visitLoggedIn(StaticRole staticRole) {
                return HasRoleVisitor.this.resolveLoggedInForEntity(staticRole, this._entity);
            }

            @Nonnull
            private BoolExpr hasMemberRole(StaticRole staticRole) {
                return this.hasAnyMemberRoleOf(staticRole, (Set<EntityMemberRole>)Roles.STATIC_ROLE_MAPPING.get((Object)staticRole));
            }

            @Nonnull
            private BoolExpr hasAnyMemberRoleOf(StaticRole staticRole, Set<EntityMemberRole> roles) {
                if (roles.isEmpty()) {
                    return BoolExpr.FALSE;
                }
                return this.hasMemberRoleByFilter(staticRole, EntityMemberRoles.hasAnyRolePredicate(roles));
            }

            @Nonnull
            private ImmutableSetMultimap<Map.Entry<EntityId, PersonId>, EntityMemberRole> loadMembersByKeys(Set<Map.Entry<EntityId, PersonId>> keys) {
                ImmutableSetMultimap entitiesAndPersons = ImmutableSetMultimap.copyOf(keys);
                ImmutableSet personIds = entitiesAndPersons.inverse().keySet();
                ImmutableSet entityIds = entitiesAndPersons.keySet();
                Object members = personIds.size() < entityIds.size() ? RolesService.this._entityMemberService.getEntityMembersByPersonIds((Set<PersonId>)personIds) : RolesService.this._entityMemberService.getEntityMembersByEntityIds((Set<EntityId>)entityIds);
                ImmutableSetMultimap.Builder result = ImmutableSetMultimap.builder();
                members.values().forEach(member -> {
                    Map.Entry key = Maps.immutableEntry((Object)member.getEntityId(), (Object)member.getPersonId());
                    if (keys.contains(key)) {
                        result.putAll((Object)key, member.getRoles());
                    }
                });
                return result.build();
            }

            @Nonnull
            private BoolExpr hasMemberRoleByFilter(StaticRole staticRole, Predicate<Collection<? extends EntityMemberRole>> roleFilter) {
                if (!HasRoleVisitor.this.isLoggedIn()) {
                    return BoolExpr.FALSE;
                }
                Function load = keys -> Maps.asMap((Set)keys, arg_0 -> this.loadMembersByKeys((Set<Map.Entry<EntityId, PersonId>>)keys).get(arg_0));
                return HasRoleVisitor.this._calculationContext.get((Authority)staticRole, Maps.immutableEntry((Object)this._entity.getId(), (Object)HasRoleVisitor.this._person.getId()), load, member -> BoolExpr.valueOf(roleFilter.apply(member)));
            }

            @Override
            public BoolExpr visitEntityMember(StaticRole staticRole) {
                return this.hasMemberRole(staticRole);
            }

            @Override
            public BoolExpr visitEntityMemberOfParent(StaticRole staticRole) {
                if (!HasRoleVisitor.this.isLoggedIn()) {
                    return BoolExpr.FALSE;
                }
                return HasRoleVisitor.this._calculationContext.get((Authority)staticRole, this._entity.getId(), keys -> Maps.asMap((Set)keys, arg_0 -> RolesService.this._entityMemberService.getInheritedMembers(InheritsRole.INHERIT_MEMBERS, (Set<EntityId>)keys).get(arg_0)), result -> BoolExpr.valueOf(result.contains((Object)HasRoleVisitor.this._person.getId())));
            }

            @Override
            public BoolExpr visitEntityHasRejected(StaticRole staticRole) {
                return this.hasMemberRole(staticRole);
            }

            @Override
            public BoolExpr visitEntityHasSentJoinRequest(StaticRole staticRole) {
                return this.hasMemberRole(staticRole);
            }

            @Override
            public BoolExpr visitEntityUndecided(StaticRole staticRole) {
                return this.hasMemberRole(staticRole);
            }

            @Override
            public BoolExpr visitEntityHasInvitation(StaticRole staticRole) {
                return this.hasMemberRole(staticRole);
            }

            @Override
            public BoolExpr visitCoAdmin(StaticRole staticRole) {
                return this.visitEntityCoAdmin(StaticPredefinedRole.ENTITY_CO_ADMIN);
            }

            @Override
            public BoolExpr visitEntityCoAdmin(StaticRole staticRole) {
                return this.hasMemberRole(staticRole);
            }

            @Override
            public BoolExpr visitEntityAdminOfParent(StaticRole staticRole) {
                if (!HasRoleVisitor.this.isLoggedIn()) {
                    return BoolExpr.FALSE;
                }
                return HasRoleVisitor.this._calculationContext.get((Authority)staticRole, this._entity.getId(), keys -> Maps.asMap((Set)keys, arg_0 -> RolesService.this._entityMemberService.getInheritedMembers(InheritsRole.INHERIT_ADMINS, (Set<EntityId>)keys).get(arg_0)), result -> BoolExpr.valueOf(result.contains((Object)HasRoleVisitor.this._person.getId())));
            }

            @Override
            public BoolExpr visitAdmin(StaticRole staticRole) {
                return this.visitEntityAdmin(StaticPredefinedRole.ENTITY_ADMIN);
            }

            @Override
            public BoolExpr visitEntityAdmin(StaticRole staticRole) {
                return this.hasMemberRole(staticRole);
            }

            @Override
            public BoolExpr visitEntityVersionReviewer(StaticRole staticRole) {
                if (!HasRoleVisitor.this.isLoggedIn()) {
                    return BoolExpr.FALSE;
                }
                return HasRoleVisitor.this._calculationContext.get((Authority)staticRole, this._entity.getId(), keys -> Maps.asMap((Set)keys, arg_0 -> RolesService.this._entityVersionService.getEntityVersionReviewer((Set<EntityId>)keys).get(arg_0)), result -> BoolExpr.valueOf(result.contains((Object)HasRoleVisitor.this._person.getId())));
            }

            @Override
            public BoolExpr visitHasNoEventStatus(StaticRole staticRole) {
                return this.hasMemberRoleByFilter(staticRole, (Predicate<Collection<? extends EntityMemberRole>>)Predicates.not(EntityMemberRoles.hasAnyRolePredicate(EntityMemberRoles.ALL_EVENT_STATUS)));
            }

            @Override
            public BoolExpr visitIsAttendingTheEvent(StaticRole staticRole) {
                return this.hasMemberRole(staticRole);
            }

            @Override
            public BoolExpr visitIsNotAttendingTheEvent(StaticRole staticRole) {
                return this.hasMemberRole(staticRole);
            }

            @Override
            public BoolExpr visitIsMaybeAttendingTheEvent(StaticRole staticRole) {
                return this.hasMemberRole(staticRole);
            }

            @Override
            public BoolExpr visitIsOnWaitinglistForEvent(StaticRole staticRole) {
                return this.hasMemberRole(staticRole);
            }

            @Override
            public BoolExpr visitIsInvitedToEvent(StaticRole staticRole) {
                return this.hasMemberRole(staticRole);
            }

            @Override
            public BoolExpr visitHasRejectedTheEventInvitation(StaticRole staticRole) {
                return this.hasMemberRole(staticRole);
            }

            @Override
            public BoolExpr visitEntityAssignee(StaticRole staticRole) {
                if (HasRoleVisitor.this.isLoggedIn() && HasRoleVisitor.this._person.getId().equals(this._entity.getAssignee())) {
                    return BoolExpr.TRUE;
                }
                return BoolExpr.FALSE;
            }
        }

        private class BaseRoleVisitor
        extends Role.DefaultRoleVisitor<BoolExpr> {
            private final Item _item;
            private final BoolExpr _defaultValue;

            public BaseRoleVisitor(@Nonnull BoolExpr defaultValue, Item item) {
                this._defaultValue = defaultValue;
                this._item = item;
            }

            @Override
            public BoolExpr visitUnsubscriber(StaticRole staticRole) {
                if (!HasRoleVisitor.this.isLoggedIn()) {
                    return BoolExpr.FALSE;
                }
                return HasRoleVisitor.this._calculationContext.filter(staticRole, Maps.immutableEntry((Object)this._item.getId(), (Object)HasRoleVisitor.this._person.getId()), keys -> RolesService.this._likeReadDataService.hasPassiveSubscriptions((SetMultimap<ItemId, PersonId>)ImmutableSetMultimap.copyOf((Iterable)keys)).entries(), r -> BoolExpr.valueOf(!Boolean.TRUE.equals(r)));
            }

            @Override
            public BoolExpr visitDefault(StaticRole staticRole) {
                return this._defaultValue;
            }

            @Override
            public final BoolExpr visitAll(StaticRole staticRole) {
                throw new IllegalStateException("Role \"" + staticRole + "\" already handled in has role!");
            }

            @Override
            public BoolExpr visitLoggedIn(StaticRole staticRole) {
                try {
                    DBEntity parentEntity = RolesService.this._itemService.getParentEntity(this._item);
                    if (parentEntity != null) {
                        return HasRoleVisitor.this.resolveLoggedInForEntity(staticRole, parentEntity);
                    }
                }
                catch (InvalidIDException e) {
                    LOG.error(e.getMessage(), (Throwable)e);
                    return BoolExpr.FALSE;
                }
                return this._defaultValue;
            }
        }
    }

    static interface BooleanItemVisitor
    extends ItemVisitor<BoolExpr> {
    }
}

