/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.authorization.business.impl;

import com.freiheit.toro.common.shared.model.ServiceException;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import com.google.common.collect.Streams;
import de.justsoftware.onx.authorization.business.AuthorityUtil;
import de.justsoftware.onx.authorization.business.AuthorizationKey;
import de.justsoftware.onx.authorization.business.BaseAuthorizationKey;
import de.justsoftware.onx.authorization.business.ItemIdAndAction;
import de.justsoftware.onx.authorization.business.ItemPathHelper;
import de.justsoftware.onx.authorization.business.PersonIndependentAuthorizationContext;
import de.justsoftware.onx.authorization.business.PersonRole;
import de.justsoftware.onx.authorization.business.StaticPredefinedRole;
import de.justsoftware.onx.authorization.business.StaticRole;
import de.justsoftware.onx.authorization.business.TenantRole;
import de.justsoftware.onx.authorization.business.impl.CalculationContext;
import de.justsoftware.onx.authorization.business.impl.ContextCache;
import de.justsoftware.onx.authorization.business.impl.HasAuthorizationCache;
import de.justsoftware.onx.authorization.business.impl.ItemOrItemIdContainer;
import de.justsoftware.onx.authorization.business.impl.LoadOperation;
import de.justsoftware.onx.authorization.business.impl.RightsService;
import de.justsoftware.onx.authorization.business.impl.RolesService;
import de.justsoftware.onx.common.business.InvalidIDException;
import de.justsoftware.onx.common.business.configfile.ConfigFileService;
import de.justsoftware.onx.common.business.configfile.boolexpr.AndExpr;
import de.justsoftware.onx.common.business.configfile.boolexpr.BoolExpr;
import de.justsoftware.onx.common.business.configfile.boolexpr.BoolExprVisitor;
import de.justsoftware.onx.common.business.configfile.boolexpr.ConstExpr;
import de.justsoftware.onx.common.business.configfile.boolexpr.EvalContext;
import de.justsoftware.onx.common.business.configfile.boolexpr.EvalException;
import de.justsoftware.onx.common.business.configfile.boolexpr.NotExpr;
import de.justsoftware.onx.common.business.configfile.boolexpr.OrExpr;
import de.justsoftware.onx.common.business.configfile.boolexpr.VarExpr;
import de.justsoftware.onx.common.business.configfile.parser.ConfFileNode;
import de.justsoftware.onx.common.business.configfile.pathmatcher.Path;
import de.justsoftware.onx.common.shared.model.Authority;
import de.justsoftware.onx.common.shared.model.AuthorityCreator;
import de.justsoftware.onx.common.shared.model.NameAndParam;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.common.shared.model.Role;
import de.justsoftware.onx.common.shared.model.action.Action;
import de.justsoftware.onx.common.shared.model.component.ComponentType;
import de.justsoftware.onx.common.shared.util.Maps2;
import de.justsoftware.onx.container.business.ItemService;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.Identifiables;
import de.justsoftware.onx.container.shared.model.ItemId;
import de.justsoftware.onx.container.shared.model.right.Right;
import de.justsoftware.onx.container.shared.server.model.EntityItem;
import de.justsoftware.onx.container.shared.server.model.Item;
import de.justsoftware.onx.person.business.PersonRoleService;
import de.justsoftware.onx.person.model.DBPerson;
import de.justsoftware.onx.person.shared.server.model.ProfileItem;
import de.justsoftware.onx.util.shared.NullPermeableFunction;
import de.justsoftware.toolbox.stream.EntryCollectors;
import de.justsoftware.toolbox.stream.EntryStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ParametersAreNonnullByDefault
public class PersonIndependentAuthorizationContextImpl
implements PersonIndependentAuthorizationContext,
ItemPathHelper,
HasAuthorizationCache {
    private static final Logger LOG = LoggerFactory.getLogger(PersonIndependentAuthorizationContextImpl.class);
    private final ItemService _itemService;
    private final RolesService _rolesService;
    private final RightsService _rightsService;
    private final ConfigFileService _configFileService;
    private final PersonRoleService _personRoleService;
    private final Cache<ContextCache<?>, Object> _cache = CacheBuilder.newBuilder().maximumSize(1000L).build();
    private final Map<Object, HasAuthorizationCache.AuthorizationContextCache<?, ?>> _caches = Maps.newHashMap();

    @ParametersAreNonnullByDefault
    PersonIndependentAuthorizationContextImpl(ItemService itemService, RolesService rolesService, RightsService rightsService, ConfigFileService configFileService, PersonRoleService personRoleService) {
        this._itemService = itemService;
        this._rolesService = rolesService;
        this._rightsService = rightsService;
        this._configFileService = configFileService;
        this._personRoleService = personRoleService;
    }

    @Override
    public <K, V> HasAuthorizationCache.AuthorizationContextCache<K, V> getCache(LoadOperation<K, V> operation) {
        HasAuthorizationCache.AuthorizationContextCache<?, ?> existingCache = this._caches.get(operation.getCacheKey());
        if (existingCache != null) {
            return existingCache;
        }
        HasAuthorizationCache.AuthorizationContextCache<K, V> newCache = new HasAuthorizationCache.AuthorizationContextCache<K, V>(operation);
        this._caches.put(operation.getCacheKey(), newCache);
        return newCache;
    }

    @Override
    public <T extends ItemId> ImmutableMap<T, Item<? extends T>> getItemsByIds(Iterable<? extends T> itemIds) {
        if (Iterables.isEmpty(itemIds)) {
            return ImmutableMap.of();
        }
        return Maps2.onlyPresentValues(this.getCache(LoadOperation.optional(this._itemService::getByIds)).load(itemIds));
    }

    @Override
    public <I extends Item<?>, A extends Action> ImmutableSet<AuthorizationKey<I, A>> may(Iterable<? extends I> items, Iterable<DBPerson> persons, Iterable<? extends A> actions, ImmutableSet<? extends Role> defaultRolesForNullUsers) {
        ImmutableSet.Builder set = ImmutableSet.builder();
        for (Item item : items) {
            for (DBPerson person : persons) {
                for (Action action : actions) {
                    set.add(new AuthorizationKey<Item, Action>(item, person, defaultRolesForNullUsers, action));
                }
            }
        }
        return this.may((Set<AuthorizationKey<I, A>>)set.build());
    }

    @Override
    public <I extends Item<?>, A extends Action> ImmutableSet<AuthorizationKey<I, A>> may(Set<AuthorizationKey<I, A>> authorizationKeys) {
        ImmutableListMultimap<ItemId, Item<?>> itemPaths = this.getItemPathsForAuthorizationKeys(authorizationKeys);
        LinkedList boolExpressions = Lists.newLinkedList();
        for (AuthorizationKey<I, A> authoriztionKey : authorizationKeys) {
            ItemId itemId = (ItemId)Identifiables.getIdFromNullable(authoriztionKey.getItem());
            ImmutableList itemPath = itemPaths.get((Object)itemId);
            BoolExpr bexpr = this.getExpressionCached(itemId, itemPath, (Action)authoriztionKey.getAdditional());
            boolExpressions.add(new ResolveState<AuthorizationKey<I, A>>(authoriztionKey, bexpr));
        }
        return this.eval(itemPaths, boolExpressions);
    }

    @Nonnull
    private <K extends BaseAuthorizationKey<?, ?>> ImmutableSet<K> eval(final ImmutableListMultimap<ItemId, Item<?>> itemPaths, LinkedList<ResolveState<K>> boolExpressions) {
        ImmutableMap result = this.eval(new EvaluationPlan<K, Boolean>(){

            @Override
            public EvalContext createEvalContext(CalculationContext calculationContext, K key) {
                ImmutableList itemPath = itemPaths.get((Object)((ItemId)Identifiables.getIdFromNullable(((BaseAuthorizationKey)key).getItem())));
                return new RightContext(calculationContext, (BaseAuthorizationKey<?, ?>)key, (ImmutableList<Item<?>>)itemPath);
            }

            @Override
            public Optional<Boolean> getFinalResult(ResolveState<K> state) {
                BoolExpr expr = state.getExpr();
                if (expr instanceof ConstExpr) {
                    return Optional.of((Object)((ConstExpr)expr).isValue());
                }
                return Optional.absent();
            }
        }, boolExpressions);
        return ImmutableSet.copyOf(Maps.filterValues(result, (Predicate)Predicates.equalTo((Object)Boolean.TRUE)).keySet());
    }

    @Nonnull
    private <K, V> ImmutableMap<K, V> eval(EvaluationPlan<K, V> evaluationPlan, Iterable<ResolveState<K>> boolExpressions) {
        CalculationContext calculationContext = new CalculationContext(this);
        ImmutableMap.Builder resultMap = ImmutableMap.builder();
        while (!Iterables.isEmpty(boolExpressions)) {
            calculationContext.loadMissingValues();
            Iterator<ResolveState<K>> it = boolExpressions.iterator();
            while (it.hasNext()) {
                ResolveState<K> resolveState = it.next();
                K authorizationKey = resolveState.getKey();
                try {
                    EvalContext evalContext = evaluationPlan.createEvalContext(calculationContext, authorizationKey);
                    BoolExpr evalResult = resolveState.getExpr().eval(evalContext);
                    this.loopDetection(resolveState, evalResult);
                    Optional<V> result = evaluationPlan.getFinalResult(resolveState);
                    if (result.isPresent()) {
                        calculationContext.forgetKeys();
                        it.remove();
                        resultMap.put(authorizationKey, result.get());
                        continue;
                    }
                    calculationContext.addKeys();
                }
                catch (EvalException e) {
                    throw new ServiceException(e);
                }
            }
        }
        return resultMap.build();
    }

    private void loopDetection(ResolveState<?> resolveState, BoolExpr evalResult) {
        int evalLevelCounts = resolveState.setExprAndDetectLoop(evalResult);
        if (evalLevelCounts > 100) {
            LOG.warn("possible loop detected while resolving {} for {}", (Object)evalResult, resolveState.getKey());
            ImmutableMap<String, AuthorityCreator> allAuthorities = this.getAllAuthoritiesCached();
            BoolExpr noRights = evalResult.eval(varExpr -> {
                Authority authority = AuthorityUtil.valueOf((Map<String, ? extends AuthorityCreator>)allAuthorities, varExpr.getVarName());
                if (authority instanceof Right) {
                    return BoolExpr.FALSE;
                }
                if (authority instanceof Role) {
                    return varExpr;
                }
                throw new UnsupportedOperationException("Don't know how to handle: " + authority.getClass());
            });
            resolveState.setExprAndDetectLoop(noRights);
        }
    }

    @Nonnull
    private ImmutableListMultimap<ItemId, Item<?>> getItemPathsForAuthorizationKeys(Iterable<? extends BaseAuthorizationKey<?, ?>> authoriztionKeys) {
        return this.getItemPaths(Iterables.transform(authoriztionKeys, (Function)Functions.compose(ItemOrItemIdContainer.FROM_ITEM, BaseAuthorizationKey.GET_ITEM)));
    }

    @Override
    public ImmutableListMultimap<ItemId, Item<?>> getItemPathForIds(Iterable<? extends ItemId> ids) {
        return this.getItemPaths(Iterables.transform(ids, ItemOrItemIdContainer.FROM_ID));
    }

    @Nonnull
    private ImmutableListMultimap<ItemOrItemIdContainer, Item<?>> loadItemPathOperation(Set<ItemOrItemIdContainer> keys) {
        final HashSet idsOnly = Sets.newHashSet();
        final HashSet loadedOrNotFound = Sets.newHashSet((Object[])new ItemId[]{null});
        final HashMap itemsAndParents = Maps.newHashMap();
        ItemOrItemIdContainer.Visitor<ItemId> collector = new ItemOrItemIdContainer.Visitor<ItemId>(){

            @Override
            public ItemId visit(Item<?> item) {
                itemsAndParents.put(item.getId(), item);
                loadedOrNotFound.add(item.getId());
                return item.getId();
            }

            @Override
            public ItemId visit(ItemId id) {
                idsOnly.add(id);
                return id;
            }
        };
        for (ItemOrItemIdContainer itemOrId : keys) {
            if (itemOrId == null) continue;
            itemOrId.accept(collector);
        }
        HashSet missing = Sets.newHashSet((Iterable)Iterables.transform(itemsAndParents.values(), Item.GET_PARENT_ID));
        missing.addAll(idsOnly);
        missing.removeAll(loadedOrNotFound);
        while (!missing.isEmpty()) {
            itemsAndParents.putAll(this.getItemsByIds(missing));
            loadedOrNotFound.addAll(missing);
            missing = Sets.newHashSet((Iterable)Iterables.transform(itemsAndParents.values(), Item.GET_PARENT_ID));
            missing.removeAll(loadedOrNotFound);
        }
        ImmutableListMultimap.Builder result = ImmutableListMultimap.builder();
        Iterator iterator = itemsAndParents.values().iterator();
        while (iterator.hasNext()) {
            Item item;
            Item currentParentItem = item = (Item)iterator.next();
            while (currentParentItem != null) {
                result.put((Object)new ItemOrItemIdContainer.ItemContainer(item), (Object)currentParentItem);
                currentParentItem = (Item)itemsAndParents.get(currentParentItem.getParentId());
            }
        }
        return result.build();
    }

    @Nonnull
    private ImmutableListMultimap<ItemId, Item<?>> getItemPaths(Iterable<? extends ItemOrItemIdContainer> itemsOrIds) {
        if (Iterables.isEmpty(itemsOrIds)) {
            return ImmutableListMultimap.of();
        }
        Map<ItemOrItemIdContainer, ImmutableList> fromCache = this.getCache(keys -> Maps.asMap((Set)keys, arg_0 -> this.loadItemPathOperation(keys).get(arg_0))).load(itemsOrIds);
        ImmutableListMultimap.Builder result = ImmutableListMultimap.builder();
        fromCache.forEach((k, v) -> {
            if (k != null) {
                result.putAll((Object)k.getId(), (Iterable)v);
            }
        });
        return result.build();
    }

    @Nonnull
    private BoolExpr getExpressionCached(@Nullable ItemId itemIdAsCacheKey, final ImmutableList<Item<?>> itemPath, final Action a) {
        return (BoolExpr)new AuthorizationCache<BoolExpr>("getExpressionCached", new Object[]{itemIdAsCacheKey, a}){

            @Override
            protected BoolExpr loadValue() {
                return PersonIndependentAuthorizationContextImpl.this._configFileService.getConfigFile().getAction(PersonIndependentAuthorizationContextImpl.this.buildPath(itemPath, a)).simplify();
            }
        }.load();
    }

    @Nonnull
    private Path buildPath(ImmutableList<Item<?>> itemPath, Action action) {
        Path.Builder path = Path.builder();
        for (Item i : itemPath.reverse()) {
            path.add(i);
        }
        return path.buildWithAction(action);
    }

    @Nonnull
    private BoolExpr hasRight(CalculationContext calculationContext, ImmutableList<Item<?>> items, VarExpr varExpr, Right right, ComponentType defaultChildModuleType) {
        ComponentType childModuleType = defaultChildModuleType;
        ImmutableSet.Builder or = ImmutableSet.builder();
        for (Item i : items) {
            BoolExpr expr = this._rightsService.hasRight(calculationContext, i, childModuleType, right, this);
            if (BoolExpr.TRUE.equals(expr)) {
                return expr;
            }
            or.add((Object)expr);
            childModuleType = i.getModuleType();
        }
        return BoolExpr.or(varExpr.getPos(), (Iterable<? extends BoolExpr>)or.build());
    }

    @Override
    public <A extends Authority> ImmutableSet<A> hasAuthorities(Item<?> item, DBPerson person, ImmutableSet<? extends Role> defaultRolesForNullUser, Set<A> authorities) {
        LinkedList boolExpressions = Lists.newLinkedList();
        HashSet keys = Sets.newHashSet();
        for (Authority authority : authorities) {
            BaseAuthorizationKey key = new BaseAuthorizationKey(item, person, defaultRolesForNullUser, authority);
            keys.add(key);
            boolExpressions.add(new ResolveState(key, BoolExpr.var(authority)));
        }
        ImmutableListMultimap<ItemId, Item<?>> itemPaths = this.getItemPathsForAuthorizationKeys(keys);
        return ImmutableSet.copyOf((Iterable)Iterables.transform(this.eval(itemPaths, boolExpressions), (Function)new Function<BaseAuthorizationKey<?, A>, A>(){

            public A apply(BaseAuthorizationKey<?, A> input) {
                return input != null ? (Authority)input.getAdditional() : null;
            }
        }));
    }

    @Nonnull
    private Authority getAuthorityCached(final NameAndParam variableName) throws EvalException {
        return (Authority)new AuthorizationCache<Authority>("getAuthorityCached", new Object[]{variableName}){

            @Override
            protected Authority loadValue() {
                try {
                    return AuthorityUtil.valueOf(PersonIndependentAuthorizationContextImpl.this.getAllAuthoritiesCached(), variableName);
                }
                catch (IllegalArgumentException e) {
                    throw new EvalException(e);
                }
            }
        }.load();
    }

    @Nonnull
    private ImmutableMap<String, AuthorityCreator> getAllAuthoritiesCached() {
        return (ImmutableMap)new AuthorizationCache<ImmutableMap<String, AuthorityCreator>>("getAllAuthoritiesCached", new Object[0]){

            @Override
            protected ImmutableMap<String, AuthorityCreator> loadValue() {
                ImmutableMap.Builder result = ImmutableMap.builder();
                result.putAll((Map)Maps.uniqueIndex(PersonIndependentAuthorizationContextImpl.this._configFileService.getConfigFile().getAllPersonRoles(), Role.TO_NAME));
                result.putAll(ConfFileNode.STATIC_ALL_AUTHORITIES);
                return result.build();
            }
        }.load();
    }

    @Override
    public ImmutableMap<ItemId, ImmutableSetMultimap<Action, Role>> neededRolesForActions(SetMultimap<? extends ItemId, ? extends Action> itemsAndActions) {
        ImmutableMap<ItemIdAndAction, ImmutableSet<Role>> resultMap = this.neededRolesForActionsBulked(itemsAndActions);
        ImmutableMap sortedByItemId = ((ImmutableSetMultimap)resultMap.keySet().stream().collect(ImmutableSetMultimap.toImmutableSetMultimap(ItemIdAndAction::getItemId, (java.util.function.Function)Functions.identity()))).asMap();
        return (ImmutableMap)EntryStream.from((Map)sortedByItemId).mapValue(input -> (ImmutableSetMultimap)input.stream().collect(ImmutableSetMultimap.flatteningToImmutableSetMultimap(ItemIdAndAction::getAction, i -> ((ImmutableSet)resultMap.get(i)).stream()))).collect(EntryCollectors.toImmutableMap());
    }

    @Nonnull
    private <T> ImmutableMap<ItemIdAndAction, T> evalForActionsBulked(SetMultimap<? extends ItemId, ? extends Action> itemsAndActions, final Function<ResolveState<ItemIdAndAction>, Optional<T>> getFinalResultFunction) {
        final ImmutableListMultimap<ItemId, Item<?>> itemPath = this.getItemPaths((Iterable<? extends ItemOrItemIdContainer>)FluentIterable.from((Iterable)itemsAndActions.keySet()).transform(ItemOrItemIdContainer.FROM_ID));
        final ImmutableMap<String, AuthorityCreator> allAuthorities = this.getAllAuthoritiesCached();
        LinkedList unresolvedExpressions = Lists.newLinkedList();
        for (Map.Entry ia : itemsAndActions.entries()) {
            ItemId itemId = (ItemId)ia.getKey();
            Action action = (Action)ia.getValue();
            BoolExpr expr = this.getExpressionCached(itemId, itemPath.get((Object)itemId), action);
            unresolvedExpressions.add(new ResolveState<ItemIdAndAction>(new ItemIdAndAction(itemId, action), expr));
        }
        return this.eval(new EvaluationPlan<ItemIdAndAction, T>(){

            @Override
            public EvalContext createEvalContext(final CalculationContext calculationContext, final ItemIdAndAction key) {
                return new EvalContext(){

                    @Override
                    public BoolExpr eval(VarExpr varExpr) throws EvalException {
                        Authority result = AuthorityUtil.valueOf((Map<String, ? extends AuthorityCreator>)allAuthorities, varExpr.getVarName());
                        if (result instanceof Right) {
                            return PersonIndependentAuthorizationContextImpl.this.hasRight(calculationContext, itemPath.get((Object)key.getItemId()), varExpr, (Right)result, key.getAction().getComponentType());
                        }
                        if (result instanceof Role) {
                            return varExpr;
                        }
                        throw new UnsupportedOperationException("Don't know how to handle: " + result.getClass());
                    }
                };
            }

            @Override
            public Optional<T> getFinalResult(ResolveState<ItemIdAndAction> state) {
                return (Optional)getFinalResultFunction.apply(state);
            }
        }, unresolvedExpressions);
    }

    @Nonnull
    private ImmutableMap<ItemIdAndAction, ImmutableSet<Role>> neededRolesForActionsBulked(SetMultimap<? extends ItemId, ? extends Action> itemsAndActions) {
        final ImmutableMap<String, AuthorityCreator> allAuthorities = this.getAllAuthoritiesCached();
        return this.evalForActionsBulked(itemsAndActions, new NullPermeableFunction<ResolveState<ItemIdAndAction>, Optional<ImmutableSet<Role>>>(){

            @Override
            protected Optional<ImmutableSet<Role>> applySafe(ResolveState<ItemIdAndAction> state) {
                Action action = state.getKey().getAction();
                ItemId itemId = state.getKey().getItemId();
                NeededRolesForActionVisitor visitor = new NeededRolesForActionVisitor((ImmutableMap<String, AuthorityCreator>)allAuthorities, action);
                ImmutableSet<Role> roles = state.getExpr().accept(visitor);
                if (roles.contains((Object)StaticPredefinedRole.ALL)) {
                    return Optional.of((Object)ImmutableSet.of((Object)StaticPredefinedRole.ALL));
                }
                if (visitor._unresolved > 0) {
                    return Optional.absent();
                }
                if (roles.contains((Object)StaticPredefinedRole.LOGGED_IN)) {
                    if (itemId instanceof EntityId) {
                        EntityItem item = (EntityItem)PersonIndependentAuthorizationContextImpl.this.getItemsByIds(Set.of(itemId)).get((Object)itemId);
                        if (item == null) {
                            return Optional.absent();
                        }
                        TenantRole tenantMembers = TenantRole.of(item.getEntity().getTenantId());
                        return Optional.of((Object)ImmutableSet.of((Object)tenantMembers, (Object)PersonRole.valueOf("SUPERADMIN")));
                    }
                    return Optional.of((Object)ImmutableSet.of((Object)StaticPredefinedRole.LOGGED_IN));
                }
                if (visitor._illegal != null) {
                    throw new IllegalArgumentException(visitor._illegal);
                }
                return Optional.of(roles);
            }
        });
    }

    private boolean containsRight(VarExpr varExpr) {
        return this.getAuthorityCached(varExpr.getVarName()) instanceof Right;
    }

    @Nonnull
    private Optional<BoolExpr> checkStateContainsNoRights(ResolveState<ItemIdAndAction> state) {
        BoolExpr expr = state.getExpr();
        return expr.test(this::containsRight) ? Optional.absent() : Optional.of((Object)expr);
    }

    @Override
    public ImmutableMap<ItemIdAndAction, BoolExpr> neededExpressionsForActionsBulked(SetMultimap<? extends ItemId, ? extends Action> itemsAndActions) {
        return this.evalForActionsBulked(itemsAndActions, this::checkStateContainsNoRights);
    }

    @Override
    public ImmutableSetMultimap<Boolean, PersonId> groupByAllowed(ItemId itemId, Action action, Iterable<PersonId> personIds) {
        Iterable profileIds = Iterables.transform(personIds, PersonId.AS_PROFILE_ID);
        ImmutableMap items = this.getItemsByIds((Iterable)ImmutableSet.builder().add((Object)itemId).addAll(profileIds).build());
        Item item = (Item)items.get((Object)itemId);
        LinkedList persons = Lists.newLinkedList((Iterable)Iterables.transform((Iterable)Iterables.filter((Iterable)Iterables.transform((Iterable)profileIds, (Function)Functions.forMap(items, null)), ProfileItem.class), ProfileItem.GET_PERSON_FUNCTION));
        persons.add(null);
        ImmutableSet result = this.may((Iterable)Collections.singleton(item), persons, (Iterable)ImmutableSet.of((Object)action), (ImmutableSet<? extends Role>)NO_ROLES);
        return (ImmutableSetMultimap)Streams.stream(personIds).collect(ImmutableSetMultimap.toImmutableSetMultimap(input -> {
            Item profile;
            DBPerson person = input == null ? null : ((profile = (Item)items.get((Object)input.asProfileId())) instanceof ProfileItem ? ((ProfileItem)profile).getPerson() : null);
            return result.contains(new AuthorizationKey<Item, Action>(item, person, (ImmutableSet<? extends Role>)NO_ROLES, action));
        }, (java.util.function.Function)Functions.identity()));
    }

    private boolean may(Item<?> item, Action action, @Nullable DBPerson person, ImmutableSet<? extends Role> defaultRolesForNullUsers) {
        AuthorizationKey key = new AuthorizationKey(item, person, defaultRolesForNullUsers, action);
        return this.may((Set)ImmutableSet.of(key)).contains(key);
    }

    @Override
    public boolean may(Item<?> item, Action action, ImmutableSet<? extends Role> roles) {
        return this.may(item, action, null, roles);
    }

    @Override
    public boolean may(Item<?> item, Action action, DBPerson person) {
        return this.may(item, action, person, (ImmutableSet<? extends Role>)NO_ROLES);
    }

    @Override
    public BoolExpr createExpression(ItemId itemId, Action action) throws InvalidIDException {
        ImmutableList path = this.getItemPaths((Iterable<? extends ItemOrItemIdContainer>)ImmutableSet.of((Object)new ItemOrItemIdContainer.ItemIdContainer(itemId))).get((Object)itemId);
        return this.getExpressionCached(itemId, path, action);
    }

    @Override
    public BoolExpr createExpression(Item<?> item, Action action) {
        ImmutableList path = this.getItemPaths((Iterable<? extends ItemOrItemIdContainer>)ImmutableSet.of((Object)new ItemOrItemIdContainer.ItemContainer(item))).get(item.getId());
        return this.getExpressionCached((ItemId)item.getId(), path, action);
    }

    @Override
    public void invalidate() {
        this._cache.invalidateAll();
        this._caches.clear();
    }

    private static final class NeededRolesForActionVisitor
    implements BoolExprVisitor<ImmutableSet<Role>> {
        private int _unresolved = 0;
        private String _illegal = null;
        private final ImmutableMap<String, AuthorityCreator> _allAuthorities;
        private final Action _action;

        private NeededRolesForActionVisitor(@Nonnull ImmutableMap<String, AuthorityCreator> allAuthorities, @Nonnull Action action) {
            this._allAuthorities = allAuthorities;
            this._action = action;
        }

        @Override
        public ImmutableSet<Role> visit(AndExpr expr) {
            if (this._action.isReadAction()) {
                this._illegal = "it is not allowed to use AND for Action " + this._action;
            }
            return ImmutableSet.of();
        }

        @Override
        public ImmutableSet<Role> visit(NotExpr expr) {
            if (this._action.isReadAction()) {
                this._illegal = "it is not allowed to use NOT for Action " + this._action;
            }
            return ImmutableSet.of();
        }

        @Override
        public ImmutableSet<Role> visit(OrExpr expr) {
            ImmutableSet.Builder result = ImmutableSet.builder();
            for (BoolExpr v : expr.getExprs()) {
                result.addAll((Iterable)v.accept(this));
            }
            return result.build();
        }

        @Override
        public ImmutableSet<Role> visit(ConstExpr expr) {
            return expr.isValue() ? ImmutableSet.of((Object)StaticPredefinedRole.ALL) : ImmutableSet.of();
        }

        @Override
        public ImmutableSet<Role> visit(VarExpr expr) {
            Authority result = AuthorityUtil.valueOf(this._allAuthorities, expr.getVarName());
            if (result instanceof Right) {
                ++this._unresolved;
                return ImmutableSet.of();
            }
            if (result instanceof Role) {
                return ImmutableSet.of((Object)((Role)result));
            }
            throw new UnsupportedOperationException("Don't know how to handle: " + result.getClass());
        }
    }

    @ParametersAreNonnullByDefault
    private final class RightContext
    implements EvalContext {
        private final ImmutableList<Item<?>> _items;
        private final ComponentType _defaultChildModuleType;
        private final CalculationContext _calculationContext;
        private final BaseAuthorizationKey<?, ?> _key;

        private RightContext(CalculationContext calculationContext, BaseAuthorizationKey<?, ?> key, ImmutableList<Item<?>> items) {
            this._calculationContext = calculationContext;
            this._key = key;
            this._items = items;
            this._defaultChildModuleType = key.getComponentType();
        }

        @Override
        public BoolExpr eval(VarExpr varExpr) throws EvalException {
            Authority authority = PersonIndependentAuthorizationContextImpl.this.getAuthorityCached(varExpr.getVarName());
            if (authority instanceof Right) {
                return this.hasRight(varExpr, (Right)authority);
            }
            if (authority instanceof Role) {
                return this.hasRole(varExpr, (Role)authority);
            }
            return BoolExpr.FALSE;
        }

        @Nonnull
        private BoolExpr hasRole(VarExpr varExpr, Role role) {
            DBPerson person = this._key.getPerson();
            if (person != null && !person.isDeleted()) {
                return this._calculationContext.get((Authority)role, person.getId(), this::loadRoles, roles -> this.hasRole(varExpr, role, (Set<? extends Role>)roles));
            }
            return this.hasRole(varExpr, role, (Set<? extends Role>)this._key.getDefaultRolesForNullUsers());
        }

        @Nonnull
        private Map<PersonId, ImmutableSet<PersonRole>> loadRoles(Set<PersonId> personIds) {
            return Maps.asMap(personIds, arg_0 -> PersonIndependentAuthorizationContextImpl.this._personRoleService.getPersonRoles(personIds).get(arg_0));
        }

        @Nonnull
        private BoolExpr hasRole(VarExpr varExpr, Role role, Set<? extends Role> userRoles) {
            if (userRoles.contains(role)) {
                return BoolExpr.TRUE;
            }
            if (role instanceof StaticRole) {
                return this.hasStaticRole(varExpr, (StaticRole)role);
            }
            return BoolExpr.FALSE;
        }

        @Nonnull
        private BoolExpr hasStaticRole(VarExpr varExpr, StaticRole role) {
            if (this._items.isEmpty()) {
                return PersonIndependentAuthorizationContextImpl.this._rolesService.boolExpr(this._calculationContext, null, this._key.getPerson(), role);
            }
            ImmutableSet.Builder or = ImmutableSet.builder();
            for (Item item : this._items) {
                BoolExpr expr = PersonIndependentAuthorizationContextImpl.this._rolesService.boolExpr(this._calculationContext, item, this._key.getPerson(), role);
                if (BoolExpr.TRUE.equals(expr)) {
                    return expr;
                }
                or.add((Object)expr);
            }
            return BoolExpr.or(varExpr.getPos(), (Iterable<? extends BoolExpr>)or.build());
        }

        @Nonnull
        private BoolExpr hasRight(VarExpr varExpr, Right right) {
            return PersonIndependentAuthorizationContextImpl.this.hasRight(this._calculationContext, this._items, varExpr, right, this._defaultChildModuleType);
        }
    }

    private static final class ResolveState<K> {
        private BoolExpr _expr;
        private final K _key;
        private int _count = 0;

        ResolveState(@Nonnull K key, @Nonnull BoolExpr expr) {
            this._key = key;
            this._expr = expr;
        }

        @Nonnull
        public K getKey() {
            return this._key;
        }

        @Nonnull
        public BoolExpr getExpr() {
            return this._expr;
        }

        public int setExprAndDetectLoop(@Nonnull BoolExpr expr) {
            this._expr = expr;
            return ++this._count;
        }

        public String toString() {
            return "(" + this._key + ":" + this._expr + ")";
        }
    }

    private static interface EvaluationPlan<K, V> {
        @Nonnull
        public EvalContext createEvalContext(@Nonnull CalculationContext var1, @Nonnull K var2);

        @Nonnull
        public Optional<V> getFinalResult(@Nonnull ResolveState<K> var1);
    }

    private abstract class AuthorizationCache<T>
    extends ContextCache<T> {
        AuthorizationCache(@Nonnull String method, Object ... params) {
            super(PersonIndependentAuthorizationContextImpl.this._cache, method, params);
        }
    }
}

