/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.authorization.business.impl;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
@FunctionalInterface
interface LoadOperation<K, V> {
    @Nonnull
    public Map<? extends K, ? extends V> load(Set<K> var1);

    @Nonnull
    default public Object getCacheKey() {
        return this.getClass();
    }

    @Nonnull
    public static <K, V> LoadOperation<K, Optional<V>> optional(final Function<? super Set<K>, ? extends Map<? extends K, ? extends V>> f) {
        return new LoadOperation<K, Optional<V>>(){

            @Override
            public final Map<K, Optional<V>> load(Set<K> keys) {
                Map m = (Map)f.apply(keys);
                return Maps.asMap(keys, k -> Optional.fromNullable(m.get(k)));
            }

            @Override
            public final Object getCacheKey() {
                return ImmutableList.of((Object)"optional", f.getClass());
            }
        };
    }
}

