/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.authorization.business.impl;

import de.justsoftware.onx.authorization.business.JustRolesPublisher;
import de.justsoftware.onx.container.business.EntityRolePublisher;
import de.justsoftware.onx.person.business.JustRolesKafkaProducer;
import de.justsoftware.onx.person.business.PersonRolePublisher;
import de.justsoftware.onx.server.business.JucoServerVersionUpdateProcessor;
import de.justsoftware.onx.server.business.UpdateBehaviour;
import de.justsoftware.onx.server.model.JucoVersionUpdateProcess;
import de.justsoftware.toolbox.kafka.client.KafkaCleaningProducerState;
import javax.annotation.ParametersAreNonnullByDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StopWatch;

@ParametersAreNonnullByDefault
@Service
public class JustRolesPublisherImpl
implements JucoServerVersionUpdateProcessor,
JustRolesPublisher {
    private static final Logger LOG = LoggerFactory.getLogger(JustRolesPublisherImpl.class);
    private final JustRolesKafkaProducer _rolesKafkaProducer;
    private final EntityRolePublisher _entityRolePublisher;
    private final PersonRolePublisher _personRolePublisher;

    @Autowired
    public JustRolesPublisherImpl(JustRolesKafkaProducer rolesKafkaProducer, EntityRolePublisher entityRolePublisher, PersonRolePublisher personRolePublisher) {
        this._rolesKafkaProducer = rolesKafkaProducer;
        this._entityRolePublisher = entityRolePublisher;
        this._personRolePublisher = personRolePublisher;
    }

    @Override
    public void publishAllRoles() {
        try (KafkaCleaningProducerState<String> cleaningState = this._rolesKafkaProducer.beginRefill();){
            if (cleaningState == null) {
                LOG.warn("publishRoles failed, as kafkaProducer could not start the cleaning process.");
            } else {
                StopWatch watch = new StopWatch("publish all roles to just.roles");
                watch.start("publishing static roles");
                int staticRoles = this._personRolePublisher.publishAllRoles();
                LOG.debug("published {} personRoles", (Object)staticRoles);
                watch.stop();
                watch.start("publishing friendships");
                int friendships = this._personRolePublisher.publishAllFriendships();
                LOG.debug("published {} friendships", (Object)friendships);
                watch.stop();
                watch.start("publishing entity member roles");
                int entityMemberRoles = this._entityRolePublisher.publishAllMemberRoles();
                LOG.debug("published {} entityMemberRoles", (Object)entityMemberRoles);
                watch.stop();
                watch.start("publishing entity assignees");
                int assignees = this._entityRolePublisher.publishAllEntityAssignees();
                LOG.debug("published {} assignees", (Object)assignees);
                watch.stop();
                watch.start("publishing entity reviewers");
                int reviewers = this._entityRolePublisher.publishAllEntityReviewers();
                LOG.debug("published {} reviewers", (Object)reviewers);
                watch.stop();
                watch.start("starting cleaning process");
                cleaningState.finishRefill();
                watch.stop();
                LOG.debug(watch.prettyPrint());
            }
        }
    }

    @Override
    public JucoVersionUpdateProcess getProcessType() {
        return JucoVersionUpdateProcess.PUBLISH_JUST_ROLES;
    }

    @Override
    public UpdateBehaviour getUpdateBehaviour() {
        return UpdateBehaviour.onceOnMasterForVersion(this, "10.0.0-93");
    }

    @Override
    public int getProcessorVersion() {
        return 1;
    }

    @Override
    public void process() {
        this.publishAllRoles();
    }
}

