/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.authorization.business.impl;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import de.justsoftware.onx.authorization.business.JustPermissionPersonRolesPublisher;
import de.justsoftware.onx.authorization.business.PersonRole;
import de.justsoftware.onx.authorization.business.ProfileRole;
import de.justsoftware.onx.common.business.events.ServerEventHandler;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.events.PersonRolesChangedEvent;
import de.justsoftware.onx.person.integration.persistence.PersonDAO;
import de.justsoftware.onx.server.business.JucoServerVersionUpdateProcessor;
import de.justsoftware.onx.server.business.UpdateBehaviour;
import de.justsoftware.onx.server.model.JucoVersionUpdateProcess;
import de.justsoftware.permission.client.kafka.SingleRoleAssignmentProducer;
import de.justsoftware.permission.client.model.Role;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@ParametersAreNonnullByDefault
public class JustPermissionPersonRolesPublisherImpl
implements JustPermissionPersonRolesPublisher,
ServerEventHandler,
JucoServerVersionUpdateProcessor {
    private final PersonDAO _personDAO;
    private final SingleRoleAssignmentProducer _singleRoleAssignmentProducer;

    @Autowired
    public JustPermissionPersonRolesPublisherImpl(PersonDAO personDAO, SingleRoleAssignmentProducer singleRoleAssignmentKafkaProducer) {
        this._personDAO = personDAO;
        this._singleRoleAssignmentProducer = singleRoleAssignmentKafkaProducer;
    }

    @Override
    public void publishAllPersonRoles() {
        this._singleRoleAssignmentProducer.republish(Role::isStaticRole, () -> this._personDAO.forAllPersonRoles((person, role) -> this._singleRoleAssignmentProducer.addRoleReplacement(role.asPermissionRole(), new ProfileRole((PersonId)person).asPermissionRole())));
    }

    @AllowConcurrentEvents
    @Subscribe
    public void onPersonRolesChangedEvent(PersonRolesChangedEvent event) {
        ImmutableSet<PersonRole> newRoles = event.getNewRoles();
        for (PersonRole role : Sets.union(newRoles, event.getOldRoles())) {
            if (newRoles.contains((Object)role)) {
                this._singleRoleAssignmentProducer.addRoleReplacement(role.asPermissionRole(), new ProfileRole(event.getPersonId()).asPermissionRole());
                continue;
            }
            this._singleRoleAssignmentProducer.deleteRoleReplacement(role.asPermissionRole(), new ProfileRole(event.getPersonId()).asPermissionRole());
        }
    }

    @Override
    public JucoVersionUpdateProcess getProcessType() {
        return JucoVersionUpdateProcess.PUBLISH_PERSON_ROLES_TO_PERMISSION;
    }

    @Override
    public UpdateBehaviour getUpdateBehaviour() {
        return UpdateBehaviour.onceOnMasterForVersion(this, "11.0.0");
    }

    @Override
    public int getProcessorVersion() {
        return 2;
    }

    @Override
    public void process() {
        this.publishAllPersonRoles();
    }
}

