/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.authorization.business.impl;

import com.google.common.base.Optional;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import de.justsoftware.onx.authorization.business.impl.LoadOperation;
import de.justsoftware.onx.common.shared.util.Optionals;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

interface HasAuthorizationCache {
    @Nonnull
    public <K, V> AuthorizationContextCache<K, V> getCache(@Nonnull LoadOperation<K, V> var1);

    public static final class AuthorizationContextCache<K, V> {
        final LoadOperation<K, V> _load;
        private final Cache<Optional<K>, V> _cache = CacheBuilder.newBuilder().maximumSize(200L).build();

        AuthorizationContextCache(@Nonnull LoadOperation<K, V> load) {
            this._load = load;
        }

        @Nonnull
        Map<K, V> load(@Nonnull Iterable<? extends K> keys) {
            ImmutableSet optionalKeys = ImmutableSet.copyOf((Iterable)Iterables.transform(keys, Optionals.fromNullableFunction()));
            ImmutableMap exisiting = this._cache.getAllPresent((Iterable)optionalKeys);
            Sets.SetView missingOptional = Sets.difference((Set)optionalKeys, (Set)exisiting.keySet());
            HashSet missing = Sets.newHashSet((Iterable)Iterables.transform((Iterable)missingOptional, Optionals.orNullFunction()));
            Map<K, V> loaded = this._load.load(missing);
            HashMap result = Maps.newHashMap();
            for (Map.Entry entry : exisiting.entrySet()) {
                result.put(((Optional)entry.getKey()).orNull(), entry.getValue());
            }
            for (Object key : missing) {
                V value = loaded.get(key);
                this._cache.put((Object)Optional.fromNullable(key), value);
                result.put(key, value);
            }
            return result;
        }

        @CheckForNull
        V peek(@Nullable K key) {
            return (V)this._cache.getIfPresent((Object)Optional.fromNullable(key));
        }
    }
}

