/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.authorization.business.impl;

import com.freiheit.toro.admin.shared.server.superoperty.Settings;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.onx.authorization.business.AuthorizationContext;
import de.justsoftware.onx.authorization.business.AuthorizationContextProvider;
import de.justsoftware.onx.authorization.business.BasePersonIndependentAuthorizationContext;
import de.justsoftware.onx.authorization.business.PersonIndependentAuthorizationContext;
import de.justsoftware.onx.authorization.business.impl.AuthorizationCheckContextWithRole;
import de.justsoftware.onx.authorization.business.impl.DefaultAuthorizationContext;
import de.justsoftware.onx.authorization.business.impl.PersonIndependentAuthorizationContextImpl;
import de.justsoftware.onx.authorization.business.impl.RightsService;
import de.justsoftware.onx.authorization.business.impl.RolesService;
import de.justsoftware.onx.common.business.configfile.ConfigFileService;
import de.justsoftware.onx.common.business.configfile.ConfigService;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.common.shared.model.Role;
import de.justsoftware.onx.common.shared.model.action.Action;
import de.justsoftware.onx.common.shared.model.action.StaticAction;
import de.justsoftware.onx.common.shared.model.action.StaticPermissionAction;
import de.justsoftware.onx.container.business.ItemService;
import de.justsoftware.onx.container.shared.model.ItemId;
import de.justsoftware.onx.container.shared.model.TenantId;
import de.justsoftware.onx.person.business.PersonRoleService;
import de.justsoftware.onx.person.business.PersonService;
import de.justsoftware.onx.searchnew.business.RolesSearchService;
import de.justsoftware.onx.tenant.business.PersonTenantService;
import de.justsoftware.onx.tenant.business.TenantService;
import de.justsoftware.permission.client.rest.PermissionRequestConnector;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@ParametersAreNonnullByDefault
@Service(value="authorizationContextProvider")
public class AuthorizationContextProviderImpl
implements AuthorizationContextProvider {
    @Autowired
    private PersonService _personService;
    @Autowired
    private PersonRoleService _personRoleService;
    @Autowired
    private RolesSearchService _rolesSearchService;
    @Autowired
    private ItemService _itemService;
    @Autowired
    private RolesService _rolesService;
    @Autowired
    private RightsService _rightsService;
    @Autowired
    private ConfigFileService _configFileService;
    @Autowired
    private Settings _settings;
    @Autowired
    private PermissionRequestConnector _permissionRequestConnector;
    @Autowired
    private PersonTenantService _personTenantService;
    @Autowired
    private TenantService _tenantService;
    @Autowired
    private ConfigService _configService;

    @Override
    public AuthorizationContext getAuthorizationContextForUser(PersonId userId) {
        Optional<TenantId> tenantIdOptional = this.getTenantIdForPerson(userId);
        return this.getAuthorizationContext(userId, tenantIdOptional.orElse(null), null);
    }

    @Override
    public AuthorizationContext getAuthorizationContext(PersonId userId, @Nullable TenantId tenantId, @Nullable String locale) {
        AuthorizationContext authorizationContext = this.getAuthorizationContext(userId, tenantId, locale, this.getPersonIndependentAuthorizationContext());
        if (tenantId == null) {
            authorizationContext.check(StaticAction.ADMIN_MANAGE_TENANTS);
            Optional<TenantId> defaultTenant = this._tenantService.getOnlyTenant();
            if (defaultTenant.isPresent()) {
                return this.getAuthorizationContext(userId, defaultTenant.get(), locale);
            }
        } else {
            authorizationContext.check((ItemId)tenantId, (Action)StaticPermissionAction.READ);
        }
        return authorizationContext;
    }

    private AuthorizationContext getAuthorizationContext(PersonId userId, @Nullable TenantId tenantId, @Nullable String locale, BasePersonIndependentAuthorizationContext personIndependentAuthorizationContext) {
        return new DefaultAuthorizationContext(userId, tenantId, locale, this._settings.defaultLanguage(), this._personService, this._rolesSearchService, personIndependentAuthorizationContext, this._permissionRequestConnector);
    }

    @Override
    public PersonIndependentAuthorizationContext getPersonIndependentAuthorizationContext() {
        return new PersonIndependentAuthorizationContextImpl(this._itemService, this._rolesService, this._rightsService, this._configFileService, this._personRoleService);
    }

    private Optional<TenantId> getTenantIdForPerson(PersonId personId) {
        return this._personTenantService.getTenantIdsForPerson(personId).stream().findFirst();
    }

    @Override
    public AuthorizationCheckContextWithRole getAuthorizationContextForNotLoggedInUser() {
        return this.getAuthorizationCheckContextForRoles((ImmutableSet<? extends Role>)ImmutableSet.of());
    }

    @Override
    public AuthorizationCheckContextWithRole getAuthorizationCheckContextForRoles(ImmutableSet<? extends Role> roles) {
        return new AuthorizationCheckContextWithRole(roles, this.getPersonIndependentAuthorizationContext(), this._permissionRequestConnector);
    }
}

