/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.authorization.business.impl;

import com.freiheit.toro.common.shared.model.PermissionDeniedException;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Sets;
import de.justsoftware.onx.authorization.business.BasePersonIndependentAuthorizationContext;
import de.justsoftware.onx.authorization.business.impl.AbstractAuthorizationCheckContext;
import de.justsoftware.onx.common.shared.model.Creator;
import de.justsoftware.onx.common.shared.model.Role;
import de.justsoftware.onx.common.shared.model.action.Action;
import de.justsoftware.onx.container.shared.model.Identifiables;
import de.justsoftware.onx.container.shared.server.model.Item;
import de.justsoftware.onx.person.model.DBPerson;
import de.justsoftware.permission.client.rest.PermissionRequestConnector;
import java.util.Set;
import javax.annotation.Nonnull;

public class AuthorizationCheckContextWithRole
extends AbstractAuthorizationCheckContext {
    private final BasePersonIndependentAuthorizationContext _basePersonIndependentAuthorizationContext;

    public AuthorizationCheckContextWithRole(@Nonnull ImmutableSet<? extends Role> roles, @Nonnull BasePersonIndependentAuthorizationContext personIndependentAuthorizationContext, @Nonnull PermissionRequestConnector permissionRequestConnector) {
        super(permissionRequestConnector, roles);
        this._basePersonIndependentAuthorizationContext = personIndependentAuthorizationContext;
    }

    @Override
    public void checkItems(Iterable<? extends Item<?>> items, Set<? extends Action> actions) {
        ImmutableSetMultimap allowed = this.may(items, actions);
        for (Item<?> item : items) {
            Optional id = item != null ? Optional.of((Object)item.getId()) : Optional.absent();
            Sets.SetView forbidden = Sets.difference(actions, (Set)allowed.get((Object)id));
            if (forbidden.isEmpty()) continue;
            throw new PermissionDeniedException(String.format("Roles %s cannot perform actions %s on item %s.", this._rolesForNullUsers, forbidden, Identifiables.getIdFromNullable(item)));
        }
    }

    @Override
    public BasePersonIndependentAuthorizationContext getPersonIndependentAuthorizationContext() {
        return this._basePersonIndependentAuthorizationContext;
    }

    @Override
    protected DBPerson getCurrentPerson() {
        return null;
    }

    @Override
    public AuthorizationCheckContextWithRole getContextForRoles(ImmutableSet<? extends Role> roles) {
        return new AuthorizationCheckContextWithRole(roles, this._basePersonIndependentAuthorizationContext, this._permissionRequestConnector);
    }

    @Override
    ImmutableSet<de.justsoftware.permission.client.model.Role> getUserRoles() {
        return (ImmutableSet)this._rolesForNullUsers.stream().map(Creator::getName).map(de.justsoftware.permission.client.model.Role::create).collect(ImmutableSet.toImmutableSet());
    }
}

