/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.authorization.business.impl;

import com.freiheit.toro.common.shared.model.PermissionDeniedException;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Sets;
import de.justsoftware.onx.authorization.business.AuthorizationCheckContextWithUserId;
import de.justsoftware.onx.authorization.business.BasePersonIndependentAuthorizationContext;
import de.justsoftware.onx.authorization.business.impl.AbstractAuthorizationCheckContext;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.common.shared.model.action.Action;
import de.justsoftware.onx.container.shared.model.Identifiables;
import de.justsoftware.onx.container.shared.server.model.Item;
import de.justsoftware.onx.person.model.DBPerson;
import de.justsoftware.onx.person.shared.server.model.ProfileItem;
import de.justsoftware.permission.client.model.Role;
import de.justsoftware.permission.client.rest.PermissionRequestConnector;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

abstract class AbstractAuthorizationContextWithUserId
extends AbstractAuthorizationCheckContext
implements AuthorizationCheckContextWithUserId {
    protected AbstractAuthorizationContextWithUserId(@Nonnull PermissionRequestConnector permissionRequestConnector) {
        super(permissionRequestConnector, BasePersonIndependentAuthorizationContext.NO_ROLES);
    }

    @Override
    public DBPerson getCurrentPerson() {
        return this.getDBPerson(this.getUserId());
    }

    @CheckForNull
    protected final DBPerson getDBPerson(PersonId personId) {
        ProfileItem item = (ProfileItem)this.getItemById(personId.asProfileId());
        return item != null ? item.getPerson() : null;
    }

    @Override
    public void checkItems(Iterable<? extends Item<?>> items, Set<? extends Action> actions) {
        ImmutableSetMultimap allowed = this.may(items, actions);
        for (Item<?> item : items) {
            Optional id = item != null ? Optional.of((Object)item.getId()) : Optional.absent();
            Sets.SetView forbidden = Sets.difference(actions, (Set)allowed.get((Object)id));
            if (forbidden.isEmpty()) continue;
            PersonId personId = this.getUserId();
            throw new PermissionDeniedException(String.format("Person %s cannot perform actions %s on item %s.", personId.toString(), forbidden, Identifiables.getIdFromNullable(item)));
        }
    }

    @Override
    ImmutableSet<Role> getUserRoles() {
        return ImmutableSet.of((Object)Role.profileRole((long)this.getUserId().getId()));
    }
}

