/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.authorization.business;

import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import de.justsoftware.onx.common.shared.model.NameAndParam;
import de.justsoftware.onx.common.shared.model.Role;
import de.justsoftware.onx.common.shared.util.ValueOfMap;
import java.io.Serializable;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class PersonRole
implements Role,
Serializable {
    public static final Function<String, PersonRole> FROM_NAME = new Function<String, PersonRole>(){

        public PersonRole apply(String input) {
            return input != null ? BY_NAME.get(input) : null;
        }
    };
    private static final long serialVersionUID = 1L;
    private static final ValueOfMap<String, PersonRole> BY_NAME = new ValueOfMap<String, PersonRole>(){

        @Override
        protected PersonRole create(String key) {
            return new PersonRole(key);
        }
    };
    private final String _name;

    private PersonRole(@Nonnull String name) {
        this._name = name;
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Nonnull
    public static PersonRole valueOf(@Nonnull String string) {
        return BY_NAME.get(((String)Preconditions.checkNotNull((Object)string)).trim());
    }

    @CheckForNull
    public static PersonRole getPersonRoleByName(@Nullable String name) {
        String trimmed = Strings.nullToEmpty((String)name).trim();
        if (trimmed.isEmpty()) {
            return null;
        }
        return BY_NAME.get(trimmed);
    }

    public boolean equals(Object obj) {
        return this == obj || obj != null && obj instanceof PersonRole && Objects.equal((Object)((PersonRole)obj)._name, (Object)this._name);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this._name});
    }

    public String toString() {
        return this._name;
    }

    @Override
    public NameAndParam getNameAndParam() {
        return new NameAndParam(this, null);
    }

    @Override
    public PersonRole create(String param) {
        return this;
    }

    @Nonnull
    Object readResolve() {
        return PersonRole.valueOf(this._name);
    }

    @Nonnull
    public de.justsoftware.permission.client.model.Role asPermissionRole() {
        return de.justsoftware.permission.client.model.Role.staticRole((String)this._name);
    }
}

