/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.authorization.business;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import de.justsoftware.onx.common.shared.model.Authority;
import de.justsoftware.onx.common.shared.model.AuthorityCreator;
import de.justsoftware.onx.common.shared.model.NameAndParam;
import de.justsoftware.onx.common.shared.model.Role;
import de.justsoftware.onx.container.server.model.DBPrivacySelection;
import de.justsoftware.onx.container.shared.model.db.DBPrivacyType;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class AuthorityUtil {
    @Nonnull
    public static Authority valueOf(@Nonnull Map<String, ? extends AuthorityCreator> authorities, @Nonnull NameAndParam authorityName) throws IllegalArgumentException {
        return (Authority)AuthorityUtil.getNonnullFromMap(authorities, authorityName.getName()).create(authorityName.getParam());
    }

    @Nonnull
    public static <T extends AuthorityCreator> T getNonnullFromMap(@Nonnull Map<String, ? extends T> authorities, @Nonnull String name) throws IllegalArgumentException {
        AuthorityCreator creator = (AuthorityCreator)authorities.get(name);
        if (creator == null) {
            throw new IllegalArgumentException("[" + name + "] is not the name of an authority.");
        }
        return (T)creator;
    }

    @Nonnull
    public static Role valueOf(@Nonnull Map<String, ? extends Role> authorities, @Nonnull String authorityName) throws IllegalArgumentException {
        return AuthorityUtil.getNonnullFromMap(authorities, authorityName);
    }

    @Nonnull
    public static ImmutableSet<String> names(@Nullable Iterable<? extends Role> authorities) {
        if (authorities == null) {
            return ImmutableSet.of();
        }
        return FluentIterable.from(authorities).transform(Role.TO_NAME).filter(Predicates.notNull()).toSet();
    }

    @Nonnull
    public static ImmutableSet<String> getAuthorityNamesForType(@Nullable Iterable<DBPrivacySelection> privacy, final @Nonnull DBPrivacyType type) {
        if (privacy == null) {
            return ImmutableSet.of();
        }
        return ImmutableSet.copyOf((Iterable)Iterables.transform((Iterable)Iterables.filter(privacy, (Predicate)new Predicate<DBPrivacySelection>(){

            public boolean apply(DBPrivacySelection input) {
                return input != null && input.getPrivacyType().equals((Object)type);
            }
        }), DBPrivacySelection.TO_NAME));
    }
}

