/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.auditing.server;

import com.google.common.annotations.VisibleForTesting;
import de.justsoftware.onx.auditing.business.AuditingService;
import de.justsoftware.onx.auditing.server.AuditingAspectData;
import de.justsoftware.onx.auditing.server.AuditingToStringUtil;
import de.justsoftware.onx.auditing.shared.AuditIgnore;
import de.justsoftware.onx.auditing.shared.AuditSensitive;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.aspectj.lang.Signature;
import org.aspectj.lang.reflect.MethodSignature;

public final class AuditingUtil {
    private static volatile AuditingService _auditingService;
    private static final ThreadLocal<AuditingAspectData> THREAD_DATA;

    @VisibleForTesting
    public static void resetAuditingData() {
        THREAD_DATA.remove();
    }

    @Nonnull
    public static AuditingAspectData getAuditingData() {
        return THREAD_DATA.get();
    }

    public static boolean isAuditingEnabled() {
        return _auditingService != null;
    }

    public static void startAuditing(@Nonnull Class<?> targetClass, @Nonnull Signature signature, @Nonnull Object[] args) {
        AuditingAspectData auditingData = AuditingUtil.getAuditingData();
        if (auditingData.isRootCall() && signature instanceof MethodSignature) {
            auditingData.setMethodClass(targetClass).setMethodSignature((MethodSignature)signature).setMethodArgs(args).setStartTime();
        }
        auditingData.registerCall();
    }

    public static void endAuditing(@Nullable Object result) {
        AuditingAspectData auditingData = AuditingUtil.getAuditingData();
        auditingData.unregisterCall();
        if (auditingData.isRootCall()) {
            auditingData.setResult(result);
            AuditingUtil.endAuditing(auditingData);
        }
    }

    public static void endAuditing(@Nonnull Throwable error) {
        AuditingAspectData auditingData = AuditingUtil.getAuditingData();
        auditingData.unregisterCall();
        if (auditingData.isRootCall()) {
            auditingData.setError(error);
            AuditingUtil.endAuditing(auditingData);
        }
    }

    private static void endAuditing(@Nonnull AuditingAspectData auditingData) {
        try {
            if (AuditingUtil.isAuditingEnabled() && auditingData.isChangeHappened() && !auditingData.isIgnoreExecution()) {
                _auditingService.writeAuditingLog(auditingData);
            }
        }
        finally {
            AuditingUtil.resetAuditingData();
        }
    }

    public static void setService(@Nullable AuditingService auditingService) {
        _auditingService = auditingService;
    }

    @Nonnull
    public static String toAuditString(@Nullable Object object) {
        return AuditingToStringUtil.toAuditString(object);
    }

    @Nonnull
    public static String toAuditString(@Nonnull Method method, @Nullable Object object) {
        AuditSensitive a = method.getAnnotation(AuditSensitive.class);
        if (a != null) {
            return "********";
        }
        return AuditingUtil.toAuditString(object);
    }

    public static boolean shouldAppend(@Nonnull Field field) {
        return !field.isAnnotationPresent(AuditIgnore.class) && (!Modifier.isFinal(field.getModifiers()) || !Modifier.isStatic(field.getModifiers())) && !field.getType().getName().startsWith("[I");
    }

    public static boolean shouldAppend(@Nonnull Annotation[] annotations) {
        for (Annotation a : annotations) {
            if (!a.annotationType().isAssignableFrom(AuditIgnore.class)) continue;
            return false;
        }
        return true;
    }

    @Nonnull
    public static String getNameFor(@Nonnull AnnotatedElement element, @Nonnull String name) {
        return name.replaceFirst("_", "");
    }

    @Nonnull
    public static String getNameFor(@Nonnull Annotation[] annotations, @Nonnull String name) {
        return name;
    }

    @Nonnull
    public static String getNameFor(@Nonnull Class<?> type) {
        return AuditingUtil.getNameFor(type, type.getSimpleName());
    }

    @CheckForNull
    public static Object getValueFor(@Nonnull Field field, @Nonnull Object value) {
        AuditSensitive a = field.getAnnotation(AuditSensitive.class);
        if (a != null) {
            return "********";
        }
        try {
            return field.get(value);
        }
        catch (IllegalArgumentException e) {
            return e;
        }
        catch (IllegalAccessException e) {
            return e;
        }
    }

    @CheckForNull
    public static Object getValueFor(@Nonnull Annotation[] annotations, @Nullable Object value) {
        for (Annotation a : annotations) {
            if (!a.annotationType().isAssignableFrom(AuditSensitive.class)) continue;
            return "********";
        }
        return value;
    }

    static {
        THREAD_DATA = new ThreadLocal<AuditingAspectData>(){

            @Override
            protected AuditingAspectData initialValue() {
                return new AuditingAspectData();
            }
        };
    }
}

