/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.auditing.integration.persistence.model;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import de.justsoftware.onx.auditing.server.model.AuditingEntryId;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.common.shared.util.Dates;
import java.util.Date;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class DBAuditingEntry {
    private AuditingEntryId _id;
    private PersonId _userId;
    private Date _timestamp;
    private String _calledMethod;
    private String _result;

    public DBAuditingEntry(@Nonnull AuditingEntryId id, @Nullable PersonId userId, @Nonnull Date timestamp, @Nonnull String calledMethod, @Nonnull String result) {
        this._id = id;
        this._userId = userId;
        this._calledMethod = calledMethod;
        this._timestamp = Dates.clone(timestamp);
        this._result = result;
    }

    @Deprecated
    protected DBAuditingEntry() {
    }

    @Nonnull
    public AuditingEntryId getId() {
        return (AuditingEntryId)Preconditions.checkNotNull((Object)this._id);
    }

    public void setId(@Nonnull AuditingEntryId id) {
        this._id = id;
    }

    @CheckForNull
    public PersonId getUserId() {
        return this._userId;
    }

    public void setUserId(@Nullable PersonId userId) {
        this._userId = userId;
    }

    @Nonnull
    public Date getTimestamp() {
        return (Date)Preconditions.checkNotNull((Object)this._timestamp);
    }

    public void setTimestamp(@Nonnull Date timestamp) {
        this._timestamp = Dates.clone(timestamp);
    }

    @Nonnull
    public String getCalledMethod() {
        return (String)Preconditions.checkNotNull((Object)this._calledMethod);
    }

    public void setCalledMethod(@Nonnull String calledMethod) {
        this._calledMethod = calledMethod;
    }

    @Nonnull
    public String getResult() {
        return this._result;
    }

    public void setResult(@Nonnull String result) {
        this._result = result;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this._id).add("userId", (Object)this._userId).add("timestamp", (Object)this._timestamp).add("calledMethod", (Object)this._calledMethod).add("result", (Object)this._result).toString();
    }
}

