/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.auditing.business.impl;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import de.justsoftware.onx.auditing.business.AuditingLogger;
import de.justsoftware.onx.common.shared.model.PersonId;
import java.util.Date;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SLF4JAuditingLoggerImpl
implements AuditingLogger {
    private static final Logger LOG = LoggerFactory.getLogger(SLF4JAuditingLoggerImpl.class);

    @Override
    public void logExecution(PersonId userId, String calledMethod, ImmutableMap<String, String> parameterMap, String result, Date timestamp) {
        LOG.info(this.getLogText(userId, calledMethod, parameterMap, result));
    }

    @Nonnull
    @VisibleForTesting
    public String getLogText(@Nullable PersonId userId, @Nonnull String calledMethod, @Nonnull ImmutableMap<String, String> parameterMap, @Nonnull String result) {
        MoreObjects.ToStringHelper methodPart = MoreObjects.toStringHelper((String)calledMethod);
        for (Map.Entry arg : parameterMap.entrySet()) {
            methodPart.add((String)arg.getKey(), arg.getValue());
        }
        MoreObjects.ToStringHelper callPart = MoreObjects.toStringHelper((String)"call");
        callPart.add("user", (Object)userId).add("action", (Object)methodPart).add("result", (Object)result);
        return this.toOneLineString(callPart.toString());
    }

    @Nonnull
    private String toOneLineString(@Nonnull String string) {
        return string.replaceAll("\n", " ").replaceAll("\r", "").replaceAll("\t", "").replaceAll("[ ]+", " ");
    }
}

