/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.auditing.business.impl;

import de.justsoftware.onx.auditing.business.AuditingLogger;
import de.justsoftware.onx.auditing.business.AuditingService;
import de.justsoftware.onx.auditing.business.impl.AsyncAuditingTask;
import de.justsoftware.onx.auditing.server.AuditingAspectData;
import de.justsoftware.onx.auditing.server.AuditingUtil;
import java.util.concurrent.Executor;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;

@ParametersAreNonnullByDefault
public class AuditingServiceImpl
implements AuditingService,
ApplicationListener<ContextRefreshedEvent> {
    private final AuditingLogger _auditingLogger;
    private final Executor _auditingTaskExecutor;

    public AuditingServiceImpl(AuditingLogger auditingLogger, Executor auditingTaskExecutor) {
        this._auditingLogger = auditingLogger;
        this._auditingTaskExecutor = auditingTaskExecutor;
    }

    @Override
    public void writeAuditingLog(AuditingAspectData auditingData) {
        if (!auditingData.isIgnoreExecution() && auditingData.isChangeHappened()) {
            this._auditingTaskExecutor.execute(new AsyncAuditingTask(auditingData, this._auditingLogger));
        }
    }

    public void onApplicationEvent(ContextRefreshedEvent event) {
        AuditingUtil.setService(this);
    }
}

