/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.auditing;

import com.ibatis.sqlmap.client.SqlMapClient;
import com.ibatis.sqlmap.engine.transaction.TransactionException;
import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import de.justsoftware.onx.auditing.business.AuditingLogger;
import de.justsoftware.onx.auditing.business.AuditingService;
import de.justsoftware.onx.auditing.business.impl.AuditingServiceImpl;
import de.justsoftware.onx.auditing.business.impl.SLF4JAuditingLoggerImpl;
import de.justsoftware.onx.auditing.integration.persistence.ibatis.IbatisAuditingLogger;
import de.justsoftware.onx.auditing.integration.persistence.ibatis.impl.IbatisAuditingLoggerImpl;
import de.justsoftware.onx.common.shared.server.TransactionHelper;
import java.io.IOException;
import java.sql.SQLException;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.orm.ibatis.SqlMapClientFactoryBean;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

@Configuration
public class AuditingConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(AuditingConfiguration.class);

    @Bean
    @CheckForNull
    static AuditingService auditingService(ApplicationContext context, @Value(value="${auditing.enabled}") boolean auditingEnabled, @Value(value="${auditing.logger.type}") String loggerType) {
        if (!auditingEnabled) {
            LOG.info("Auditing disabled. Skip creating auditingService.");
            return null;
        }
        LOG.info("Auditing enabled. AuditingService with logger type {} will be created.", (Object)loggerType);
        AuditingLogger auditingLogger = (AuditingLogger)context.getBean(loggerType + "AuditingLogger", AuditingLogger.class);
        Executor auditingExecutor = (Executor)context.getBean("auditingExecutor", Executor.class);
        return new AuditingServiceImpl(auditingLogger, auditingExecutor);
    }

    @Bean
    @Nonnull
    @Lazy
    static AuditingLogger fileAuditingLogger() {
        return new SLF4JAuditingLoggerImpl();
    }

    @Bean
    @Nonnull
    @Lazy
    static IbatisAuditingLogger dbAuditingLogger(@Qualifier(value="auditingSqlMapClient") SqlMapClient auditingSqlMapClient, TransactionHelper transactionHelper) {
        return new IbatisAuditingLoggerImpl(auditingSqlMapClient, transactionHelper);
    }

    @Bean
    @Nonnull
    @Lazy
    static Executor auditingExecutor() {
        ThreadPoolTaskExecutor executor = new ThreadPoolTaskExecutor();
        executor.setCorePoolSize(3);
        executor.setMaxPoolSize(10);
        executor.setQueueCapacity(1000);
        executor.setRejectedExecutionHandler((RejectedExecutionHandler)new ThreadPoolExecutor.CallerRunsPolicy());
        return executor;
    }

    @Bean(name={"auditingDataSource"}, destroyMethod="close")
    @Lazy
    @CheckForNull
    static DataSource auditingDataSource(@Value(value="${auditing.enabled}") boolean auditingEnabled, @Value(value="${auditing.JDBC.ConnectionURL:${JDBC.ConnectionURL}}") String connectionURL, @Value(value="${auditing.JDBC.Driver:${JDBC.Driver}}") String driverClassName, @Value(value="${auditing.JDBC.Username:${JDBC.Username}}") String username, @Value(value="${auditing.JDBC.Password:${JDBC.Password}}") String password, @Value(value="${auditing.hikariCP.maximumPoolSize:10}") int maximumPoolSize, @Value(value="${auditing.hikariCP.minimumIdle:${auditing.hikariCP.maximumPoolSize:1}}") int minimumIdle, @Value(value="${auditing.hikariCP.connectionTimeout:30000}") long connectionTimeout, @Value(value="${auditing.hikariCP.idleTimeout:600000}") long idleTimeout, @Value(value="${auditing.hikariCP.maxLifetime:1800000}") long maxLifetime) {
        if (!auditingEnabled) {
            LOG.info("Auditing disabled. Skip creating auditingDataSource.");
            return null;
        }
        HikariConfig config = new HikariConfig();
        config.setPoolName("auditingHikariCP");
        config.setJdbcUrl(connectionURL);
        config.setUsername(username);
        config.setPassword(password);
        config.setDriverClassName(driverClassName);
        config.setMaximumPoolSize(maximumPoolSize);
        config.setMinimumIdle(minimumIdle);
        config.setConnectionTimeout(connectionTimeout);
        config.setIdleTimeout(idleTimeout);
        config.setMaxLifetime(maxLifetime);
        return new HikariDataSource(config);
    }

    @Bean
    @Lazy
    @Nonnull
    static SqlMapClient auditingSqlMapClient(@Value(value="${auditing.JDBC.DBType:${JDBC.DBType}}") String dbType, @Qualifier(value="auditingDataSource") DataSource auditingDataSource) throws InstantiationException, IllegalAccessException, IOException, SQLException, TransactionException {
        SqlMapClientFactoryBean factoryBean = new SqlMapClientFactoryBean();
        factoryBean.setConfigLocation((Resource)new ClassPathResource("etc/sql-map-config-auditing-" + dbType + ".xml"));
        factoryBean.setDataSource(auditingDataSource);
        factoryBean.afterPropertiesSet();
        return factoryBean.getObject();
    }
}

