/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.appswitcher.shared.model;

import com.google.common.base.Function;
import de.justsoftware.onx.appswitcher.shared.model.AppId;
import de.justsoftware.onx.common.shared.model.action.Action;
import de.justsoftware.onx.common.shared.model.action.StaticAction;
import de.justsoftware.onx.design.shared.model.ThemeAttributeType;
import de.justsoftware.onx.util.shared.NullPermeableFunction;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public enum CoreApp {
    CONVERSATIONS("CONVERSATIONS", "chat", ThemeAttributeType.APP_CHAT_BACKGROUND_COLOR, StaticAction.CONNECT_USE),
    SOCIAL("SOCIAL", "connect", ThemeAttributeType.APP_CONNECT_BACKGROUND_COLOR, null),
    DRIVE("DRIVE", "drive", ThemeAttributeType.APP_DRIVE_BACKGROUND_COLOR, null),
    TASKS("TASKS", "tasks", ThemeAttributeType.APP_TASKS_BACKGROUND_COLOR, null),
    PEOPLE("PEOPLE", "people", ThemeAttributeType.APP_PEOPLE_BACKGROUND_COLOR, null),
    NEWS("NEWS", "news", ThemeAttributeType.APP_NEWS_BACKGROUND_COLOR, null),
    WIKI("WIKI", "wiki", ThemeAttributeType.APP_WIKI_BACKGROUND_COLOR, null),
    ADMIN("ADMIN", "admin", ThemeAttributeType.APP_ADMIN_BACKGROUND_COLOR, null),
    SNOWBALL("SNOWBALL", "snowball", ThemeAttributeType.APP_NEWS_BACKGROUND_COLOR, null);

    public static final CoreApp ENTITY_DEFAULT;
    public static final Function<CoreApp, String> TO_NAME;
    private final AppId _appId;
    private final String _name;
    private final String _simpleName;
    private final ThemeAttributeType _themeAttributeType;
    private final Action _actionNeeded;

    private CoreApp(String name, @Nullable String simpleName, ThemeAttributeType themeAttributeType, Action actionNeeded) {
        this._name = name;
        this._simpleName = simpleName;
        this._themeAttributeType = themeAttributeType;
        this._actionNeeded = actionNeeded;
        this._appId = new AppId(simpleName);
    }

    @Nonnull
    public String getName() {
        return this._name;
    }

    @Nonnull
    public String getSimpleName() {
        return this._simpleName;
    }

    @Nonnull
    public ThemeAttributeType getThemeAttributeType() {
        return this._themeAttributeType;
    }

    @CheckForNull
    public Action getActionNeeded() {
        return this._actionNeeded;
    }

    @CheckForNull
    public static CoreApp valueOfOrNull(String name) {
        try {
            return CoreApp.valueOf(name);
        }
        catch (IllegalArgumentException | NullPointerException e) {
            return null;
        }
    }

    @CheckForNull
    public static CoreApp byAppId(AppId appId) {
        for (CoreApp app : CoreApp.values()) {
            if (!app.getAppId().equals(appId)) continue;
            return app;
        }
        return null;
    }

    @Nonnull
    public AppId getAppId() {
        return this._appId;
    }

    static {
        ENTITY_DEFAULT = SOCIAL;
        TO_NAME = new NullPermeableFunction<CoreApp, String>(){

            @Override
            protected String applySafe(CoreApp input) {
                return input.getName();
            }
        };
    }
}

