/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.appswitcher.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import de.justsoftware.onx.appswitcher.model.JustAppType;
import de.justsoftware.onx.appswitcher.model.UserAppConfig;
import de.justsoftware.onx.appswitcher.shared.model.AppId;
import de.justsoftware.onx.common.business.configfile.model.InitialVisibility;
import java.util.Arrays;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class UserExternalAppConfig
implements UserAppConfig {
    private final AppId _appId;
    private final String _name;
    private final String _url;
    private final String _appColor;
    private final String _icon;
    private final boolean _iFrameApp;
    private final boolean _openInSameTab;
    private final InitialVisibility _initialVisibility;

    @JsonCreator
    public UserExternalAppConfig(@JsonProperty(value="appId", required=true) AppId appId, @JsonProperty(value="name", required=true) String name, @JsonProperty(value="url", required=true) String url, @JsonProperty(value="appColor", required=true) String appColor, @Nullable @JsonProperty(value="icon", required=false) String icon, @JsonProperty(value="iFrameApp", required=true) boolean iFrameApp, @JsonProperty(value="openInSameTab", required=true) boolean openInSameTab, @JsonProperty(value="initialVisibility", required=true) InitialVisibility initialVisibility) {
        this._appId = appId;
        this._name = name;
        this._url = url;
        this._appColor = appColor;
        this._icon = icon;
        this._iFrameApp = iFrameApp;
        this._openInSameTab = openInSameTab;
        this._initialVisibility = initialVisibility;
    }

    @Override
    public AppId getAppId() {
        return this._appId;
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public JustAppType getType() {
        return JustAppType.EXTERNAL;
    }

    @Nonnull
    public String getUrl() {
        return this._url;
    }

    @Nonnull
    @JsonIgnore
    public String getAppColor() {
        return this._appColor;
    }

    @CheckForNull
    public String getIcon() {
        return this._icon;
    }

    public boolean isiFrameApp() {
        return this._iFrameApp;
    }

    public boolean isOpenInSameTab() {
        return this._openInSameTab;
    }

    @Override
    public InitialVisibility getInitialVisibility() {
        return this._initialVisibility;
    }

    @Override
    public <T> T visit(UserAppConfig.Visitor<T> v) {
        return v.visitExternalApp(this);
    }

    @Nonnull
    private Object[] hashObjects() {
        return new Object[]{this._appId, this._name, this._url, this._icon, this._appColor, this._iFrameApp, this._initialVisibility, this._openInSameTab};
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof UserExternalAppConfig && Arrays.equals(this.hashObjects(), ((UserExternalAppConfig)obj).hashObjects());
    }

    public int hashCode() {
        return Arrays.hashCode(this.hashObjects());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("appId", (Object)this._appId).add("name", (Object)this._name).add("url", (Object)this._url).add("icon", (Object)this._icon).add("appColor", (Object)this._appColor).add("iFrameApp", this._iFrameApp).add("openInSameTab", this._openInSameTab).add("initialVisibility", (Object)this._initialVisibility).toString();
    }
}

