/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.appswitcher.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import de.justsoftware.onx.appswitcher.model.JustAppType;
import de.justsoftware.onx.appswitcher.model.UserAppConfig;
import de.justsoftware.onx.appswitcher.shared.model.AppId;
import de.justsoftware.onx.appswitcher.shared.model.CoreApp;
import de.justsoftware.onx.common.business.configfile.model.InitialVisibility;
import de.justsoftware.onx.design.shared.model.ThemeAttributeType;
import java.util.Arrays;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class UserCoreAppConfig
implements UserAppConfig {
    private final AppId _appId;
    private final CoreApp _app;
    private final String _name;
    private final InitialVisibility _initialVisibility;

    public UserCoreAppConfig(CoreApp app, String name, InitialVisibility initialVisibility) {
        this._app = app;
        this._name = name;
        this._appId = this._app.getAppId();
        this._initialVisibility = initialVisibility;
    }

    @JsonCreator
    public UserCoreAppConfig(@JsonProperty(value="appId", required=true) AppId appId, @JsonProperty(value="name", required=true) String name, @JsonProperty(value="initialVisibility", required=true) InitialVisibility initialVisibility) {
        this._app = CoreApp.byAppId(appId);
        if (this._app == null) {
            throw new IllegalArgumentException("no core app by appId=" + appId);
        }
        this._name = name;
        this._appId = appId;
        this._initialVisibility = initialVisibility;
    }

    @Override
    public AppId getAppId() {
        return this._appId;
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public JustAppType getType() {
        return JustAppType.CORE;
    }

    @Override
    public InitialVisibility getInitialVisibility() {
        return this._initialVisibility;
    }

    @Nonnull
    @JsonIgnore
    public ThemeAttributeType getThemeAttributeType() {
        return this._app.getThemeAttributeType();
    }

    @Override
    public <T> T visit(UserAppConfig.Visitor<T> v) {
        return v.visitCoreApp(this);
    }

    @Nonnull
    private Object[] hashObjects() {
        return new Object[]{this._appId, this._app, this._initialVisibility};
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof UserCoreAppConfig && Arrays.equals(this.hashObjects(), ((UserCoreAppConfig)obj).hashObjects());
    }

    public int hashCode() {
        return Arrays.hashCode(this.hashObjects());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("appId", (Object)this._appId).add("app", (Object)this._app).add("initialVisibility", (Object)this._initialVisibility).toString();
    }
}

